/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.forpost;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostDevice;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostDeviceType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostObject;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostProtocol;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostPtzType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRecordType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRemoteMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRtspTransport;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.server.api.SmarthouseManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseCameraModelsAndBrands;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ForpostManager
extends SmarthouseManager {
    private static final String PARAM_ADMIN_LOGIN = "AdminLogin";
    private static final String PARAM_ADMIN_PASSWORD = "AdminPassword";
    private String serverUrl = null;
    private String adminLogin = null;
    private String adminPassword = null;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> requestProperties = null;

    public ForpostManager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("forpost.server.url");
        this.adminLogin = moduleSetup.get("forpost.admin.login");
        this.adminPassword = moduleSetup.get("forpost.admin.password");
        this.readTimeout = moduleSetup.getInt("forpost.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("forpost.request.timeout.connect", 10000);
    }

    public ResponseId addAccount(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddAccount", params, ResponseId.class);
    }

    public ResponseId editAccount(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditAccount", params, ResponseId.class);
    }

    public ResponseStatus deleteAccount(int id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(id));
        return this.doRequest("/system-api/DeleteAccount", params, ResponseStatus.class);
    }

    public ForpostAccount[] getAccounts() throws Exception {
        return this.doRequest("/system-api/GetAccounts", new HashMap<String, String>(), ForpostAccount[].class);
    }

    public ForpostAccount[] getIntercomAccounts() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("IsManagementAllowed", "1");
        return this.doRequest("/system-api/GetAccounts", params, ForpostAccount[].class);
    }

    public ForpostAccount[] getAccounts(int id, String name, String contractNumber) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (id > 0) {
            params.put("ID", String.valueOf(id));
        }
        if (name != null) {
            params.put("Name", name);
        }
        if (contractNumber != null) {
            params.put("ContractNumber", contractNumber);
        }
        return this.doRequest("/system-api/FindAccounts", params, ForpostAccount[].class);
    }

    public ResponseId addCamera(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddCamera", params, ResponseId.class);
    }

    public ResponseStatus syncCamera(int id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(id));
        return this.doRequest("/system-api/SyncCamera", params, ResponseStatus.class);
    }

    public ResponseId editCamera(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditCamera", params, ResponseId.class);
    }

    public ResponseStatus deleteCamera(int id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(id));
        return this.doRequest("/system-api/DeleteCamera", params, ResponseStatus.class);
    }

    public ForpostCamera[] getCameras(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/GetCameras", params, ForpostCamera[].class);
    }

    public ResponseId addDevice(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddDevice", params, ResponseId.class);
    }

    public ResponseId editDevice(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditDevice", params, ResponseId.class);
    }

    public ResponseStatus deleteDevice(int id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(id));
        return this.doRequest("/system-api/DeleteDevice", params, ResponseStatus.class);
    }

    public ResponseId bindDeviceToCameras(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/BindDeviceToCameras", params, ResponseId.class);
    }

    public ForpostMaster[] getMasters() throws Exception {
        return this.doRequest("/system-api/GetMasters", new HashMap<String, String>(), ForpostMaster[].class);
    }

    public ForpostRemoteMaster[] getRemoteMasters() throws Exception {
        return this.doRequest("/system-api/GetRemoteMasters", new HashMap<String, String>(), ForpostRemoteMaster[].class);
    }

    public ForpostCameraModel[] getCameraModels(int brandId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", brandId);
        return this.doRequest("/system-api/GetCameraModels", params, ForpostCameraModel[].class);
    }

    public ResponseCameraModelsAndBrands getCameraModelsAndBrands() throws Exception {
        return this.doRequest("/system-api/GetCameraModelsAndBrands", new HashMap<String, String>(), ResponseCameraModelsAndBrands.class);
    }

    public ForpostCameraBrand[] getCameraBrands() throws Exception {
        return this.doRequest("/system-api/GetCameraBrands", new HashMap<String, String>(), ForpostCameraBrand[].class);
    }

    public ForpostRecordType[] getRecordTypes() throws Exception {
        return this.doRequest("/system-api/GetRecordTypes", new HashMap<String, String>(), ForpostRecordType[].class);
    }

    public ForpostProtocol[] getProtocols() throws Exception {
        return this.doRequest("/system-api/GetProtocols", new HashMap<String, String>(), ForpostProtocol[].class);
    }

    public ForpostRtspTransport[] getRtspTransports() throws Exception {
        return this.doRequest("/system-api/GetRtspTransports", new HashMap<String, String>(), ForpostRtspTransport[].class);
    }

    public ForpostPtzType[] getPtzTypes() throws Exception {
        return this.doRequest("/system-api/GetPTZTypes", new HashMap<String, String>(), ForpostPtzType[].class);
    }

    public ForpostCamera[] getCameras(int accountId, Integer cameraId, Integer includeParentGroups) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "AccountID", accountId);
        Optional.ofNullable(cameraId).ifPresent(a -> this.addParam((Map<String, String>)params, "ID", (int)a));
        Optional.ofNullable(includeParentGroups).ifPresent(a -> this.addParam((Map<String, String>)params, "IncludeParentGroups", (int)a));
        return this.doRequest("/system-api/GetCameras", params, ForpostCamera[].class);
    }

    public ForpostUser[] getAccountUsers(int accountId, Integer userId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        Optional.ofNullable(userId).ifPresent(a -> this.addParam((Map<String, String>)params, "ID", (int)a));
        this.addParam(params, "AccountID", accountId);
        return this.doRequest("/system-api/GetAccountUsers", params, ForpostUser[].class);
    }

    public ResponseId addUser(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddUser", params, ResponseId.class);
    }

    public ResponseId editUser(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditUser", params, ResponseId.class);
    }

    public ResponseId editUserPassword(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditUserPassword", params, ResponseId.class);
    }

    public ResponseStatus deleteUser(int userId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", userId);
        return this.doRequest("/system-api/DeleteUser", params, ResponseStatus.class);
    }

    public ForpostObject[] getObjects(int accountId, int objectId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", objectId);
        this.addParam(params, "AccountID", accountId);
        return this.doRequest("/system-api/GetObjects", params, ForpostObject[].class);
    }

    public ResponseId addObject(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddObject", params, ResponseId.class);
    }

    public ResponseId editObject(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditObject", params, ResponseId.class);
    }

    public ResponseStatus deleteObject(int objectId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", objectId);
        return this.doRequest("/system-api/DeleteObject", params, ResponseStatus.class);
    }

    public ResponseId addAccountGroup(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/AddAccountGroup", params, ResponseId.class);
    }

    public ResponseId editAccountGroup(int id, String name, int parentId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", id);
        this.addParam(params, "Name", name);
        this.addParam(params, "ParentID", parentId);
        return this.editAccountGroup(params);
    }

    public ResponseId editAccountGroup(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/EditAccountGroup", params, ResponseId.class);
    }

    public ResponseStatus deleteAccountGroup(int groupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "ID", groupId);
        return this.doRequest("/system-api/DeleteAccountGroup", params, ResponseStatus.class);
    }

    public ForpostGroup[] getAccountGroups(Integer id, String name, Integer accountId, Integer cameraId, Integer bindAccountId, Integer parentId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "Name", name);
        Optional.ofNullable(id).ifPresent(a -> params.put("ID", String.valueOf(a)));
        Optional.ofNullable(parentId).ifPresent(a -> params.put("ParentID", String.valueOf(a)));
        Optional.ofNullable(cameraId).ifPresent(a -> params.put("CameraID", String.valueOf(a)));
        Optional.ofNullable(accountId).ifPresent(a -> params.put("AccountID", String.valueOf(a)));
        Optional.ofNullable(bindAccountId).ifPresent(a -> params.put("BindAccountID", String.valueOf(a)));
        return this.getAccountGroups(params);
    }

    public ForpostGroup[] getAccountGroups(Map<String, String> params) throws Exception {
        return this.doRequest("/system-api/GetAccountGroups", params, ForpostGroup[].class);
    }

    public ForpostDeviceType[] getAccountDeviceType() throws Exception {
        return this.doRequest("/system-api/GetDeviceTypes", new HashMap<String, String>(), ForpostDeviceType[].class);
    }

    public ForpostDevice[] getAccountDevices(int accountId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, "AccountID", accountId);
        return this.doRequest("/system-api/GetDevices", params, ForpostDevice[].class);
    }

    private void addParam(Map<String, String> params, String name, int value) {
        if (value > 0) {
            params.put(name, String.valueOf(value));
        }
    }

    private void addParam(Map<String, String> params, String name, String value) {
        if (value != null) {
            params.put(name, value);
        }
    }

    protected <T> T doRequest(String uri, Map<String, String> params, Class<T> clazz) throws Exception {
        InputStream inputStream;
        if (this.serverUrl == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"forpost.server.url=\"");
        }
        URL url = new URL(this.serverUrl + uri);
        StringBuilder debug = new StringBuilder();
        if (this.getLogger().isDebugEnabled()) {
            debug.append("\n\t\u0424\u041e\u0420\u041f\u041e\u0421\u0422: URL \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + this.serverUrl + uri + "\n");
        }
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod("POST");
        if (this.requestProperties != null && !this.requestProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        connection.setDoOutput(true);
        connection.setDoInput(true);
        if (this.adminLogin == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"forpost.admin.login=\"");
        }
        params.put(PARAM_ADMIN_LOGIN, this.adminLogin);
        if (this.adminPassword == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"forpost.admin.password=\"");
        }
        params.put(PARAM_ADMIN_PASSWORD, this.adminPassword);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
        bw.write(new ArrayList<Map.Entry<String, String>>(params.entrySet()).stream().map(a -> (String)a.getKey() + "=" + this.encodeString((String)a.getValue())).collect(Collectors.joining("&")).toCharArray());
        bw.close();
        if (this.getLogger().isDebugEnabled()) {
            String text = new ArrayList<Map.Entry<String, String>>(params.entrySet()).stream().map(a -> (String)a.getKey() + "=" + (((String)a.getKey()).toLowerCase().contains("password") ? "*".repeat(((String)a.getValue()).length()) : this.encodeString((String)a.getValue()))).collect(Collectors.joining("&"));
            debug.append("\t\u0424\u041e\u0420\u041f\u041e\u0421\u0422: \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + text + "\n");
        }
        connection.connect();
        StringBuilder result = new StringBuilder();
        boolean error = connection.getResponseCode() != 200;
        InputStream inputStream2 = inputStream = error ? connection.getErrorStream() : connection.getInputStream();
        if (inputStream != null) {
            if (this.getLogger().isDebugEnabled()) {
                debug.append("\t\u0424\u041e\u0420\u041f\u041e\u0421\u0422: ContentLength = " + connection.getContentLength() + "\n");
            }
            result.append(new String(Utils.readByBlock((InputStream)inputStream), "UTF-8"));
        } else {
            this.getLogger().error("connection.getResponseCode() = " + connection.getResponseCode());
            this.getLogger().error("inputStream = " + String.valueOf(inputStream));
        }
        connection.disconnect();
        if (error) {
            String txt = result.toString();
            if (txt.startsWith("{")) {
                JSONObject json = new JSONObject(txt);
                throw new ForpostException(json.optInt("ErrorCode", 0), json.optString("Error"));
            }
            throw new BGException(txt);
        }
        if (this.getLogger().isDebugEnabled()) {
            debug.append("\t\u0424\u041e\u0420\u041f\u041e\u0421\u0422: \u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + String.valueOf(result));
            this.getLogger().debug(debug.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        String resulrStr = result.toString();
        if (resulrStr.startsWith("{")) {
            int errorCode;
            JSONObject resultJson = new JSONObject(resulrStr);
            if (resultJson.has("ErrorCode") && (errorCode = resultJson.optInt("ErrorCode")) > 0) {
                throw new BGMessageException("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0424\u043e\u0440\u043f\u043e\u0441\u0442: " + resultJson.optString("Error") + " [ErrorCode=" + errorCode + "]");
            }
            return (T)mapper.readValue(resulrStr, clazz);
        }
        if (resulrStr.startsWith("[")) {
            return (T)mapper.readValue(resulrStr, clazz);
        }
        return null;
    }

    private String encodeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception e) {
            this.getLogger().error("string = " + string, (Throwable)e);
            return "";
        }
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }
}

