/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractBalanceUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionShowBalance
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        List<String> messages;
        Element element;
        GregorianCalendar nowDate = new GregorianCalendar();
        int mm = this.getIntParameter("month", nowDate.get(2) + 1);
        int yy = this.getIntParameter("year", nowDate.get(1));
        ContractBalanceUtils.WebBalanceData webBalanceData = ContractBalanceUtils.getWebBalanceData(this.con, this.cid, mm, yy);
        this.rootNode.setAttribute("status", "");
        Element dateElement = this.createElement(this.rootNode, "date");
        dateElement.setAttribute("month", String.valueOf(mm));
        dateElement.setAttribute("year", String.valueOf(yy));
        Element balance = this.createElement(this.rootNode, "balance");
        Element accounts = this.createElement(balance, "accounts");
        Element payments = this.createElement(balance, "payments");
        Element charges = this.createElement(balance, "charges");
        for (Payment payment : webBalanceData.getPaymentList()) {
            element = this.createElement(payments, "payment");
            element.setAttribute("title", TimeUtils.format((Date)payment.getDate(), (String)"dd.MM.yyyy") + " " + webBalanceData.getPaymentTypeMap().get(payment.getTypeId()).getTitle() + (Utils.notEmptyString((String)payment.getComment()) ? "( ".concat(payment.getComment()).concat(" )") : ""));
            element.setAttribute("value", payment.getSum().toPlainString());
        }
        for (Charge charge : webBalanceData.getChargeList()) {
            element = this.createElement(charges, "charge");
            element.setAttribute("title", TimeUtils.format((Date)charge.getDate(), (String)"dd.MM.yyyy") + " " + webBalanceData.getChargeTypeMap().get(charge.getTypeId()).getTitle() + (Utils.notEmptyString((String)charge.getComment()) ? "( ".concat(charge.getComment()).concat(" )") : ""));
            element.setAttribute("value", charge.getSum().toPlainString());
        }
        for (String[] str : webBalanceData.getAccountList()) {
            Element account = this.createElement(accounts, "account");
            account.setAttribute("title", str[0]);
            account.setAttribute("value", str[1]);
        }
        balance.setAttribute("summa1", Utils.formatBigDecimalSumm((BigDecimal)webBalanceData.getSumma1()));
        balance.setAttribute("summa2", Utils.formatBigDecimalSumm((BigDecimal)webBalanceData.getSumma2()));
        balance.setAttribute("summa3", Utils.formatBigDecimalSumm((BigDecimal)webBalanceData.getSumma3()));
        balance.setAttribute("summa4", Utils.formatBigDecimalSumm((BigDecimal)webBalanceData.getSumma4()));
        balance.setAttribute("summa5", Utils.formatBigDecimalSumm((BigDecimal)webBalanceData.getSumma1().add(webBalanceData.getSumma2()).subtract(webBalanceData.getSumma3()).subtract(webBalanceData.getSumma4())));
        balance.setAttribute("limit", Utils.formatBigDecimalSumm((BigDecimal)webBalanceData.getContract().getBalanceLimit()));
        if (webBalanceData.getContractManager().getSubContracts(this.cid, 1).size() > 0) {
            this.rootNode.setAttribute("has_independent_subs", "1");
        }
        if ((messages = webBalanceData.getEvent().getMessages()).size() > 0) {
            Element messagesEl = this.createElement(this.rootNode, "messages");
            for (String message : messages) {
                Element messageEl = this.createElement(messagesEl, "message");
                messageEl.setAttribute("text", message);
            }
        }
    }
}

