/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.update.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.update.common.dto.UpdaterUnitItem;
import ru.bitel.bgbilling.kernel.update.common.service.UpdaterService;
import ru.bitel.bgbilling.kernel.update.server.bean.UpdaterUnit;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.update.common.service.UpdaterService")
public class UpdaterServiceImpl
extends AbstractService
implements UpdaterService {
    @Override
    public SearchResult<UpdaterUnitItem> updaterUnitItemSearch(String componentKey, String status, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(this.getUpdaterUnitItemList());
        return searchResult;
    }

    private List<UpdaterUnitItem> getUpdaterUnitItemList() {
        ArrayList<UpdaterUnitItem> list = new ArrayList<UpdaterUnitItem>();
        this.buildUpdaterUnitItemList("ru.bitel.bgbilling.kernel.update.server.unit", "kernel", "0", list);
        for (BGModule bgModule : ModuleCache.getInstance().getModulesList()) {
            this.buildUpdaterUnitItemList(bgModule.getInstalledModule().getPackageServer() + ".unit", bgModule.getName(), String.valueOf(bgModule.getId()), list);
        }
        for (BGInstalledModule bgInstalledModule : ModuleCache.getInstance().getInstalledModulesList().stream().filter(n -> n.getType() == ComponentType.PLUGIN).toList()) {
            this.buildUpdaterUnitItemList(bgInstalledModule.getPackageServer() + ".unit", bgInstalledModule.getName(), String.valueOf(bgInstalledModule.getId()), list);
        }
        return list;
    }

    private void buildUpdaterUnitItemList(String packageName, String componentName, String unitId, List<UpdaterUnitItem> list) {
        block2: for (Class clazz : Utils.getClassList((String)packageName)) {
            Class<?>[] classInterfaces;
            for (Class<?> clazzIf : classInterfaces = clazz.getInterfaces()) {
                if (clazzIf != UpdaterUnit.class) continue;
                try {
                    UpdaterUnit updaterUnit = clazz.asSubclass(UpdaterUnit.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    UpdaterUnitItem updaterUnitItem = updaterUnit.toUpdaterUnitItem();
                    updaterUnitItem.setComponentName(componentName);
                    updaterUnitItem.setUnitId(unitId);
                    list.add(updaterUnitItem);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue block2;
            }
        }
    }
}

