/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.plugins.sqleditor.client.QueryInfo;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLEditor;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLListCellRenderer;

class SQLList
extends JList<QueryInfo> {
    static final String ACTION_COMMAND_RUN = "run";
    static final String ACTION_COMMAND_COPY = "copy";
    static final String ACTION_COMMAND_SAVE = "save";
    static final String ACTION_COMMAND_DELETE = "delete";
    static final String ACTION_COMMAND_DELETE_HISTORY = "deleteHistory";
    static final String ACTION_COMMAND_RUN_IN_NEW = "runInNew";
    protected SQLEditor sqlEditor = null;
    private JPopupMenu popupMenu = null;
    private List<String> buttons = new ArrayList<String>();
    private ActionListener actionListener = null;
    private DefaultListModel<QueryInfo> listModel = new DefaultListModel();

    SQLList(final SQLEditor sqlEditor, List<String> buttons) {
        this.buttons = buttons;
        this.sqlEditor = sqlEditor;
        this.setModel(this.listModel);
        this.setCellRenderer(new SQLListCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int index = SQLList.this.locationToIndex(mouseEvent.getPoint());
                if (index != SQLList.this.getSelectedIndex()) {
                    SQLList.this.setSelectedIndex(index);
                }
                if (index > -1 && mouseEvent.getClickCount() == 2) {
                    sqlEditor.selectectQueryTab();
                    sqlEditor.getQuery().setText(((QueryInfo)SQLList.this.getSelectedValue()).getQuery());
                }
                if (!SQLList.this.isSelectionEmpty() && SwingUtilities.isRightMouseButton(mouseEvent) && index == SQLList.this.getSelectedIndex() && SQLList.this.getSelectedIndex() > -1) {
                    SQLList.this.getPopupMenu().show(SQLList.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
            menuItem.addActionListener(this.getActionListener());
            menuItem.setActionCommand(ACTION_COMMAND_RUN);
            this.popupMenu.add(menuItem);
            menuItem = new JMenuItem("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u043d\u043e\u0432\u043e\u0439 \u0432\u043a\u043b\u0430\u0434\u043a\u0435");
            menuItem.addActionListener(this.getActionListener());
            menuItem.setActionCommand(ACTION_COMMAND_RUN_IN_NEW);
            this.popupMenu.add(menuItem);
            menuItem = new JMenuItem("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
            menuItem.addActionListener(this.getActionListener());
            menuItem.setActionCommand(ACTION_COMMAND_COPY);
            this.popupMenu.add(menuItem);
            if (this.buttons.contains("saveButton")) {
                menuItem = new JMenuItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u0437 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430");
                menuItem.addActionListener(this.getActionListener());
                menuItem.setActionCommand(ACTION_COMMAND_SAVE);
                this.popupMenu.add(menuItem);
            }
            if (this.buttons.contains("deleteButton")) {
                menuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
                menuItem.addActionListener(this.getActionListener());
                menuItem.setActionCommand(ACTION_COMMAND_DELETE);
                this.popupMenu.add(menuItem);
            }
            if (this.buttons.contains("deleteHistoryButton")) {
                menuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
                menuItem.addActionListener(this.getActionListener());
                menuItem.setActionCommand(ACTION_COMMAND_DELETE_HISTORY);
                this.popupMenu.add(menuItem);
            }
        }
        return this.popupMenu;
    }

    protected ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = actionEvent -> {
                if (ACTION_COMMAND_RUN.equals(actionEvent.getActionCommand())) {
                    this.sqlEditor.selectResultSetPanel(false, ((QueryInfo)this.getSelectedValue()).getQuery());
                } else if (ACTION_COMMAND_RUN_IN_NEW.equals(actionEvent.getActionCommand())) {
                    this.sqlEditor.selectResultSetPanel(true, ((QueryInfo)this.getSelectedValue()).getQuery());
                } else if (ACTION_COMMAND_COPY.equals(actionEvent.getActionCommand())) {
                    this.sqlEditor.selectectQueryTab();
                    this.sqlEditor.addQueryToEditor(((QueryInfo)this.getSelectedValue()).getQuery());
                } else if (ACTION_COMMAND_SAVE.equals(actionEvent.getActionCommand())) {
                    QueryInfo queryInfo = (QueryInfo)this.getSelectedValue();
                    this.sqlEditor.saveTemplate(queryInfo.getTitle(), "-1".equals(queryInfo.getId()));
                } else if (ACTION_COMMAND_DELETE.equals(actionEvent.getActionCommand())) {
                    this.sqlEditor.deleteSQLTemplate(((QueryInfo)this.getSelectedValue()).getId());
                } else if (ACTION_COMMAND_DELETE_HISTORY.equals(actionEvent.getActionCommand())) {
                    this.deleteHistoryEntry();
                }
            };
        }
        return this.actionListener;
    }

    protected DefaultListModel<QueryInfo> getListModel() {
        return this.listModel;
    }

    protected void deleteHistoryEntry() {
    }
}

