/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGFileFilter;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.client.RoleTreeTablePanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.common.dto.AssistantActionDTO;
import ru.bitel.bgbilling.plugins.assistant.common.dto.AssistantMasterDTO;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;

public class AssistantMastersTab
extends BGUPanel {
    private AssistantMasterTableModel masterTableModel = new AssistantMasterTableModel();

    protected void jbInit() throws Exception {
        BGUTable masterTable = new BGUTable((TableModel)((Object)this.masterTableModel));
        masterTable.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add(new JLabel("\u0421\u043f\u0438\u0441\u043e\u043a \u043c\u0430\u0441\u0442\u0435\u0440\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)masterTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        BGSwingUtilites.handleEdit((JTable)masterTable, (AbstractBGUPanel)this);
    }

    private AssistantService getAssistantService() {
        return (AssistantService)((ClientContext)this.getContext()).getWebService(AssistantService.class);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.masterTableModel.setData(this.getAssistantService().assistantMasters())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new AssistantMasterEditor("\u041d\u043e\u0432\u044b\u0439 \u043c\u0430\u0441\u0442\u0435\u0440", new AssistantMaster()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            AssistantMasterDTO assistantMasterDTO = (AssistantMasterDTO)this.masterTableModel.getSelectedRow();
            if (assistantMasterDTO == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0430\u0441\u0442\u0435\u0440 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            this.tryCall(() -> {
                AssistantMaster assistantMaster = this.getAssistantService().assistantMasterGet(assistantMasterDTO.getId(), true);
                if (assistantMaster == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043c\u0430\u0441\u0442\u0435\u0440\u0430");
                    return;
                }
                new AssistantMasterEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0430\u0441\u0442\u0435\u0440\u0430", assistantMaster).getDialog().setVisible(true);
            });
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            AssistantMasterDTO assistantMasterDTO = (AssistantMasterDTO)this.masterTableModel.getSelectedRow();
            if (assistantMasterDTO == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0430\u0441\u0442\u0435\u0440 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete((Object)assistantMasterDTO.getGuiTitle())) {
                this.getAssistantService().assistantMasterDelete(assistantMasterDTO.getId());
                this.performAction("refresh");
            }
        });
    }

    class AssistantMasterTableModel
    extends BGTableModel<AssistantMasterDTO> {
        public AssistantMasterTableModel() {
            super(AssistantMasterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, 200, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 100, 100, "status", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0439", 100, 100, 100, "actionCounter", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 200, 200, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class AssistantMasterEditor
    extends BGEditorDialog<AssistantMaster> {
        private JTabbedPane tabbedPane;
        private BGTextField title;
        private BGUComboBox<IdTitle> status;
        private BGUComboBox<AssistantActionDTO> actions;
        private BGTextArea comment;
        private BGUList<AssistantActionDTO> actionSelected;
        private BGUList<AssistantActionDTO> actionAvailable;
        private JLabel icon;
        private JCheckBox showClient;
        private JCheckBox showClientContract;
        private JCheckBox showWebAssistant;
        private JCheckBox showMobileAssistant;
        private JCheckBox showWebLKAssistant;
        private JCheckBox showBotAssistant;
        private RoleTreeTablePanel roleTreeTablePanel;
        private List<IdTitle> statusItems;
        private List<AssistantActionDTO> libraryActionItems;
        private List<AssistantActionDTO> masterActionItems;

        public AssistantMasterEditor(String title, AssistantMaster data) {
            super(title, (Object)data);
            this.tabbedPane = new JTabbedPane();
            this.title = new BGTextField(50);
            this.status = new BGUComboBox();
            this.actions = new BGUComboBox();
            this.comment = new BGTextArea(3, 50);
            this.actionSelected = new BGUList();
            this.actionAvailable = new BGUList();
            this.icon = new JLabel();
            this.showClient = new JCheckBox("\u043a\u043b\u0438\u0435\u043d\u0442 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
            this.showClientContract = new JCheckBox("\u043a\u043b\u0438\u0435\u043d\u0442 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 (\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440)");
            this.showWebAssistant = new JCheckBox("web-\u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a");
            this.showMobileAssistant = new JCheckBox("mobile-\u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a");
            this.showWebLKAssistant = new JCheckBox("web \u043b\u0438\u0447\u043d\u044b\u0439 \u043a\u0430\u0431\u0438\u043d\u0435\u0442");
            this.showBotAssistant = new JCheckBox("bot-\u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a");
            this.roleTreeTablePanel = new RoleTreeTablePanel(true, false);
            this.statusItems = Arrays.asList(new IdTitle(1, "\u0432\u043a\u043b\u044e\u0447\u0435\u043d"), new IdTitle(0, "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d"));
            this.libraryActionItems = new ArrayList<AssistantActionDTO>();
            this.masterActionItems = new ArrayList<AssistantActionDTO>();
        }

        public void doDialogPanel() {
            this.roleTreeTablePanel.setBorder(BorderFactory.createEmptyBorder());
            this.tabbedPane.add((Component)this.getGeneralPanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043c\u0430\u0441\u0442\u0435\u0440\u0430");
            this.tabbedPane.add((Component)this.getActionsPanel(), "\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
            this.tabbedPane.add((Component)this.roleTreeTablePanel, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430");
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            try {
                this.libraryActionItems = AssistantMastersTab.this.getAssistantService().assistantActionList(0);
                this.masterActionItems = AssistantMastersTab.this.getAssistantService().assistantActionList(((AssistantMaster)this.data).getId()).stream().filter(a -> a.getMasterId() > 0).toList();
                this.setActionData();
                this.roleTreeTablePanel.setRoles(((RoleService)((ClientContext)AssistantMastersTab.this.getContext()).getWebService(RoleService.class)).getRoleItems(true, false));
                this.roleTreeTablePanel.setCheckedRoles(((AssistantMaster)this.data).getRoleIds());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.title.setText(((AssistantMaster)this.data).getTitle());
            this.status.setSelectedItem((Object)this.statusItems.stream().filter(a -> a.getId() == ((AssistantMaster)this.data).getStatus()).findFirst().orElse(this.statusItems.get(0)));
            this.comment.setText(((AssistantMaster)this.data).getComment());
            this.showClient.setSelected(((AssistantMaster)this.data).isShowClient());
            this.showClientContract.setSelected(((AssistantMaster)this.data).isShowClientContract());
            this.showWebAssistant.setSelected(((AssistantMaster)this.data).isShowWebAssistant());
            this.showMobileAssistant.setSelected(((AssistantMaster)this.data).isShowMobileAssistant());
            this.showWebLKAssistant.setSelected(((AssistantMaster)this.data).isShowWebLKAssistant());
            this.showBotAssistant.setSelected(((AssistantMaster)this.data).isShowBotAssistant());
        }

        private JPanel getGeneralPanel() {
            this.status.setData(this.statusItems);
            this.actions.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    ((AssistantMaster)this.data).setStartActionId(((AssistantActionDTO)this.actions.getSelectedItem()).getActionId());
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)this.status, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)this.actions, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.comment, (int)500, (int)70), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
            panel.add((Component)this.getIconAndShowPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getActionsPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.actionSelected, (int)350, (int)350), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
            panel.add((Component)this.getActionsButtonPanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.actionAvailable, (int)350, (int)350), new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getActionsButtonPanel() {
            BGButton add = new BGButton("<<<");
            add.addActionListener(e -> {
                ((AssistantMaster)this.data).getActionIds().addAll(this.actionAvailable.getSelectedValuesList().stream().map(a -> a.getId()).toList());
                this.setActionData();
            });
            BGButton remove = new BGButton(">>>");
            remove.addActionListener(e -> {
                ((AssistantMaster)this.data).getActionIds().removeAll(this.actionSelected.getSelectedValuesList().stream().filter(a -> a.getMasterId() == 0).map(a -> a.getId()).toList());
                this.setActionData();
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)add, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)remove, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getIconAndShowPanel() {
            JPanel panel = new JPanel(new GridLayout(1, 2));
            panel.add(this.getIconPanel());
            panel.add(this.getShowPanel());
            return panel;
        }

        private JPanel getIconPanel() {
            this.icon.setIcon(this.getImageIcon(Utils.notBlankString((String)((AssistantMaster)this.data).getIconData()) ? new ImageIcon(Base64.getDecoder().decode(((AssistantMaster)this.data).getIconData())) : ClientUtils.getIcon((String)"assistant_default.png")));
            this.icon.setBackground(Color.WHITE);
            this.icon.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.icon.setOpaque(true);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    BGFileChooser fileChooser = new BGFileChooser((Component)BGClient.getFrame());
                    fileChooser.setFileFilter((FileFilter)new BGFileFilter("png|gif|ico", "\u0424\u0430\u0439\u043b\u044b PNG,GIF,ICO"));
                    if (fileChooser.showOpenDialog((Component)BGClient.getFrame()) == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        try {
                            ImageIcon imageIcon = AssistantMasterEditor.this.getImageIcon(new ImageIcon(Files.readAllBytes(selectedFile.toPath())));
                            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
                            Graphics2D graphics = bufferedImage.createGraphics();
                            graphics.setComposite(AlphaComposite.Clear);
                            graphics.fillRect(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
                            graphics.setComposite(AlphaComposite.Src);
                            imageIcon.paintIcon(null, graphics, 0, 0);
                            graphics.dispose();
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)bufferedImage, "png", bos);
                            ((AssistantMaster)AssistantMasterEditor.this.data).setIconData(Base64.getEncoder().encodeToString(bos.toByteArray()));
                            AssistantMasterEditor.this.icon.setIcon(imageIcon);
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                }
            });
            panel.setBorder(BorderFactory.createTitledBorder("\u0418\u043a\u043e\u043d\u043a\u0430"));
            panel.add((Component)this.icon, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private ImageIcon getImageIcon(ImageIcon imageIcon) {
            Image image = imageIcon.getImage();
            Image newimg = image.getScaledInstance(64, 64, 4);
            return new ImageIcon(newimg);
        }

        private JPanel getShowPanel() {
            this.showClient.setActionCommand("client");
            this.showClientContract.setActionCommand("contract");
            this.showWebAssistant.setActionCommand("web");
            this.showMobileAssistant.setActionCommand("mobile");
            this.showWebLKAssistant.setActionCommand("webLK");
            this.showBotAssistant.setActionCommand("bot");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c"));
            panel.add((Component)this.showClient, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.showClientContract, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.showWebAssistant, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.showMobileAssistant, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.showWebLKAssistant, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.showBotAssistant, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private void setActionData() {
            ArrayList<AssistantActionDTO> s = new ArrayList<AssistantActionDTO>();
            ArrayList a = new ArrayList();
            for (AssistantActionDTO assistantActionDTO : this.libraryActionItems) {
                (((AssistantMaster)this.data).getActionIds().contains(assistantActionDTO.getId()) ? s : a).add(assistantActionDTO);
            }
            this.actionSelected.setData(s);
            this.actionAvailable.setData(a);
            AssistantActionDTO assistantActionDTO = new AssistantActionDTO();
            assistantActionDTO.setId(0);
            assistantActionDTO.setActionId("");
            assistantActionDTO.setTitle("=== \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e ===");
            ArrayList<AssistantActionDTO> st = new ArrayList<AssistantActionDTO>();
            st.add(assistantActionDTO);
            st.addAll(this.masterActionItems);
            st.addAll(s);
            this.actions.setData(st);
            this.actions.setSelectedItem((Object)st.stream().filter(i -> i.getActionId().equals(((AssistantMaster)this.data).getStartActionId())).findFirst().orElse((AssistantActionDTO)st.get(0)));
        }

        public boolean doApply() throws Exception {
            ((AssistantMaster)this.data).setTitle(this.title.getText());
            ((AssistantMaster)this.data).setStatus(((IdTitle)this.status.getSelectedItem()).getId());
            ((AssistantMaster)this.data).setComment(this.comment.getText());
            ((AssistantMaster)this.data).setRoleIds(this.roleTreeTablePanel.getCheckedRoleIds());
            ((AssistantMaster)this.data).setShowClient(this.showClient.isSelected());
            ((AssistantMaster)this.data).setShowClientContract(this.showClientContract.isSelected());
            ((AssistantMaster)this.data).setShowWebAssistant(this.showWebAssistant.isSelected());
            ((AssistantMaster)this.data).setShowMobileAssistant(this.showMobileAssistant.isSelected());
            ((AssistantMaster)this.data).setShowWebLKAssistant(this.showWebLKAssistant.isSelected());
            ((AssistantMaster)this.data).setShowBotAssistant(this.showBotAssistant.isSelected());
            try {
                AssistantMastersTab.this.getAssistantService().assistantMasterUpdate((AssistantMaster)this.data);
                AssistantMastersTab.this.performAction("refresh");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }
}

