/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import bitel.billing.module.admin.TransferManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGSelectedDevicePanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.common.service.ConfigService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.modules.sorm.client.SormSettingsPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.ConditionPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.SormBunchesPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.SormServicePanel;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.ListItem;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public abstract class DirectoryConfigurePanel
extends BGUPanel {
    private final Font labelsFont = new Font("TimesRoman", 0, 12);
    protected ConditionPanel payType;
    private BGControlPanelListSelect listPaymentTypeUpload;
    private ConditionPanel services;
    private SormServicePanel sormServicePanel;
    protected ConditionPanel documentType;
    protected BGUComboBox<IdTitle> selectedDocumentType;
    protected ConditionPanel regions;
    private JTextField regionCode;
    private JTextField regionTitle;
    protected JPanel inetPanel;
    private ConditionPanel gateways;
    private ConditionPanel switches;
    private ConditionPanel ipNumbering;
    private final JCheckBox ipNumberingInversion = new JCheckBox("\u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435, \u0447\u0442\u043e \u0431\u044b\u043b\u0438 \u0432\u044b\u0431\u0440\u0430\u043d\u044b");
    private final JCheckBox phoneNumberingInversion = new JCheckBox("\u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435, \u0447\u0442\u043e \u0431\u044b\u043b\u0438 \u0432\u044b\u0431\u0440\u0430\u043d\u044b");
    private ConditionPanel phoneNumbering;
    private ConditionPanel commutatorDirectory;
    private ConditionPanel codes;
    private ConditionPanel bunchesPanel;
    protected SormBunchesPanel sormBunchesPanel;
    private final JTextField numberPrefix = new JTextField(5);
    private final JTextField lengthCodeOfPrefix = new JTextField(5);
    private List<ContractParameterGroupAttr> contractParameters;
    private static final String INFO_LABEL_TEXT = "\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0435\u0442 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043c\u043e\u0434\u0443\u043b\u0435\u0439";
    private final GridBagConstraints infoLabelConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0);
    protected GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0);
    private final SormSettingsPanel parent;
    protected SormProject sormProject;
    private final List<InstalledInstanceModule> ethernetInstanceModules;
    private final List<InstalledInstanceModule> phoneInstanceModules;
    private static final int TYPE_LIST = 4;
    protected Preferences config = new Preferences();

    public DirectoryConfigurePanel(SormSettingsPanel parent, SormProject sormProject) {
        this.parent = parent;
        this.sormProject = sormProject;
        this.ethernetInstanceModules = this.getSormService().getInstalledEthernetModules();
        this.phoneInstanceModules = this.getSormService().getInstalledPhoneModules();
        try {
            this.contractParameters = ((ContractParameterService)this.getClientContext().getPort(ContractParameterService.class, 0)).contractParameterGroupAttrList();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.payType = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        this.services = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0443\u0441\u043b\u0443\u0433(\u0442\u0430\u0440\u0438\u0444\u043e\u0432)");
        this.documentType = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        this.regions = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u0432");
        this.ipNumbering = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 IP-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        this.gateways = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0448\u043b\u044e\u0437\u0430\u0445 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        this.switches = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u0430\u0445 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        this.commutatorDirectory = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u0430\u0445 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438");
        this.phoneNumbering = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u043d\u043e\u043c\u0435\u0440\u043d\u043e\u0439 \u0451\u043c\u043a\u043e\u0441\u0442\u0438");
        this.codes = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u043a\u043e\u0434\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0432\u044b\u0437\u043e\u0432\u043e\u0432");
        this.bunchesPanel = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        int x = 0;
        int y = 0;
        this.add(this.getDirectoryItemsPanel(), new GridBagConstraints(x, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add(this.getInetPanel(), new GridBagConstraints(x, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add(this.getPhonePanel(), new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(x, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.initPayType();
        this.initServices();
        this.initDocumentType();
        this.initRegions();
        this.initBunches();
        this.config = this.sormProject.getLoadedConfig();
        this.performAction("reset");
    }

    private JPanel getDirectoryItemsPanel() {
        JPanel directoryItems = new JPanel(new GridBagLayout());
        directoryItems.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 2, true), "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438"));
        directoryItems.add((Component)this.payType, this.constraints);
        directoryItems.add((Component)this.services, this.constraints);
        directoryItems.add((Component)this.documentType, this.constraints);
        directoryItems.add((Component)this.regions, this.constraints);
        return directoryItems;
    }

    private JPanel getInetPanel() {
        this.inetPanel = new JPanel(new GridBagLayout());
        this.inetPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 2, true), "\u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442"));
        this.inetPanel.add((Component)this.ipNumbering, this.constraints);
        this.inetPanel.add((Component)this.gateways, this.constraints);
        this.inetPanel.add((Component)this.switches, this.constraints);
        return this.inetPanel;
    }

    private JPanel getPhonePanel() {
        JPanel phonePanel = new JPanel(new GridBagLayout());
        phonePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 2, true), "\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u044f"));
        phonePanel.add((Component)this.commutatorDirectory, this.constraints);
        phonePanel.add((Component)this.phoneNumbering, this.constraints);
        phonePanel.add((Component)this.bunchesPanel, this.constraints);
        JPanel operatorNumberPrefixPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        operatorNumberPrefixPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440\u043d\u043e\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u044b\u0439 \u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0441\u0432\u044f\u0437\u0438, \u0432\u043a\u043b\u044e\u0447\u0430\u044f \u043a\u043e\u0434 \u0437\u043e\u043d\u044b"), c);
        operatorNumberPrefixPanel.add((Component)this.numberPrefix, c);
        operatorNumberPrefixPanel.add((Component)new JLabel("\u0414\u043b\u0438\u043d\u0430 \u043a\u043e\u0434\u0430 \u0437\u043e\u043d\u044b \u0432 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u043c \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u0435 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0441\u0432\u044f\u0437\u0438"), c);
        operatorNumberPrefixPanel.add((Component)this.lengthCodeOfPrefix, c);
        phonePanel.add((Component)operatorNumberPrefixPanel, this.constraints);
        return phonePanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.sormProject == null || Utils.isBlankString((String)this.sormProject.getConfig())) {
                return;
            }
            this.config = this.sormProject.getLoadedConfig();
            if (this.config == null || this.config.getMap().size() == 0) {
                return;
            }
            SormManufacturer manufacturer = SormManufacturer.getType((int)this.config.getInt("sorm.manufacturer", -1));
            if (manufacturer == null || manufacturer.equals((Object)SormManufacturer.ELKOM) || this.payType == null || this.config.get("sorm.upload.paytype.enable") == null) {
                return;
            }
            if ("1".equals(this.config.get("sorm.upload.paytype.enable"))) {
                this.payType.setEnabled(true);
                this.setPaymentTypeUpload(this.config);
            }
            if ("1".equals(this.config.get("sorm.upload.services.enable"))) {
                this.services.setEnabled(true);
                this.sormServicePanel.setSelectedModuleServices(this.config);
            }
            if ("1".equals(this.config.get("sorm.upload.documenttype.enable"))) {
                this.documentType.setEnabled(true);
                this.setSelectedDocumentType(this.config.getInt("sorm.upload.documenttype", -1));
            }
            if ("1".equals(this.config.get("sorm.upload.regions.enable"))) {
                this.regions.setEnabled(true);
                this.setRegionTitle(this.config.get("sorm.upload.regiontitle"));
                this.setRegionCode(this.config.get("sorm.upload.regioncode"));
            }
            if ("1".equals(this.config.get("sorm.upload.ipnumbering.enable"))) {
                this.ipNumbering.setEnabled(true);
                this.setCategoryIpResourceNonUpload(this.config);
                this.ipNumberingInversion.setSelected(this.config.get("sorm.upload.ipnumbering.inversion", "0").equals("1"));
            }
            if ("1".equals(this.config.get("sorm.upload.gateways.enable"))) {
                this.gateways.setEnabled(true);
                this.setSelectedGateways(this.config);
            }
            if ("1".equals(this.config.get("sorm.upload.switches.enable"))) {
                this.switches.setEnabled(true);
                this.setSelectedSwitchesNonUpload(this.config);
            }
            if ("1".equals(this.config.get("sorm.upload.commutators.enable"))) {
                this.commutatorDirectory.setEnabled(true);
                this.setCommutatorsDirectoryNonUpload(this.config);
            }
            if ("1".equals(this.config.get("sorm.upload.phonenumbering.enable"))) {
                this.phoneNumbering.setEnabled(true);
                this.setCategoryPhoneNumberingNonUpload(this.config);
                this.phoneNumberingInversion.setSelected(this.config.get("sorm.upload.phonenumbering.inversion", "0").equals("1"));
            }
            if ("1".equals(this.config.get("sorm.upload.codescallingend.enable"))) {
                this.codes.setEnabled(true);
            }
            if ("1".equals(this.config.get("sorm.upload.bunches.enable"))) {
                this.bunchesPanel.setEnabled(true);
                this.sormBunchesPanel.loadBunches(this.config);
            }
            this.numberPrefix.setText(this.config.get("sorm.upload.operatornumberprefix", ""));
            this.lengthCodeOfPrefix.setText(this.config.get("sorm.upload.lengthcodeofphone", ""));
        });
        new AbstractBGUPanel.DefaultAction("reset", "reset"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DirectoryConfigurePanel.this.initIpResource();
                DirectoryConfigurePanel.this.initGateways();
                DirectoryConfigurePanel.this.initSwitches();
                DirectoryConfigurePanel.this.initPhoneCommutatorsDirectory();
                DirectoryConfigurePanel.this.initPhoneNumbering();
            }
        };
    }

    protected void initPayType() throws Exception {
        this.listPaymentTypeUpload = new BGControlPanelListSelect();
        ClientUtils.buildList((JList)this.listPaymentTypeUpload.getList(), (List)((PaymentService)this.getClientContext().getPort(PaymentService.class, 0)).paymentTypeList(null, null));
        this.listPaymentTypeUpload.getList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DirectoryConfigurePanel.this.reloadRatioPaymentsPanel(DirectoryConfigurePanel.this.config);
            }
        });
        this.payType.getDetailPanel().add((Component)new BGLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.payType.getDetailPanel().add((Component)this.listPaymentTypeUpload, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
    }

    public abstract void reloadRatioPaymentsPanel(Preferences var1);

    protected List<BGUListItem> getSelectedPayTypes() {
        return Collections.list(this.listPaymentTypeUpload.getListModel().elements()).stream().filter(selectedType -> selectedType.isSelected()).collect(Collectors.toList());
    }

    private void initServices() {
        this.sormServicePanel = new SormServicePanel(this.getClientContext());
        this.services.getDetailPanel().add((Component)new BGLabel("<html>\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b<br>(\u043f\u043e \u0434\u0432\u043e\u0439\u043d\u043e\u043c\u0443 \u043a\u043b\u0438\u043a\u0443 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u0432\u0441\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435)</html>", this.labelsFont), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.services.getDetailPanel().add((Component)((Object)this.sormServicePanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
    }

    protected void initDocumentType() {
        this.selectedDocumentType = new BGUComboBox();
        ArrayList<Object> idTitleList = new ArrayList<Object>();
        idTitleList.add(new IdTitle(-1, "------------"));
        idTitleList.addAll(this.contractParameters.stream().filter(i -> i.getType() == 4).toList());
        this.selectedDocumentType.setData(idTitleList);
        this.selectedDocumentType.setFont(new Font("Arial", 0, 11));
        this.documentType.getDetailPanel().add((Component)new BGLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435\u043c \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0431\u0443\u0434\u0435\u0442 \u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435", this.labelsFont), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.documentType.getDetailPanel().add((Component)this.selectedDocumentType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
    }

    private void initRegions() {
        JLabel help = BGSwingUtilites.createHelpLabel((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0440\u0435\u0433\u0438\u043e\u043d \u0440\u0430\u0431\u043e\u0442\u044b \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c.\n\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438 \u043a\u043e\u0434 \u0440\u0435\u0433\u0438\u043e\u043d\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u043c \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \"\u0424\u0418\u0410\u0421\"", (int)-1);
        this.regions.getDetailPanel().add((Component)help, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.regions.getDetailPanel().add((Component)new BGLabel("\u041a\u043e\u0434 \u0440\u0435\u0433\u0438\u043e\u043d\u0430:", this.labelsFont), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.regionCode = new JTextField(3);
        this.regions.getDetailPanel().add((Component)this.regionCode, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.regions.getDetailPanel().add((Component)new BGLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0433\u0438\u043e\u043d\u0430:", this.labelsFont), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.regionTitle = new JTextField(25);
        this.regions.getDetailPanel().add((Component)this.regionTitle, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initIpResource() throws Exception {
        List<InstalledInstanceModule> modules = this.getSelectedInstalledEthernetModules();
        this.ipNumbering.getDetailPanel().removeAll();
        if (Utils.notEmptyCollection(modules)) {
            this.ipNumbering.getDetailPanel().add((Component)new BGLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 ip-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b", this.labelsFont), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 0), 0, 0));
            for (InstalledInstanceModule module : modules) {
                ConditionPanel conditionPanel = new ConditionPanel("\u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " , id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                conditionPanel.getDetailPanel().add((Component)this.getResourceDetailPanel(module), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
                this.ipNumbering.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.ipNumbering.getDetailPanel().add((Component)this.ipNumberingInversion, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.ipNumbering.getDetailPanel().add((Component)new JLabel(INFO_LABEL_TEXT), this.infoLabelConstraints);
        }
        this.ipNumbering.revalidate();
        this.ipNumbering.repaint();
    }

    private void initGateways() throws BGException {
        List<InstalledInstanceModule> ethernetModules = this.getSelectedInstalledEthernetModules();
        this.gateways.getDetailPanel().removeAll();
        if (Utils.notEmptyCollection(ethernetModules)) {
            this.gateways.getDetailPanel().add((Component)BGSwingUtilites.createHelpLabel((String)"\u0412 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u0431\u044b\u0447\u043d\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0430\u044e\u0442\u0441\u044f \u043f\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u043d\u044b\u0435 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u044b", (int)-1), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
            this.gateways.getDetailPanel().add((Component)new BGLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0448\u043b\u044e\u0437\u043e\u0432", this.labelsFont), new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
            for (InstalledInstanceModule module : ethernetModules) {
                BGSelectedDevicePanel selectedDevicePanel;
                ConditionPanel conditionPanel = new ConditionPanel("\u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " , id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                if (module.getTitleModule().equals(UploadModulesTitle.INET.getTitleModule())) {
                    selectedDevicePanel = new BGSelectedDevicePanel(module.getModuleId());
                    conditionPanel.getDetailPanel().add((Component)selectedDevicePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                }
                if (module.getTitleModule().equals(UploadModulesTitle.DIAL_UP.getTitleModule())) {
                    selectedDevicePanel = new BGControlPanelListSelect();
                    conditionPanel.getDetailPanel().add((Component)selectedDevicePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                    this.buildControlPanelListSelect((BGControlPanelListSelect)selectedDevicePanel, module.getModuleId());
                }
                this.gateways.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        } else {
            this.gateways.getDetailPanel().add((Component)new JLabel(INFO_LABEL_TEXT), this.infoLabelConstraints);
        }
        this.gateways.revalidate();
        this.gateways.repaint();
    }

    private void initSwitches() {
        List<InstalledInstanceModule> ethernetModules = this.getSelectedInstalledEthernetModules();
        this.switches.getDetailPanel().removeAll();
        if (Utils.notEmptyCollection(ethernetModules)) {
            this.switches.getDetailPanel().add((Component)new BGLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432", this.labelsFont), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            for (InstalledInstanceModule module : ethernetModules) {
                if (module.getTitleModule().equals(UploadModulesTitle.DIAL_UP.getTitleModule())) {
                    BGControlPanelListSelect listSelect = new BGControlPanelListSelect();
                    ConditionPanel conditionPanel = new ConditionPanel("\u0421\u043f\u0438\u0441\u043e\u043a NAS. \u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " , id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                    this.buildControlPanelListSelect(listSelect, module.getModuleId());
                    conditionPanel.getDetailPanel().add((Component)listSelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    this.switches.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                    continue;
                }
                ConditionPanel conditionPanel = new ConditionPanel("\u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " , id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                BGSelectedDevicePanel selectedDevicePanel = new BGSelectedDevicePanel(module.getModuleId());
                conditionPanel.getDetailPanel().add((Component)selectedDevicePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.switches.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        } else {
            this.switches.getDetailPanel().add((Component)new JLabel(INFO_LABEL_TEXT), this.infoLabelConstraints);
        }
        this.switches.revalidate();
        this.switches.repaint();
    }

    private void initPhoneCommutatorsDirectory() {
        List<InstalledInstanceModule> modules = this.getSelectedInstalledPhoneModules();
        this.commutatorDirectory.getDetailPanel().removeAll();
        if (Utils.notEmptyCollection(modules)) {
            this.commutatorDirectory.getDetailPanel().add((Component)new BGLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432", this.labelsFont), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            for (InstalledInstanceModule module : modules) {
                ConditionPanel conditionPanel;
                if (module.getTitleModule().equals(UploadModulesTitle.VOICE.getTitleModule())) {
                    BGSelectedDevicePanel selectedDevicePanel = new BGSelectedDevicePanel(module.getModuleId(), true);
                    conditionPanel = new ConditionPanel("\u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " , id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                    conditionPanel.getDetailPanel().add((Component)selectedDevicePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    this.commutatorDirectory.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                    continue;
                }
                if (!module.getTitleModule().equals(UploadModulesTitle.VOICE_IP.getTitleModule())) continue;
                BGControlPanelListSelect listSelect = new BGControlPanelListSelect();
                conditionPanel = new ConditionPanel("\u0421\u043f\u0438\u0441\u043e\u043a NAS. \u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " , id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                this.buildControlPanelListSelect(listSelect, module.getModuleId());
                conditionPanel.getDetailPanel().add((Component)listSelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.commutatorDirectory.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        } else {
            this.commutatorDirectory.getDetailPanel().add((Component)new JLabel(INFO_LABEL_TEXT), this.infoLabelConstraints);
        }
        this.commutatorDirectory.revalidate();
        this.commutatorDirectory.repaint();
    }

    private void initPhoneNumbering() throws Exception {
        List<InstalledInstanceModule> phoneModules = this.getSelectedInstalledPhoneModules();
        this.phoneNumbering.getDetailPanel().removeAll();
        if (Utils.notEmptyCollection(phoneModules)) {
            this.phoneNumbering.getDetailPanel().add((Component)new BGLabel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u043d\u0443\u0436\u043d\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0430\u0442\u044c", this.labelsFont), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            for (InstalledInstanceModule module : phoneModules) {
                if (module.getTitleModule().equals(UploadModulesTitle.VOICE.getTitleModule())) {
                    PhoneResourceService resourceService = (PhoneResourceService)this.getClientContext().getPort(PhoneResourceService.class, module.getModuleId());
                    List phoneCategory = resourceService.phoneCategoryList();
                    ArrayList listItems = new ArrayList();
                    phoneCategory.forEach(category -> listItems.add(new ListItem(){
                        final /* synthetic */ PhoneCategory val$category;
                        {
                            this.val$category = phoneCategory;
                        }

                        public int getId() {
                            return this.val$category.getId();
                        }

                        public String getTitle() {
                            return this.val$category.getTitle();
                        }
                    }));
                    BGControlPanelListSelect panelListSelect = new BGControlPanelListSelect();
                    ClientUtils.buildList((JList)panelListSelect.getList(), listItems);
                    ConditionPanel conditionPanel = new ConditionPanel("\u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                    conditionPanel.getDetailPanel().add((Component)panelListSelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    this.phoneNumbering.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                    continue;
                }
                if (!module.getTitleModule().equals(UploadModulesTitle.VOICE_IP.getTitleModule())) continue;
                BGControlPanelListSelect panelListSelect = new BGControlPanelListSelect();
                ConditionPanel conditionPanel = new ConditionPanel("\u041c\u043e\u0434\u0443\u043b\u044c: " + module.getTitle() + " id=" + module.getModuleId(), module.getModuleId(), this.getClientContext().getModuleId());
                this.buildControlPanelListSelect(panelListSelect, module.getModuleId());
                conditionPanel.getDetailPanel().add((Component)panelListSelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.phoneNumbering.getDetailPanel().add((Component)conditionPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.phoneNumbering.getDetailPanel().add((Component)this.phoneNumberingInversion, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.phoneNumbering.getDetailPanel().add((Component)new JLabel(INFO_LABEL_TEXT), this.infoLabelConstraints);
        }
        this.phoneNumbering.revalidate();
        this.phoneNumbering.repaint();
    }

    private void buildPhoneSourcesPanel(BGControlPanelListSelect listSelect, int mid) {
        Request request = new Request();
        request.setModule("load");
        request.setModuleId(mid);
        request.setAction("SourceList");
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.tryCall(() -> {
                List test = ClientUtils.getList((Node)XMLUtils.selectElement((Node)doc, (String)"/data/list"));
                ClientUtils.buildList((JList)listSelect.getList(), (List)test);
            });
        }
    }

    private void buildControlPanelListSelect(BGControlPanelListSelect listSelect, int mid) {
        Request request = new Request().setModule("call").setAction("NASList").setAttribute("mid", mid);
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList((JList)listSelect.getList(), (Node)XMLUtils.getNode((Document)doc, (String)"nas_list"));
        }
    }

    private void initCodes() {
        String text = "\u041f\u0440\u0438 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438, \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a Q850. \u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u0443\u044e \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0432 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u043a\u043e\u0434\u0435.";
        this.codes.getDetailPanel().add((Component)new BGLabel(text, this.labelsFont), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initBunches() {
        this.sormBunchesPanel = new SormBunchesPanel();
        this.bunchesPanel.getDetailPanel().add((Component)((Object)this.sormBunchesPanel), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private BGControlPanelListSelect getResourceDetailPanel(InstalledInstanceModule module) throws Exception {
        BGControlPanelListSelect listIpNumberingNotUpload = new BGControlPanelListSelect();
        if (module.getTitleModule().equals(UploadModulesTitle.INET.getTitleModule())) {
            ResourceService resourceService = (ResourceService)this.getClientContext().getPort(ResourceService.class, module.getModuleId());
            List categories = resourceService.ipCategoryList();
            ClientUtils.buildList((JList)listIpNumberingNotUpload.getList(), (List)categories);
        } else if (module.getTitleModule().equals(UploadModulesTitle.DIAL_UP.getTitleModule())) {
            ConfigData config = ((ConfigService)this.getClientContext().getPort(ConfigService.class, module.getModuleId())).moduleConfigActiveGet(module.getModuleId());
            Preferences preferences = new Preferences();
            preferences.loadData(config.getConfig(), "\n");
            ParameterMap sub = preferences.sub("pools");
            ArrayList<4> items = new ArrayList<4>();
            for (final Map.Entry entry : sub.entrySet()) {
                ListItem item = new ListItem(){

                    public int getId() {
                        return 0;
                    }

                    public String getTitle() {
                        String key = (String)entry.getKey();
                        if (key.startsWith(".")) {
                            return key.replaceFirst(".", "");
                        }
                        return key;
                    }
                };
                items.add(item);
            }
            ClientUtils.buildList((JList)listIpNumberingNotUpload.getList(), items);
        }
        return listIpNumberingNotUpload;
    }

    private List<InstalledInstanceModule> getSelectedInstalledEthernetModules() {
        ArrayList<InstalledInstanceModule> modules = new ArrayList<InstalledInstanceModule>(this.ethernetInstanceModules);
        if (this.sormProject != null) {
            String selected = this.sormProject.getLoadedConfig().get("sorm.upload.modules", "");
            if (Utils.isBlankString((String)selected)) {
                return null;
            }
            List selectedIds = Utils.toIntegerList((String)selected);
            modules.removeIf(i -> !selectedIds.contains(i.getModuleId()));
        }
        return modules;
    }

    private List<InstalledInstanceModule> getSelectedInstalledPhoneModules() {
        ArrayList<InstalledInstanceModule> modules = new ArrayList<InstalledInstanceModule>(this.phoneInstanceModules);
        if (this.sormProject != null) {
            String selected = this.sormProject.getLoadedConfig().get("sorm.upload.modules", "");
            if (Utils.isBlankString((String)selected)) {
                return modules;
            }
            List selectedIds = Utils.toIntegerList((String)selected);
            modules.removeIf(i -> !selectedIds.contains(i.getModuleId()));
        }
        return modules;
    }

    protected ClientContext getClientContext() {
        return (ClientContext)this.parent.getContext();
    }

    private SormService getSormService() {
        return (SormService)this.getClientContext().getPort(SormService.class);
    }

    protected List<Integer> getPaymentTypeUpload() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Arrays.stream(this.listPaymentTypeUpload.getSelectedIds()).forEach(result::add);
        return result;
    }

    protected void setPaymentTypeUpload(Preferences config) {
        String ids = config.get("sorm.upload.paytype");
        if (Utils.notBlankString((String)ids)) {
            this.listPaymentTypeUpload.setListValues(ids);
            this.reloadRatioPaymentsPanel(config);
        }
    }

    protected int getSelectedDocumentType() {
        return this.selectedDocumentType.getSelectedItem() != null ? ((IdTitle)this.selectedDocumentType.getSelectedItem()).getId() : -1;
    }

    protected void setSelectedDocumentType(int id) {
        if (id > 0) {
            this.selectedDocumentType.setSelectedItem((Object)this.contractParameters.stream().filter(p -> p.getId() == id).findFirst().get());
        }
    }

    private String getRegionTitle() {
        return this.regionTitle.getText() == null ? "" : this.regionTitle.getText();
    }

    private void setRegionTitle(String region) {
        if (Utils.notBlankString((String)region)) {
            this.regionTitle.setText(region);
        }
    }

    private String getRegionCode() {
        return this.regionCode.getText();
    }

    private void setRegionCode(String regionCode) {
        if (Utils.notBlankString((String)regionCode)) {
            this.regionCode.setText(regionCode);
        }
    }

    private Map<String, String> getCategoryIpResourceNonUpload() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.convertSelectedValuesToMap(this.getSelectedValuesInnerPanel(this.ipNumbering)).forEach((key, value) -> result.put("sorm.upload.ipnumbering." + key, (String)value));
        return result;
    }

    private void setCategoryIpResourceNonUpload(Preferences preferences) {
        this.setSelectedValuesFromPreferences(preferences, "sorm.upload.ipnumbering", this.ipNumbering);
    }

    private void setSelectedGateways(Preferences preferences) {
        this.setSelectedValuesFromPreferences(preferences, "sorm.upload.gateways", this.gateways);
    }

    private Map<String, String> getSelectedGateways() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.convertSelectedValuesToMap(this.getSelectedValuesInnerPanel(this.gateways)).forEach((key, value) -> result.put("sorm.upload.gateways." + key, (String)value));
        return result;
    }

    private void setSelectedSwitchesNonUpload(Preferences preferences) {
        this.setSelectedValuesFromPreferences(preferences, "sorm.upload.switches", this.switches);
    }

    private Map<String, String> getSelectedSwitchesNonUpload() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.convertSelectedValuesToMap(this.getSelectedValuesInnerPanel(this.switches)).forEach((key, value) -> result.put("sorm.upload.switches." + key, (String)value));
        return result;
    }

    private void setCommutatorsDirectoryNonUpload(Preferences preferences) {
        this.setSelectedValuesFromPreferences(preferences, "sorm.upload.commutators", this.commutatorDirectory);
    }

    private Map<String, String> getCommutatorDirectoryNonUpload() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.convertSelectedValuesToMap(this.getSelectedValuesInnerPanel(this.commutatorDirectory)).forEach((key, value) -> result.put("sorm.upload.commutators." + key, (String)value));
        return result;
    }

    private void setCategoryPhoneNumberingNonUpload(Preferences preferences) {
        this.setSelectedValuesFromPreferences(preferences, "sorm.upload.phonenumbering", this.phoneNumbering);
    }

    private Map<String, String> getCategoryPhoneNumberingNonUpload() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.convertSelectedValuesToMap(this.getSelectedValuesInnerPanel(this.phoneNumbering)).forEach((key, value) -> result.put("sorm.upload.phonenumbering." + key, (String)value));
        return result;
    }

    private void setSelectedValuesFromPreferences(Preferences preferences, String subKey, ConditionPanel conditionPanel) {
        this.setValuesOnConditionalPanel(this.getPairsMidsListIds(preferences, subKey), conditionPanel);
    }

    private Map<Integer, List<Integer>> getPairsMidsListIds(Preferences preferences, String subKey) {
        Map map = preferences.subKeyed(subKey);
        HashMap<Integer, List<Integer>> values = new HashMap<Integer, List<Integer>>();
        if (map != null && map.size() > 0) {
            map.entrySet().stream().findFirst().ifPresent(parameterMap -> {
                for (Map.Entry parameter : ((ParameterMap)parameterMap.getValue()).entrySet()) {
                    int mid = Utils.parseInt((String)((String)parameter.getKey()));
                    if (mid <= 0) continue;
                    values.put(mid, Utils.toList((String)((String)parameter.getValue())).stream().mapToInt(Integer::parseInt).boxed().collect(Collectors.toList()));
                }
            });
        }
        return values;
    }

    private void setValuesOnConditionalPanel(Map<Integer, List<Integer>> values, ConditionPanel conditionPanel) {
        values.forEach((key, value) -> conditionPanel.getInnerPanels().stream().filter(innerPanel -> innerPanel.getMid() == key.intValue()).forEach(innerPanel -> {
            try {
                innerPanel.setEnabled(true);
                innerPanel.setSelectedIds((List<Integer>)value);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }));
    }

    private List<Map<Integer, List<Integer>>> getSelectedValuesInnerPanel(ConditionPanel conditionPanel) {
        ArrayList<Map<Integer, List<Integer>>> selected = new ArrayList<Map<Integer, List<Integer>>>();
        conditionPanel.getInnerPanels().stream().filter(ConditionPanel::isEnable).forEach(innerPanel -> {
            HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>();
            map.put(innerPanel.getMid(), innerPanel.getSelectedIds());
            selected.add(map);
        });
        return selected;
    }

    private Map<Integer, String> convertSelectedValuesToMap(List<Map<Integer, List<Integer>>> selected) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        selected.forEach(m -> m.forEach((moduleId, values) -> result.put((Integer)moduleId, Utils.toString((Iterable)values, (String)","))));
        return result;
    }

    public abstract void setPaymentRatio(Preferences var1);

    public void buildConfig(Preferences config) {
        SormManufacturer manufacturer = SormManufacturer.getType((int)config.getInt("sorm.manufacturer", -1));
        if (manufacturer == null || manufacturer.equals((Object)SormManufacturer.ELKOM) || this.payType == null) {
            return;
        }
        config.set("sorm.upload.paytype.enable", this.payType.isEnable() ? "1" : "0");
        config.set("sorm.upload.services.enable", this.services.isEnable() ? "1" : "0");
        config.set("sorm.upload.documenttype.enable", this.documentType.isEnable() ? "1" : "0");
        config.set("sorm.upload.regions.enable", this.regions.isEnable() ? "1" : "0");
        config.set("sorm.upload.ipnumbering.enable", this.ipNumbering.isEnable() ? "1" : "0");
        config.set("sorm.upload.gateways.enable", this.gateways.isEnable() ? "1" : "0");
        config.set("sorm.upload.switches.enable", this.switches.isEnable() ? "1" : "0");
        config.set("sorm.upload.commutators.enable", this.commutatorDirectory.isEnable() ? "1" : "0");
        config.set("sorm.upload.phonenumbering.enable", this.phoneNumbering.isEnable() ? "1" : "0");
        config.set("sorm.upload.codescallingend.enable", this.codes.isEnable() ? "1" : "0");
        config.set("sorm.upload.bunches.enable", this.bunchesPanel.isEnable() ? "1" : "0");
        if (this.payType.isEnable()) {
            String selectedIds = Utils.toString(this.getPaymentTypeUpload(), (String)",");
            config.set("sorm.upload.paytype", selectedIds);
            this.setPaymentRatio(config);
        }
        if (this.services.isEnable()) {
            this.sormServicePanel.buildConfig(config);
        }
        if (this.documentType.isEnable()) {
            config.set("sorm.upload.documenttype", String.valueOf(this.getSelectedDocumentType()));
        }
        if (this.regions.isEnable()) {
            String code = this.getRegionCode();
            String regionTitle = this.getRegionTitle();
            if (Utils.notBlankString((String)code)) {
                config.set("sorm.upload.regioncode", code);
            }
            if (Utils.notBlankString((String)regionTitle)) {
                config.set("sorm.upload.regiontitle", regionTitle);
            }
        }
        if (this.ipNumbering.isEnable()) {
            this.getCategoryIpResourceNonUpload().forEach((arg_0, arg_1) -> ((Preferences)config).set(arg_0, arg_1));
            config.set("sorm.upload.ipnumbering.inversion", this.ipNumberingInversion.isSelected() ? "1" : "0");
        }
        if (this.gateways.isEnable()) {
            this.getSelectedGateways().forEach((arg_0, arg_1) -> ((Preferences)config).set(arg_0, arg_1));
        }
        if (this.switches.isEnable()) {
            this.getSelectedSwitchesNonUpload().forEach((arg_0, arg_1) -> ((Preferences)config).set(arg_0, arg_1));
        }
        if (this.commutatorDirectory.isEnable()) {
            this.getCommutatorDirectoryNonUpload().forEach((arg_0, arg_1) -> ((Preferences)config).set(arg_0, arg_1));
        }
        if (this.phoneNumbering.isEnable()) {
            this.getCategoryPhoneNumberingNonUpload().forEach((arg_0, arg_1) -> ((Preferences)config).set(arg_0, arg_1));
            config.set("sorm.upload.phonenumbering.inversion", this.phoneNumberingInversion.isSelected() ? "1" : "0");
        }
        if (this.codes.isEnable()) {
            config.set("sorm.upload.codescallingend", "1");
        }
        if (this.bunchesPanel.isEnable()) {
            config.set("sorm.upload.bunches.enable", "1");
            this.sormBunchesPanel.saveBunches(config);
        }
        config.set("sorm.upload.operatornumberprefix", this.numberPrefix.getText());
        config.set("sorm.upload.lengthcodeofphone", this.lengthCodeOfPrefix.getText());
    }

    public SormProject getSormProject() {
        return this.sormProject;
    }

    public void setSormProject(SormProject sormProject) {
        this.sormProject = sormProject;
    }

    static final class BGLabel
    extends JLabel {
        BGLabel(String text) {
            super(text);
        }

        BGLabel(String text, Font font) {
            super(text);
            if (font != null) {
                this.setFont(font);
            }
        }
    }
}

