/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.client;

import bitel.billing.module.common.BGTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelDateWithTime;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGControlPanelTextArea;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.PeriodWithTime;

public class SubscriptionPanel
extends BGUPanel {
    private BGEditor editor = null;
    private SubscriptionService subscriptionService;
    private SubscriptionTableModel model = new SubscriptionTableModel();

    public SubscriptionPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() throws Exception {
        final BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && table.getSelectedRow() == table.rowAtPoint(e.getPoint())) {
                    boolean isCanRegistration = true;
                    Subscription subscription = (Subscription)SubscriptionPanel.this.model.getSelectedRow();
                    List list = subscription.getRegistrationPeriodList();
                    if (list != null && list.size() > 0) {
                        RegistrationPeriod registrationPeriod = (RegistrationPeriod)list.get(list.size() - 1);
                        PeriodWithTime periodWithTime = registrationPeriod.getPeriod();
                        boolean bl = isCanRegistration = periodWithTime != null && !TimeUtils.dateInRangeWithTime((Date)new Date(), (Date)periodWithTime.getDateFrom(), (Date)periodWithTime.getDateTo());
                    }
                    if (isCanRegistration) {
                        SubscriptionPanel.this.getPopupMenu().show((Component)table, e.getX(), e.getY());
                    }
                }
                super.mousePressed(e);
            }
        });
        this.editor = new BGEditor();
        this.editor.setVisible(false);
        this.editor.addForm((JComponent)((Object)new SubscriptionForm()));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        this.add((Component)this.editor, "South");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this.editor);
    }

    private SubscriptionService getSubscriptionService() {
        if (this.subscriptionService == null) {
            this.subscriptionService = (SubscriptionService)((ClientContext)this.getContext()).getWebService(SubscriptionService.class);
        }
        return this.subscriptionService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List list = this.getSubscriptionService().subscriptionList(((ClientContext)this.getContext()).getContractId(), true);
            HashMap<Integer, SubscriptionType> maps = new HashMap<Integer, SubscriptionType>();
            for (Subscription subscription : list) {
                int subscriptionTypeId = subscription.getTypeId();
                SubscriptionType subscriptionType = (SubscriptionType)maps.get(subscriptionTypeId);
                if (subscriptionType == null) {
                    subscriptionType = this.getSubscriptionService().subscriptionTypeGet(subscriptionTypeId);
                    maps.put(subscriptionTypeId, subscriptionType);
                }
                subscription.setSubscriptionType(subscriptionType);
            }
            this.model.setData(list);
        });
    }

    class SubscriptionTableModel
    extends BGTableModel<Subscription> {
        public SubscriptionTableModel() {
            super(SubscriptionPanel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 300, 300, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", -1, 300, 300, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", -1, 100, 100, "active", true);
            this.addColumn("\u0410\u0432\u0442\u043e\u043f\u0440\u043e\u0434\u043b.", -1, 100, 100, "avtoCommit", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Subscription val, int column) throws Exception {
            switch (column) {
                case 1: {
                    String value = "???";
                    if (val != null && val.getSubscriptionType() != null) {
                        value = val.getSubscriptionType().getTitle();
                    }
                    return value;
                }
                case 3: {
                    PeriodWithTime period = null;
                    List list = val.getRegistrationPeriodList();
                    if (list != null && !list.isEmpty()) {
                        period = ((RegistrationPeriod)list.get(list.size() - 1)).getPeriod();
                    }
                    return period;
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class SubscriptionForm
    extends BGUPanel {
        private Subscription current;
        private BGTabbedPane tabbedPane;
        private BGControlPanelTextArea comment;
        private BGUComboBox<SubscriptionType> subscriptionTypeComboBox;
        private BGControlPanelDateWithTime controlPanelPeriodFrom;
        private BGControlPanelDateWithTime controlPanelPeriodTo;
        private JCheckBox avtoCommit;
        private RegistrationPeriodTableModel registrationPeriodModel;

        public SubscriptionForm() {
            super((LayoutManager)new GridBagLayout());
            this.tabbedPane = new BGTabbedPane();
            this.comment = new BGControlPanelTextArea();
            this.subscriptionTypeComboBox = new BGUComboBox();
            this.controlPanelPeriodFrom = new BGControlPanelDateWithTime();
            this.controlPanelPeriodTo = new BGControlPanelDateWithTime();
            this.avtoCommit = new JCheckBox("\u0410\u0432\u0442\u043e\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435");
            this.registrationPeriodModel = new RegistrationPeriodTableModel();
        }

        protected void jbInit() throws Exception {
            BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
            this.tabbedPane.add((Component)this.getSubscriptionPanel(), (Object)"\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430");
            this.tabbedPane.add((Component)this.getRegistrationPeriodPanel(), (Object)"\u0423\u0447\u0435\u0442\u043d\u044b\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u044b");
            this.add((Component)this.tabbedPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.subscriptionTypeComboBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    SubscriptionType subscriptionType = (SubscriptionType)this.subscriptionTypeComboBox.getSelectedItem();
                    this.avtoCommit.setEnabled(subscriptionType.isAvtoCommit());
                    this.getActionMap().get("ok").setEnabled(subscriptionType.getId() != -1);
                }
            });
        }

        private JPanel getSubscriptionPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 3, 5), 0, 0));
            panel.add((Component)this.subscriptionTypeComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 3, 5), 0, 0));
            panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.avtoCommit, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 3, 5), 0, 0));
            panel.add((Component)this.comment, new GridBagConstraints(1, 1, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getRegistrationPeriodPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setPreferredSize(new Dimension(200, 200));
            panel.add((Component)new JScrollPane((Component)new BGUTable((TableModel)((Object)this.registrationPeriodModel))), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getPeriodPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("c"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.controlPanelPeriodFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.controlPanelPeriodTo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        protected void getPopupMenuItems() {
            this.popupMenu.add("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434").addActionListener(event -> {
                this.tryCall(() -> SubscriptionPanel.this.getSubscriptionService().subscriptionActivate(((Subscription)SubscriptionPanel.this.model.getSelectedRow()).getId()));
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
                SubscriptionPanel.this.performAction("refresh");
            });
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.current = new Subscription();
                this.current.setContractId(((ClientContext)this.getContext()).getContractId());
                this.current.setPeriod(new PeriodWithTime(new Date(), null));
                this.subscriptionTypeComboBox.setEnabled(true);
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                this.current = (Subscription)SubscriptionPanel.this.model.getSelectedRow();
                if (this.current != null) {
                    this.subscriptionTypeComboBox.setEnabled(this.current.getTypeId() == -1);
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {});
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    SubscriptionForm.this.current.setSubscriptionType((SubscriptionType)SubscriptionForm.this.subscriptionTypeComboBox.getSelectedItem());
                    SubscriptionForm.this.current.setPeriod(new PeriodWithTime(SubscriptionForm.this.controlPanelPeriodFrom.getDate(), SubscriptionForm.this.controlPanelPeriodTo.getDate()));
                    SubscriptionForm.this.current.setAvtoCommit(SubscriptionForm.this.avtoCommit.isSelected());
                    SubscriptionForm.this.current.setComment(SubscriptionForm.this.comment.getText());
                    int id = SubscriptionPanel.this.getSubscriptionService().subscriptionUpdate(SubscriptionForm.this.current);
                    SubscriptionForm.this.performActionClose();
                    SubscriptionPanel.this.performAction("refresh");
                    SubscriptionPanel.this.model.setSelectedRow(id);
                }
            };
        }

        public void performActionOpen() {
            try {
                this.tabbedPane.setSelectedIndex(0);
                this.subscriptionTypeComboBox.setData(SubscriptionPanel.this.getSubscriptionService().subscriptionTypeList());
                SubscriptionType subscriptionType = this.current.getSubscriptionType();
                if (subscriptionType == null) {
                    subscriptionType = SubscriptionType.builder().setId(-1).setTitle("\u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435").build();
                    this.subscriptionTypeComboBox.insertItemAt((Object)subscriptionType, 0);
                }
                this.subscriptionTypeComboBox.setSelectedItem((Object)subscriptionType);
                this.controlPanelPeriodFrom.setDate(this.current.getPeriod().getDateFrom());
                this.controlPanelPeriodTo.setDate(this.current.getPeriod().getDateTo());
                this.avtoCommit.setSelected(this.current.isAvtoCommit());
                this.comment.setText(this.current.getComment());
                this.current.setRegistrationPeriodList(SubscriptionPanel.this.getSubscriptionService().subscriptionRegistrationPeriodList(this.current.getId()));
                this.registrationPeriodModel.setData(this.current.getRegistrationPeriodList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            super.performActionOpen();
        }
    }

    class RegistrationPeriodTableModel
    extends BGTableModel<RegistrationPeriod> {
        public RegistrationPeriodTableModel() {
            super(SubscriptionForm.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 300, 300, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Column.DateTime.class, -1, 180, 180, "dateCreate", true);
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", -1, -1, -1, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RegistrationPeriod val, int column) throws Exception {
            switch (column) {
                case 1: {
                    return val.getPeriod();
                }
                case 3: {
                    Object value = "\u0421\u0435\u0440\u0432\u0435\u0440";
                    int whoCreate = val.getWhoCreate();
                    if (whoCreate < 0) {
                        value = "\u041a\u043b\u0438\u0435\u043d\u0442";
                    } else if (whoCreate > 0) {
                        value = "\u0410\u0434\u043c\u0438\u043d [ID=" + whoCreate + "]";
                    }
                    return value;
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

