/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server;

import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.hd.server.AgentAction;
import ru.bitel.bgbilling.modules.hd.server.AgentDriver;
import ru.bitel.bgbilling.modules.hd.server.bean.CPNs;
import ru.bitel.bgbilling.modules.hd.server.bean.NsServer;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class NsAgentDriver
extends AgentDriver {
    private NsServer server;

    public NsAgentDriver(Preferences moduleSetup, NsServer server) throws Exception {
        super(moduleSetup);
        this.server = server;
    }

    @Override
    public void connect() throws Exception {
        this.connect(this.server.getAddr());
    }

    @Override
    public String getName() {
        return this.server.getAddr();
    }

    public List<String> getHostList(String domain) throws Exception {
        ArrayList<String> result = new ArrayList();
        StringBuilder req = this.getCommandTemplate("host_list");
        this.addRequestParam(req, "domain", domain);
        String prefix = "LIST:";
        String resp = this.sendCommand(req.toString());
        if (!resp.startsWith("LIST:")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0445\u043e\u0441\u0442\u043e\u0432: " + resp);
        }
        result = Utils.toList((String)resp.substring("LIST:".length()));
        return result;
    }

    public void addHost(AgentAction action) throws Exception {
        StringBuilder req = this.getCommandTemplate("add_host");
        this.addRequestParam(req, "domain", action.hostDomain);
        this.addRequestParam(req, "host", action.hostName);
        this.addRequestParam(req, "addr", action.hostAddr);
        String resp = this.sendCommand(req.toString());
        if (!resp.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0445\u043e\u0441\u0442\u0430: " + resp);
        }
    }

    public void deleteHost(AgentAction action) throws Exception {
        StringBuilder req = this.getCommandTemplate("delete_host");
        this.addRequestParam(req, "domain", action.hostDomain);
        this.addRequestParam(req, "host", action.hostName);
        String resp = this.sendCommand(req.toString());
        if (!resp.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0445\u043e\u0441\u0442\u0430: " + resp);
        }
    }

    public void addMasterSupport(AgentAction action) throws Exception {
        StringBuilder req = this.getCommandTemplate("add_domain_master");
        this.addRequestParam(req, "domain", action.nsDomain);
        int pos = 0;
        for (CPNs ns : action.nsList) {
            this.addRequestParam(req, "ns" + pos++, ns.getName());
        }
        for (String[] record : action.nsRecords) {
            this.addRequestParam(req, "record_" + record[0], record[1]);
        }
        this.addRequestParam(req, "admin_mail", action.nsAdminMail);
        String resp = this.sendCommand(req.toString());
        if (!resp.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438 \u0434\u043e\u043c\u0435\u043d\u0430 primary ns: " + resp);
        }
    }

    public void addSlaveSupport(AgentAction action) throws Exception {
        StringBuilder req = this.getCommandTemplate("add_domain_slave");
        this.addRequestParam(req, "domain", action.nsDomain);
        int pos = 0;
        for (CPNs ns : action.nsList) {
            this.addRequestParam(req, "ns" + pos++, ns.getName());
        }
        String resp = this.sendCommand(req.toString());
        if (!resp.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438 \u0434\u043e\u043c\u0435\u043d\u0430 secondary ns: " + resp);
        }
    }

    public void deleteDomainSupport(AgentAction action) throws Exception {
        StringBuilder req = this.getCommandTemplate("delete_domain");
        this.addRequestParam(req, "domain", action.nsDomain);
        String resp = this.sendCommand(req.toString());
        if (!resp.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438 \u0434\u043e\u043c\u0435\u043d\u0430: " + resp);
        }
    }
}

