/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGControlPanelMonth;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.log.client.LogManagerDayPanel;
import ru.bitel.bgbilling.modules.inet.client.InetDevicePanel;
import ru.bitel.bgbilling.modules.inet.client.InetSourceManagerPanel;
import ru.bitel.bgbilling.modules.inet.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.service.InetLogManagementService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Result;

public class InetLogManagerPanel
extends BGUPanel {
    private BGControlPanelMonth monthPanel = new BGControlPanelMonth();
    private InetDevicePanel devicePanel = new InetDevicePanel((ClientContext)this.getContext(), 4, e -> {
        if (e.getActionCommand().equals("device.selected")) {
            this.setData();
        }
    });
    private JCheckBox jcbLoad = new JCheckBox();
    private JCheckBox jcbInProcess = new JCheckBox();
    private JCheckBox jcbInProcessCreate = new JCheckBox();
    private LogManagerDayPanel sourcePanel;

    protected void jbInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.createLeftPanel(), (Component)this.createRightPanel(), 400L), "Center");
    }

    private JPanel getPeriodPanel() {
        this.monthPanel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("date")) {
                this.setData();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.monthPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createLeftPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        leftPanel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)((Object)this.devicePanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        return leftPanel;
    }

    private JPanel createRightPanel() {
        this.sourcePanel = new InetSourceManagerPanel(3, new int[]{0xFF0000, 65280, 255});
        this.sourcePanel.addMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 (\u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e)", "proccess");
        this.sourcePanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 (\u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e)", "deleteProccess");
        this.sourcePanel.addPopupSeparator();
        this.sourcePanel.addMenuItem("\u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0439 (\u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e)", "proccessCreateSession");
        this.sourcePanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u043d\u0430 \u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0439 (\u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e)", "deleteProccessCreateSession");
        this.sourcePanel.addPropertyChangeListener(e -> this.command(e.getPropertyName()));
        ActionListener actionViewMode = e -> this.setData();
        this.jcbLoad.setText("\u0415\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435");
        this.jcbLoad.setSelected(true);
        this.jcbLoad.addActionListener(actionViewMode);
        this.jcbInProcess.setText("\u0412 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435");
        this.jcbInProcess.setSelected(true);
        this.jcbInProcess.addActionListener(actionViewMode);
        this.jcbInProcessCreate.setText("\u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0439");
        this.jcbInProcessCreate.setSelected(true);
        this.jcbInProcessCreate.addActionListener(actionViewMode);
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        checkBoxPanel.add((Component)this.jcbLoad, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        checkBoxPanel.add((Component)this.jcbInProcess, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        checkBoxPanel.add((Component)this.jcbInProcessCreate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.sourcePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)checkBoxPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void setData() {
        InetDevice device = (InetDevice)this.devicePanel.getSelectedDevice();
        this.devicePanel.performAction("refresh");
        int[] exists = new int[32];
        int[] isLoading = new int[32];
        int[] isCreating = new int[32];
        boolean[] checked = new boolean[]{this.jcbLoad.isSelected(), this.jcbInProcess.isSelected(), this.jcbInProcessCreate.isSelected()};
        int[][] values = new int[3][];
        int[] quads = new int[32];
        if (device != null) {
            try {
                InetLogManagementService wsLogManagement = (InetLogManagementService)((ClientContext)this.getContext()).getWebService(InetLogManagementService.class);
                Result result = wsLogManagement.inetLogExist(Integer.valueOf(device.getId()), TimeUtils.convertLocalDateToDate((LocalDate)this.monthPanel.getLocalDate()));
                exists = (int[])result.getAttribute("logExists");
                List logsLoading = wsLogManagement.inetLogLoading(Integer.valueOf(device.getId()), TimeUtils.convertLocalDateToDate((LocalDate)this.monthPanel.getLocalDate()));
                isLoading = this.getLoadData(logsLoading);
                List logsCreating = wsLogManagement.inetLogSessionCreating(Integer.valueOf(device.getId()), TimeUtils.convertLocalDateToDate((LocalDate)this.monthPanel.getLocalDate()));
                isCreating = this.getLoadData(logsCreating);
                if (exists == null) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 . \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043d\u0430\u043b\u0438\u0447\u0438\u0438 \u043b\u043e\u0433\u043e\u0432 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    exists = new int[31];
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        values[0] = exists;
        values[1] = isLoading;
        values[2] = isCreating;
        this.sourcePanel.setViewMode(checked);
        this.sourcePanel.setData((int[][])values, quads, this.monthPanel.getLocalDate().lengthOfMonth());
    }

    public int[] getLoadData(List<DataProcessRecord> logs) {
        int[] isLoading = new int[31];
        for (DataProcessRecord log : logs) {
            int hour;
            Date day = log.getDay();
            int d = TimeUtils.convertDateToCalendar((Date)day).get(5);
            for (int i = hour = log.getCurentHour(); i < 24; ++i) {
                int n = d - 1;
                isLoading[n] = isLoading[n] | 1 << i;
            }
        }
        return isLoading;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.setData());
    }

    private void command(String command) {
        try {
            List days = this.sourcePanel.getSelectedDays(TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)this.monthPanel.getLocalDate().atStartOfDay()));
            InetDevice device = (InetDevice)this.devicePanel.getSelectedDevice();
            if (device != null) {
                InetLogManagementService wsLogManagement = (InetLogManagementService)((ClientContext)this.getContext()).getWebService(InetLogManagementService.class);
                if ("proccess".equals(command)) {
                    wsLogManagement.inetAddProcessLogs(Integer.valueOf(device.getId()), days);
                    this.setData();
                } else if ("deleteProccess".equals(command)) {
                    wsLogManagement.inetDeleteProcessLogs(Integer.valueOf(device.getId()), days);
                    this.setData();
                } else if ("proccessCreateSession".equals(command)) {
                    String message = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0438? \u041e\u043d\u0438 \u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u044e\u0442\u0441\u044f \u043f\u043e \u0444\u0430\u043a\u0442\u0443 \u043d\u0430\u043b\u0438\u0447\u0438\u044f \u0442\u0440\u0430\u0444\u0438\u043a\u0430.\n\u0421\u0435\u0441\u0441\u0438\u0438 \u0441\u043e\u0437\u0434\u0430\u044e\u0442\u0441\u044f 00:00 \u043f\u043e 23:59, \u0441\u0442\u0430\u0440\u044b\u0435 \u0441\u0435\u0441\u0441\u0438\u0438 \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u044b. \u041a \u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044e \u0441\u0435\u0441\u0441\u0438\u0438 \u043d\u0443\u0436\u043d\u043e \u043f\u0440\u0438\u0431\u0435\u0433\u0430\u0442\u044c \u0432 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \n\u0441\u043b\u0443\u0447\u0430\u044f\u0445, \u043a\u043e\u0433\u0434\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0438 \u043a\u0430\u043a\u0438\u0435-\u0442\u043e \u0441\u0431\u043e\u0438 \u0432 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0438 \u0441\u0435\u0441\u0441\u0438\u0438 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u043b\u0438\u0441\u044c. \u0412 \u043e\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u043b\u0443\u0447\u0430\u044f\u0445 \u0432\u0430\u043c \u0441\u043a\u043e\u0440\u0435\u0435 \u0432\u0441\u0435\u0433\u043e \n\u0445\u0432\u0430\u0442\u0438\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043b\u043e\u0433\u043e\u0432 \u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0430. \u041f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0438 \u043d\u0443\u0436\u043d\u043e \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u043b\u043e\u0433\u043e\u0432, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u044f\u0432\u0438\u043b\u0441\u044f \u0442\u0440\u0430\u0444\u0438\u043a.\n\u041f\u0440\u0438 \u044d\u0442\u043e\u043c \u043d\u0430 \u043d\u043e\u0432\u044b\u0445 \u0441\u0435\u0441\u0441\u0438\u044f\u0445 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438. \u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0439 \u0434\u043b\u044f  \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0434\u043d\u044f \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f";
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                        wsLogManagement.inetAddCreateSessions(Integer.valueOf(device.getId()), days);
                        this.setData();
                    }
                } else if ("deleteProccessCreateSession".equals(command)) {
                    wsLogManagement.inetDeleteCreateSessions(Integer.valueOf(device.getId()), days);
                    this.setData();
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

