/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class OptionTariffTreeNode
extends TariffTreeNode<InetTariffRequest, InetTariffContext, TreeContext, InetTariffWorkerContext> {
    private final Set<Integer> options;
    private final boolean modeOr;

    public OptionTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.options = new HashSet<Integer>(Utils.toIntegerList((String)parameterMap.get("options", "")));
        this.modeOr = parameterMap.getInt("mode", 0) == 0;
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, InetTariffContext ctx, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        if (this.options.size() == 0) {
            Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        Map options = req.getTariffOptionMap();
        if (options == null) {
            return 0;
        }
        if (this.modeOr) {
            if (this.options.size() > options.size()) {
                for (Integer o : options.keySet()) {
                    if (!this.options.contains(o)) continue;
                    Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
                    acceptedSet.add(parentTreeNodeId);
                    return 1;
                }
            } else {
                for (Integer o : this.options) {
                    if (!options.containsKey(o)) continue;
                    Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
                    acceptedSet.add(parentTreeNodeId);
                    return 1;
                }
            }
        } else if (options.keySet().containsAll(this.options)) {
            Set acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
            acceptedSet.add(parentTreeNodeId);
            return 1;
        }
        return 0;
    }
}

