/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelContractSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.kernel.dynamic.client.ClientDynLoader;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantActionBaseDialog;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantFieldType;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantKeyValue;
import ru.bitel.bgbilling.plugins.assistant.common.bean.FilterTableModel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;

public class AssistantActionDialog
extends AssistantActionBaseDialog {
    private int masterId = 0;
    private String comment = "";
    private String actionId;
    private JTextArea commentTextArea = null;
    private Map<String, String> messages = new HashMap<String, String>();
    private JSONObject configJsonObject = null;
    private JSONObject options = null;
    private Map<String, Component> componentMap = new HashMap<String, Component>();
    private Map<String, String> hiddenFileld = new HashMap<String, String>();
    private List<FieldRowData> fieldRowDatas = new ArrayList<FieldRowData>();
    private TableLayoutTableModel tableLayoutTableModel = null;
    private List<JSONObject> tableSelectedRows;

    public AssistantActionDialog(int masterId, String actionId, ClientContext clientContext) {
        super(clientContext);
        this.masterId = masterId;
        this.actionId = actionId;
        try {
            AssistantAction assistantAction = this.getAssistantService().getAssistantActionByActionId(masterId, actionId);
            if (assistantAction != null) {
                this.setTitle(assistantAction.getTitle());
                this.configJsonObject = new JSONObject(assistantAction.getConfig());
                this.options = this.configJsonObject.optJSONObject("options");
                if (this.options == null) {
                    this.options = new JSONObject();
                }
            } else {
                ClientUtils.showErrorMessageDialog((String)String.format("assistantAction == null \u0434\u043b\u044f masterId=%s, actionId=%s", masterId, actionId));
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getMessagePanel(), "North");
        this.getContentPane().add((Component)this.getPanelWithComponents(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        int width = this.options.optInt("windowSizeWidth", 600);
        int height = this.options.optInt("windowSizeHeight", 400);
        this.setSize(width, height);
        String windowSizeMode = this.options.optString("windowSizeMode");
        if ("\u0430\u0432\u0442\u043e".equals(windowSizeMode)) {
            this.pack();
        }
        this.moveWindowToCenterScreen();
    }

    private JPanel getMessagePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.comment = this.configJsonObject.optString("comment", null);
        if (Utils.notBlankString((String)this.comment)) {
            this.commentTextArea = new JTextArea(3, 5);
            this.commentTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.commentTextArea.setEditable(false);
            this.commentTextArea.setLineWrap(true);
            this.commentTextArea.setWrapStyleWord(true);
            this.commentTextArea.setText(this.comment);
            JScrollPane scrollPane = new JScrollPane(this.commentTextArea);
            scrollPane.setBorder(null);
            panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(15, 15, 10, 15), 0, 0));
        }
        return panel;
    }

    private JScrollPane getPanelWithComponents() {
        FocusAdapter messageAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AssistantActionDialog.this.commentTextArea != null) {
                    AssistantActionDialog.this.commentTextArea.setText(AssistantActionDialog.this.comment);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (AssistantActionDialog.this.commentTextArea != null) {
                    String message = AssistantActionDialog.this.messages.get(focusEvent.getComponent().getName());
                    AssistantActionDialog.this.commentTextArea.setText(Utils.notBlankString((String)message) ? message : AssistantActionDialog.this.comment);
                }
            }
        };
        JPanel table = null;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JSONArray params = this.configJsonObject.optJSONArray("params");
        if (params != null) {
            String windowLayout = this.configJsonObject.optJSONObject("options").optString("windowLayout");
            FieldLabelLayout labelLayout = Objects.requireNonNullElse(FieldLabelLayout.defineLayout(windowLayout), FieldLabelLayout.LEFT);
            boolean isAbove = FieldLabelLayout.ABOVE.equals((Object)labelLayout);
            block4: for (int index = 0; index < params.length(); ++index) {
                JSONObject paramObject = params.getJSONObject(index);
                String key = paramObject.optString("key");
                AssistantFieldType type = AssistantFieldType.getAssistantFieldTypeByCode((String)paramObject.optString("type"));
                String value = paramObject.optString("value");
                String comment = paramObject.optString("comment", null);
                JSONObject options = Optional.ofNullable(paramObject.optJSONObject("options")).orElse(new JSONObject());
                if (comment != null) {
                    this.messages.put(key, comment);
                }
                switch (labelLayout.ordinal()) {
                    case 2: {
                        this.tableLayout(type, key, value, panel, paramObject, options);
                        continue block4;
                    }
                    case 0: 
                    case 1: {
                        this.grigLayout(type, key, value, panel, paramObject, options, messageAdapter, isAbove);
                    }
                }
            }
            if (labelLayout == FieldLabelLayout.TABLE) {
                this.tableLayoutTableModel = new TableLayoutTableModel();
                table = new BGUTable((TableModel)((Object)this.tableLayoutTableModel));
                table.setSelectionMode(0);
                this.tableLayoutTableModel.setData(this.fieldRowDatas);
            }
        }
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane(table != null ? table : panel);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15), scrollPane.getBorder()));
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        return scrollPane;
    }

    private void tableLayout(AssistantFieldType type, String key, String value, JPanel panel, JSONObject paramObject, JSONObject options) {
        if (type != null) {
            FieldRowData fieldRowData = null;
            switch (type) {
                default: 
            }
            fieldRowData = new FieldRowData(this, type, key);
            fieldRowData.setValue(value);
            if (fieldRowData != null) {
                fieldRowData.setOptions(options);
                fieldRowData.setParamObject(paramObject);
                this.fieldRowDatas.add(fieldRowData);
            }
        }
    }

    private void grigLayout(AssistantFieldType type, String key, String value, JPanel panel, JSONObject paramObject, JSONObject options, FocusAdapter messageAdapter, boolean isAbove) {
        if (type != null) {
            Object component = null;
            switch (type) {
                case HIDDEN: {
                    this.hiddenFileld.put(key, value);
                    break;
                }
                case STRING: {
                    component = new JTextField(value);
                    this.addComponent(key, (Component)component, panel, paramObject, 1.0, 2, isAbove);
                    break;
                }
                case DATE: {
                    component = new BGControlPanelDateNoB();
                    this.addComponent(key, (Component)component, panel, paramObject, 0.0, 0, isAbove);
                    break;
                }
                case PERIOD: {
                    component = new BGControlPanelPeriodNoB(false);
                    this.addComponent(key, (Component)component, panel, paramObject, 0.0, 0, isAbove);
                    break;
                }
                case BOOLEAN: {
                    component = new JCheckBox();
                    this.addComponent(key, (Component)component, panel, paramObject, 0.0, 0, isAbove);
                    break;
                }
                case INTEGER: 
                case DECIMAL: {
                    component = new DecimalTextField(type == AssistantFieldType.INTEGER);
                    this.addComponent(key, (Component)component, panel, paramObject, 1.0, 2, isAbove);
                    break;
                }
                case CONTRACT: {
                    component = new BGControlPanelContractSelect(false, true);
                    this.addComponent(key, (Component)component, panel, paramObject, 1.0, 2, isAbove);
                    break;
                }
                case COMBOX: {
                    component = new BGUComboBox();
                    this.addComponent(key, (Component)component, panel, paramObject, 1.0, 1, isAbove);
                    break;
                }
                case TEXTAREA: {
                    component = new JTextArea(options.optInt("rows", 5), options.optInt("rows", 10));
                    ((JTextArea)component).setMargin(new Insets(3, 3, 3, 3));
                    this.addComponent(key, (Component)component, panel, paramObject, isAbove);
                    break;
                }
                case LIST: {
                    component = new JList();
                    ((JList)component).setSelectionMode(0);
                    this.addComponent(key, (Component)component, panel, paramObject, isAbove);
                    break;
                }
                case SELECTED_LIST: {
                    component = new BGControlPanelListSelect();
                    this.addComponent(key, (Component)component, panel, paramObject, isAbove);
                    break;
                }
                case TABLE: {
                    component = new BGUTable(null);
                    this.addComponent(key, (Component)component, panel, paramObject, isAbove);
                    break;
                }
                case LINK: {
                    component = new LinkLabel("<html><u>" + value + "</u></html>", value, this.comment);
                    this.addComponent(key, (Component)component, panel, paramObject, 1.0, 2, isAbove);
                    break;
                }
                case LABEL: {
                    component = new JLabel();
                    this.addComponent(key, (Component)component, panel, paramObject, 1.0, 2, isAbove);
                    break;
                }
                case ADDRESS: {
                    component = new AddressField();
                    this.addComponent(key, (Component)component, panel, paramObject, 1.0, 2, isAbove);
                    break;
                }
            }
            if (component != null) {
                component.addFocusListener(messageAdapter);
            }
        }
    }

    private void addComponent(String key, Component component, JPanel panel, JSONObject paramObject, boolean isAbove) {
        component.setName(key);
        this.componentMap.put(component.getName(), component);
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setMinimumSize(component.getMinimumSize());
        panel.add((Component)new JLabel(paramObject.optString("title")), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, isAbove ? 5 : 10, isAbove ? 0 : 5, 5), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(isAbove ? 0 : 1, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 10), 0, 0));
    }

    private void addComponent(String key, Component component, JPanel panel, JSONObject paramObject, double weightx, int fill, boolean isAbove) {
        component.setName(key);
        this.componentMap.put(component.getName(), component);
        JLabel label = new JLabel(paramObject.optString("title"));
        if (component instanceof JLabel) {
            label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() * 1.3f));
        }
        panel.add((Component)label, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, isAbove ? 15 : 10, isAbove ? 0 : 5, 5), 0, 0));
        panel.add(component, new GridBagConstraints(isAbove ? 0 : 1, -1, 1, 1, weightx, 0.0, 17, fill, new Insets(isAbove ? 2 : 0, 5, 5, 10), 0, 0));
    }

    private JPanel getButtonPanel() {
        ActionListener buttonActionListener = e -> this.doButton(e.getActionCommand());
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.showButton("1", buttonPanel, buttonActionListener);
        this.showButton("2", buttonPanel, buttonActionListener);
        this.showButton("3", buttonPanel, buttonActionListener);
        this.showButton("4", buttonPanel, buttonActionListener);
        this.showButton("Cancel", buttonPanel, e -> {
            this.setVisible(false);
            this.dispose();
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)buttonPanel, "Center");
        return panel;
    }

    private void showButton(String key, JPanel panel, ActionListener buttonActionListener) {
        if (this.options.optBoolean("windowShowButton" + key, false)) {
            AssistantButton assistantButton = AssistantButton.getAssistantButtonByCode((String)(key.toLowerCase().equals("cancel") ? "cancel" : "button" + key));
            JButton button = new JButton(this.options.optString("windowTextButton" + key, assistantButton.getTitle()));
            button.setActionCommand(assistantButton.getCode());
            button.addActionListener(buttonActionListener);
            panel.add(button);
        }
    }

    private void doButton(String button) {
        try {
            String status;
            JSONObject formData = this.getFormData();
            String resultOfPressButton = this.getAssistantService().doButton(this.masterId, this.actionId, formData.toString(), button);
            JSONObject resultJsonObject = new JSONObject(resultOfPressButton);
            JSONObject fieldsOfResponse = resultJsonObject.optJSONObject("fields");
            if (fieldsOfResponse != null) {
                JSONObject fieldsOfFromData = formData.optJSONObject("fields");
                if (fieldsOfFromData != null) {
                    for (String key : fieldsOfResponse.keySet()) {
                        fieldsOfFromData.put(key, fieldsOfResponse.get(key));
                    }
                }
                formData.put("fields", (Object)fieldsOfFromData);
            }
            if ("error".equals(status = resultJsonObject.optString("status"))) {
                ClientUtils.showMessageDialog((Object)resultJsonObject.optString("error"), (String)resultJsonObject.optString("errorTitle", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435"));
            } else if ("ok".equals(status)) {
                int openContractId;
                String nextActionId = resultJsonObject.optString("nextActionId");
                if (this.masterId > 0 && Utils.notBlankString((String)nextActionId)) {
                    AssistantActionDialog assistantActionDialog = new AssistantActionDialog(this.masterId, nextActionId, this.getContext());
                    assistantActionDialog.setVisible(true);
                    assistantActionDialog.showAction(formData.toString());
                }
                if (fieldsOfResponse != null && (openContractId = Utils.parseInt((String)fieldsOfResponse.optString("openContract"), (int)-1)) > 0) {
                    BGClientBase.getFrame().getTabbedPane().addContractEditorTab(openContractId);
                }
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void showAction(String formData) throws Exception {
        String windowSizeMode;
        JSONObject showData;
        JSONObject fieldsJsonObject;
        if (formData == null) {
            JSONObject data = new JSONObject();
            data.put("contractId", this.getContext().getContractId());
            formData = data.toString();
        }
        if ((fieldsJsonObject = (showData = new JSONObject(this.getAssistantService().doShow(this.masterId, this.actionId, formData))).optJSONObject("fieldValues")) != null) {
            for (String key : this.hiddenFileld.keySet()) {
                if (!fieldsJsonObject.has(key)) continue;
                this.hiddenFileld.put(key, fieldsJsonObject.optString(key));
            }
            for (String elementKey : this.componentMap.keySet()) {
                JSONObject json;
                AssistantKeyValue keyValue;
                AssistantKeyValue selected;
                JSONArray array;
                JSONArray array2;
                JSONObject json2;
                String itemValue;
                if (!fieldsJsonObject.has(elementKey)) continue;
                Component component = this.componentMap.get(elementKey);
                if (component instanceof BGControlPanelDateNoB) {
                    BGControlPanelDateNoB date = (BGControlPanelDateNoB)component;
                    itemValue = fieldsJsonObject.optString(elementKey);
                    if (itemValue == null) continue;
                    date.setLocalDate(this.parseDate(itemValue));
                    continue;
                }
                if (component instanceof JTextArea) {
                    JTextArea textArea = (JTextArea)component;
                    itemValue = fieldsJsonObject.optString(elementKey);
                    if (itemValue == null) continue;
                    textArea.setText(itemValue);
                    continue;
                }
                if (component instanceof JTextField) {
                    JTextField textField = (JTextField)component;
                    itemValue = fieldsJsonObject.optString(elementKey);
                    if (itemValue == null) continue;
                    textField.setText(itemValue);
                    continue;
                }
                if (component instanceof LinkLabel) {
                    LinkLabel linkLabel = (LinkLabel)component;
                    json2 = fieldsJsonObject.optJSONObject(elementKey);
                    if (json2 == null) continue;
                    linkLabel.setText(json2.optString("text", ""));
                    linkLabel.setUri(json2.optString("uri", "https://bgbilling.ru/"));
                    continue;
                }
                if (component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    Object object = fieldsJsonObject.opt(elementKey);
                    if (object instanceof JSONArray) {
                        array2 = (JSONArray)object;
                        if (array2 == null || array2.length() <= 0) continue;
                        JSONObject item = array2.getJSONObject(0);
                        label.setText(item.optString("value", ""));
                        continue;
                    }
                    label.setText(String.valueOf(object));
                    continue;
                }
                if (component instanceof BGControlPanelPeriodNoB) {
                    BGControlPanelPeriodNoB period = (BGControlPanelPeriodNoB)component;
                    json2 = fieldsJsonObject.optJSONObject(elementKey);
                    if (json2 == null) continue;
                    period.setDateFrom(TimeUtils.parseDate((String)json2.optString("dateFrom"), (String)"yyyy-MM-dd"));
                    period.setDateTo(TimeUtils.parseDate((String)json2.optString("dateTo"), (String)"yyyy-MM-dd"));
                    continue;
                }
                if (component instanceof BGUComboBox) {
                    BGUComboBox comboBox = (BGUComboBox)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null) continue;
                    selected = null;
                    ArrayList<AssistantKeyValue> items = new ArrayList<AssistantKeyValue>();
                    for (Object a : array) {
                        keyValue = new AssistantKeyValue(((JSONObject)a).optString("key"), ((JSONObject)a).optString("value"));
                        items.add(keyValue);
                        if (!"true".equals(((JSONObject)a).optString("selected"))) continue;
                        selected = keyValue;
                    }
                    comboBox.setData(items);
                    comboBox.setSelectedItem(selected);
                    continue;
                }
                if (component instanceof JList) {
                    JList list = (JList)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null) continue;
                    selected = null;
                    DefaultListModel<AssistantKeyValue> model = new DefaultListModel<AssistantKeyValue>();
                    for (Object a : array) {
                        keyValue = new AssistantKeyValue(((JSONObject)a).optString("key"), ((JSONObject)a).optString("value"));
                        model.addElement(keyValue);
                        if (!"true".equals(((JSONObject)a).optString("selected"))) continue;
                        selected = keyValue;
                    }
                    list.setModel(model);
                    list.setSelectedValue(selected, true);
                    continue;
                }
                if (component instanceof BGControlPanelListSelect) {
                    ArrayList<BGUListItem> listItems = new ArrayList<BGUListItem>();
                    String jsonArray = fieldsJsonObject.optJSONArray(elementKey).optJSONObject(0).optString("value");
                    array2 = new JSONArray(jsonArray);
                    for (int i = 0; i < array2.length(); ++i) {
                        JSONObject item = array2.getJSONObject(i);
                        int id = Utils.parseInt((String)item.optString("id"), (int)-1);
                        String title = item.optString("title");
                        if (id <= 0 || !Utils.notBlankString((String)title)) continue;
                        BGUListItem listItem = new BGUListItem(id, title);
                        listItem.setSelected(item.optBoolean("selected", false));
                        listItems.add(listItem);
                    }
                    ((BGControlPanelListSelect)component).getListModel().addAll(listItems);
                    continue;
                }
                if (component instanceof BGUTable) {
                    this.buildTable((BGUTable)component, fieldsJsonObject, elementKey);
                    continue;
                }
                if (component instanceof JCheckBox) {
                    JSONObject json3;
                    String value = "false";
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array != null && (json3 = array.optJSONObject(0)) != null) {
                        value = json3.optString("value");
                    }
                    if ("".equals(value)) {
                        value = fieldsJsonObject.optString(elementKey);
                    }
                    ((JCheckBox)component).setSelected("true".equals(value));
                    continue;
                }
                if (component instanceof BGControlPanelContractSelect) {
                    BGControlPanelContractSelect panel = (BGControlPanelContractSelect)component;
                    json = fieldsJsonObject.optJSONObject(elementKey);
                    if (json == null) continue;
                    panel.setContracts(json.optString("contractIds"), json.optString("title"));
                    continue;
                }
                if (!(component instanceof AddressField)) continue;
                AddressField addressField = (AddressField)component;
                json = fieldsJsonObject.optJSONObject(elementKey);
                if (json == null) continue;
                EntityAttrAddress address = new EntityAttrAddress(0, 0, json.optInt("houseId", 0), json.optInt("pod", 0), json.optInt("floor", 0), json.optString("flat"), json.optString("room"), json.optString("comment"), json.optString("formatKey"), json.optString("title"));
                addressField.setData(address);
            }
        }
        if ("\u0430\u0432\u0442\u043e".equals(windowSizeMode = this.options.optString("windowSizeMode"))) {
            this.pack();
            this.moveWindowToCenterScreen();
        }
    }

    private LocalDate parseDate(String value) {
        if (Utils.isBlankString((String)value)) {
            return null;
        }
        LocalDate date = null;
        try {
            date = TimeUtils.parseLocalDate((String)value, (String)"dd.MM.yyyy");
        }
        catch (DateTimeParseException e) {
            try {
                date = TimeUtils.parseLocalDate((String)value, (String)"yyyy-MM-dd");
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return date;
    }

    private void buildTable(final BGUTable table, JSONObject fieldsJsonObject, String elementKey) {
        table.setSelectionMode(2);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setVisibilityChecker((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        JSONArray array = fieldsJsonObject.optJSONArray(elementKey);
        String loadedClass = array.getJSONObject(0).getString("key");
        String filterList = array.getJSONObject(0).getString("value");
        Class customFilterClass = null;
        try {
            String packagePath = loadedClass.substring(0, loadedClass.lastIndexOf("."));
            customFilterClass = new ClientDynLoader(this.getContext(), packagePath).loadClass(loadedClass, true);
            if (customFilterClass.getSuperclass() != FilterTableModel.class) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u043b\u0430\u0441\u0441 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043d\u0430\u0441\u043b\u0435\u0434\u043d\u0438\u043a\u043e\u043c FilterTableModel!");
            }
        }
        catch (ClassNotFoundException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        StringReader reader = new StringReader(filterList);
        try {
            CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, customFilterClass);
            List filterTableModelList = (List)objectMapper.readValue((Reader)reader, (JavaType)type);
            final BGTableModel<FilterTableModel> tableModel = this.buildTableModel(filterTableModelList);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
                            int id;
                            String columnTitle = tableModel.getColumnName(i).toLowerCase();
                            if (!columnTitle.equals("contractid") && !columnTitle.equals("idcontract") && !columnTitle.equals("cid") && !columnTitle.equals("id \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430") || (id = ((Integer)tableModel.getValueAt(table.getSelectedRow(), i)).intValue()) <= 0) continue;
                            ContractService contractService = (ContractService)AssistantActionDialog.this.getContext().getPort(ContractService.class);
                            try {
                                Contract contract = contractService.contractGet(id);
                                if (contract == null || contract.getId() <= 0) continue;
                                BGClientBase.getFrame().getTabbedPane().addContractEditorTab(contract.getId());
                                break;
                            }
                            catch (Exception ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                            }
                        }
                    } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3 && tableModel.getSelectedRow() != null) {
                        JPopupMenu popupMenu = new JPopupMenu();
                        popupMenu.add("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u041c\u0430\u0441\u0442\u0435\u0440\u0430").addActionListener(e -> {
                            AssistantActionDialog.this.tableSelectedRows = new ArrayList<JSONObject>();
                            tableModel.getSelectedRows().forEach(row -> {
                                FilterTableModel selectedRow = row;
                                AssistantActionDialog.this.tableSelectedRows.add(new JSONObject((Object)selectedRow));
                            });
                        });
                        popupMenu.show((Component)table, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            table.setModel(tableModel);
            tableModel.setData(filterTableModelList);
        }
        catch (IOException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private BGTableModel<FilterTableModel> buildTableModel(final List<FilterTableModel> filterTableModelList) {
        return new BGTableModel<FilterTableModel>("filterTableModel"){

            protected void initColumns() {
                if (filterTableModelList != null && filterTableModelList.size() > 0) {
                    Field[] fields = ((FilterTableModel)filterTableModelList.get(0)).getClass().getDeclaredFields();
                    for (int x = 0; x < fields.length; ++x) {
                        Field field = fields[x];
                        String correctTitleColumn = ((FilterTableModel)filterTableModelList.get(0)).getCorrectTitleColumn(x);
                        if (correctTitleColumn == null) {
                            correctTitleColumn = field.getName();
                        }
                        this.addColumn(correctTitleColumn, field.getType(), false);
                    }
                }
            }

            public Object getValue(FilterTableModel val, int columnId) throws Exception {
                try {
                    Object data;
                    try {
                        Method correctDataMethod = val.getClass().getDeclaredMethod("getCorrectData", Integer.TYPE);
                        data = correctDataMethod.invoke((Object)val, columnId);
                        if (data != null) {
                            return data.toString();
                        }
                    }
                    catch (NoSuchMethodException | InvocationTargetException e) {
                        ClientUtils.showErrorMessageDialog((Throwable)e);
                    }
                    Field[] fields = val.getClass().getDeclaredFields();
                    Field field = fields[columnId];
                    field.setAccessible(true);
                    data = field.get(val);
                    if (data != null) {
                        return field.get(val);
                    }
                }
                catch (IllegalAccessException e) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043a\u043e\u043b\u043e\u043d\u043a\u0438 " + columnId + " \u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf(e)));
                }
                return super.getValue((Object)val, columnId);
            }
        };
    }

    private JSONObject getFormData() {
        JSONObject fieldsData = new JSONObject();
        for (String key : this.componentMap.keySet()) {
            AddressField addressField;
            JSONObject object;
            AssistantKeyValue assistantKeyValue;
            Component component = this.componentMap.get(key);
            if (component instanceof JTextField) {
                fieldsData.put(key, (Object)((JTextField)component).getText());
                continue;
            }
            if (component instanceof JTextArea) {
                fieldsData.put(key, (Object)((JTextArea)component).getText());
                continue;
            }
            if (component instanceof JCheckBox) {
                fieldsData.put(key, ((JCheckBox)component).isSelected());
                continue;
            }
            if (component instanceof BGControlPanelContractSelect) {
                fieldsData.put(key, (Object)((BGControlPanelContractSelect)component).getContracts());
                continue;
            }
            if (component instanceof BGControlPanelDateNoB) {
                LocalDate date = ((BGControlPanelDateNoB)component).getLocalDate();
                fieldsData.put(key, (Object)(date == null ? "" : date.toString()));
                continue;
            }
            if (component instanceof BGControlPanelPeriodNoB) {
                Period period = ((BGControlPanelPeriodNoB)component).getPeriod();
                JSONObject periodJsonObject = new JSONObject();
                if (period.getLocalDateFrom() != null) {
                    periodJsonObject.put("from", (Object)period.getLocalDateFrom().toString());
                }
                if (period.getLocalDateTo() != null) {
                    periodJsonObject.put("to", (Object)period.getLocalDateTo().toString());
                }
                fieldsData.put(key, (Object)periodJsonObject);
                continue;
            }
            if (component instanceof JList) {
                assistantKeyValue = (AssistantKeyValue)((JList)component).getSelectedValue();
                if (assistantKeyValue == null) continue;
                fieldsData.put(key, (Object)assistantKeyValue.getKey());
                continue;
            }
            if (component instanceof BGControlPanelListSelect) {
                BGControlPanelListSelect listSelect = (BGControlPanelListSelect)component;
                JSONArray selectedItems = new JSONArray();
                ArrayList<BGUListItem> elements = Collections.list(listSelect.getListModel().elements());
                if (!Utils.notEmptyCollection(elements)) continue;
                for (BGUListItem item : elements) {
                    JSONObject listItem = new JSONObject();
                    listItem.put("id", item.getId());
                    listItem.put("title", (Object)item.getTitle());
                    listItem.put("selected", item.isSelected());
                    selectedItems.put((Object)listItem);
                }
                fieldsData.put(key, (Object)selectedItems.toString());
                continue;
            }
            if (component instanceof BGUComboBox) {
                assistantKeyValue = (AssistantKeyValue)((BGUComboBox)component).getSelectedItem();
                if (assistantKeyValue == null) continue;
                fieldsData.put(key, (Object)assistantKeyValue.getKey());
                continue;
            }
            if (component instanceof BGUTable && this.tableSelectedRows != null) {
                fieldsData.put(key, this.tableSelectedRows);
                continue;
            }
            if (!(component instanceof AddressField) || (object = (addressField = (AddressField)component).getData()) == null) continue;
            fieldsData.put(key, (Object)object);
        }
        for (String hiddenKey : this.hiddenFileld.keySet()) {
            fieldsData.put(hiddenKey, (Object)this.hiddenFileld.get(hiddenKey));
        }
        JSONObject formData = new JSONObject();
        formData.put("fields", (Object)fieldsData);
        formData.put("contractId", this.getContext().getContractId());
        return formData;
    }

    class TableLayoutTableModel
    extends BGTableModel<FieldRowData> {
        public TableLayoutTableModel() {
            super(TableLayoutTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 300, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 400, 500, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(FieldRowData val, int column) throws Exception {
            String id = this.getIdentifier(column);
            if ("title".equals(id)) {
                return val.getParamObject().optString("title");
            }
            return super.getValue((Object)val, column);
        }
    }

    static enum FieldLabelLayout {
        LEFT("\u0418\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043b\u0435\u0432\u0430 \u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432"),
        ABOVE("\u0418\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0434 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043c\u0438"),
        TABLE("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432");

        String description;

        private FieldLabelLayout(String description) {
            this.description = description;
        }

        static FieldLabelLayout defineLayout(String desc) {
            return Stream.of(FieldLabelLayout.values()).filter(a -> a.description.equals(desc)).findFirst().orElse(null);
        }
    }

    public class FieldRowData {
        private final AssistantFieldType type;
        private final String key;
        private String value;
        private JSONObject paramObject;
        private JSONObject options;

        public FieldRowData(AssistantActionDialog this$0, AssistantFieldType type, String key) {
            this.type = type;
            this.key = key;
        }

        public AssistantFieldType getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public JSONObject getParamObject() {
            return this.paramObject;
        }

        public JSONObject getOptions() {
            return this.options;
        }

        public void setParamObject(JSONObject paramObject) {
            this.paramObject = paramObject;
        }

        public void setOptions(JSONObject options) {
            this.options = options;
        }
    }

    class DecimalTextField
    extends JTextField {
        private boolean integer = true;

        public DecimalTextField(boolean integer) {
            this.integer = integer;
        }

        @Override
        protected Document createDefaultModel() {
            return new DecimalModel(this.integer);
        }

        static class DecimalModel
        extends PlainDocument {
            private boolean integer = true;

            public DecimalModel(boolean integer) {
                this.integer = integer;
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                Object text = this.getText(0, this.getLength());
                if (((String)(text = ((String)text).substring(0, offs) + str + ((String)text).substring(offs))).matches(this.integer ? "^\\d*$" : "^(\\d*|\\d+\\.|\\d+\\.\\d+)$")) {
                    super.insertString(offs, str, a);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    class LinkLabel
    extends JLabel {
        public LinkLabel(String text, final String uri, String toolTipText) {
            super(text);
            this.setToolTipText(toolTipText);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI(uri));
                        }
                        catch (Exception e) {
                            ClientUtils.showErrorMessageDialog((Throwable)e);
                        }
                    }
                }
            });
        }

        public void setUri(String uri) {
        }
    }

    class AddressField
    extends JButton {
        private EntityAttrAddress entityAttrAddress;

        public AddressField() {
            this.reset();
            this.addActionListener(e -> {
                ContractParamEditorData contractParamEditorData = new ContractParamEditorData();
                contractParamEditorData.setClientContext(AssistantActionDialog.this.getContext());
                contractParamEditorData.setEntityType(EntityType.NEW_CONTRACT_PARAMETER);
                contractParamEditorData.setValue((EntityAttr)this.entityAttrAddress);
                new ContractParamAddressEditorDialog("\u0412\u044b\u0431\u043e\u0440 \u0430\u0434\u0440\u0435\u0441\u0430", contractParamEditorData).open();
                this.entityAttrAddress = (EntityAttrAddress)contractParamEditorData.getValue();
                if (this.entityAttrAddress == null) {
                    this.reset();
                } else {
                    this.setData(this.entityAttrAddress);
                }
            });
        }

        public JSONObject getData() {
            return this.entityAttrAddress != null ? this.entityAttrAddress.toJSON() : null;
        }

        public void reset() {
            this.setText("\u0430\u0434\u0440\u0435\u0441 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
        }

        public void setData(EntityAttrAddress entityAttrAddress) {
            this.entityAttrAddress = entityAttrAddress;
            this.setText(entityAttrAddress.getTitle());
        }
    }
}

