/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;

public class UsedConnectionsMonitor
extends Thread {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static long SLEEP_TIME = 300000L;
    private DialUpRadiusProcessor processor;

    public UsedConnectionsMonitor(DialUpRadiusProcessor processor) {
        this.processor = processor;
        this.start();
    }

    @Override
    public void run() {
        try {
            UsedConnectionsMonitor.sleep(SLEEP_TIME);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        HashSet<Long> checkAddressSet = new HashSet<Long>();
        while (true) {
            try {
                while (true) {
                    HashSet<Long> realUsedAddress = new HashSet<Long>();
                    for (DialUpNasConnection nasCon : this.processor.connections()) {
                        realUsedAddress.add(((DialUpSessionRealtime)nasCon.getSession()).getIpAddress());
                    }
                    for (Long address : checkAddressSet) {
                        if (realUsedAddress.contains(address) || !DialUpRadiusProcessor.usedAddressSet.containsKey(address)) continue;
                        this.logger.error("IP address marked as used incorrect: " + IPUtils.convertLongIpToString((long)address) + ", removing..");
                        DialUpRadiusProcessor.usedAddressSet.removeAddress(address);
                    }
                    checkAddressSet = new HashSet();
                    for (Long address : DialUpRadiusProcessor.usedAddressSet.keySet()) {
                        if (realUsedAddress.contains(address)) continue;
                        checkAddressSet.add(address);
                    }
                    UsedConnectionsMonitor.sleep(SLEEP_TIME);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }
}

