/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import bitel.billing.server.contract.bean.ContractParameterManager;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatusLogItem;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentType;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariableType;
import ru.bitel.bgbilling.plugins.documents.common.bean.SupportedFileFormat;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentJournalDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentStatusDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentTypeDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.BarcodeItem;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentPatternUtils;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentProcessorFactory;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.PatternDataExtractor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.PatternDataExtractorFactory;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsFileStorage;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsPatternFileStorage;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DocumentsPatternGenerator
extends BGLogger
implements AutoCloseable {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.documents");
    private Connection con;
    private DocumentsFileStorage documentsFileStorage;
    private DocumentsPatternFileStorage patternFileStorage;
    private DocumentPattern pattern;
    private DocumentType type;
    private DocumentJournal journal;
    private int contractId;
    private int userId;
    private int statusId;
    private Map<String, List<Map<String, String>>> tableData;
    private Map<String, Object> variableData;
    private DocumentDao documentDao;
    private DocumentStatusDao documentStatusDao;

    public DocumentsPatternGenerator(Connection connection, DocumentPattern pattern, int cid, int type, int journal, int user) throws BGException {
        this.patternFileStorage = new DocumentsPatternFileStorage(connection);
        this.documentsFileStorage = new DocumentsFileStorage(connection);
        this.statusId = Utils.parseInt((String)this.plugin.getSetup().get("default.status"), (int)0);
        this.con = connection;
        this.documentDao = new DocumentDao(this.con);
        this.documentStatusDao = new DocumentStatusDao(this.con);
        this.init(pattern, cid, type, journal, user);
    }

    public DocumentsPatternGenerator() {
    }

    public void init(DocumentPattern pattern, int contractId, int typeId, int journalId, int user) throws BGException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0428\u0430\u0431\u043b\u043e\u043d " + String.valueOf(pattern) + ". \u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        }
        this.tableData = new HashMap<String, List<Map<String, String>>>();
        this.variableData = new HashMap<String, Object>();
        this.pattern = pattern;
        this.contractId = contractId;
        try (DocumentTypeDao documentTypeDao = new DocumentTypeDao(this.con);
             DocumentJournalDao documentJournalDao = new DocumentJournalDao(this.con);){
            this.type = documentTypeDao.get(typeId);
            this.journal = documentJournalDao.get(journalId);
        }
        this.userId = user;
    }

    public Document generateDocument(Map<String, String> values) throws Exception {
        Document document;
        block16: {
            this.getLogger().debug("\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443");
            this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0430");
            if (values == null) {
                values = new HashMap<String, String>();
            }
            PatternDataExtractor extractor = PatternDataExtractorFactory.getExtractor(this.pattern.getDataExtractorClass());
            Map<String, String> varData = null;
            if (extractor != null) {
                varData = extractor.extractData(this.con, this.contractId, this.pattern, this.type, this.journal, values, this.userId);
            }
            this.prepareData(values, varData, true);
            document = null;
            try {
                List fileList;
                document = Document.builder().setContractId(this.contractId).setUserId(this.userId).setTypeId(this.type.getId()).setJournalId(this.journal.getId()).setPatternId(this.pattern.getId()).setTitle(this.pattern.getDocumentName()).setComment((String)(Utils.notBlankString((String)this.pattern.getDocumentComment()) ? this.pattern.getDocumentComment() : "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d " + TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy HH:mm:ss"))).build();
                this.documentDao.update(document);
                if (document.getId() <= 0) break block16;
                this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 id={}", (Object)document.getId());
                if (this.statusId > 0) {
                    document.setStatusId(this.statusId);
                    this.documentStatusDao.addStatusLog(DocumentStatusLogItem.builder().setComment("\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430").setDocumentId(document.getId()).setStatusDate(new Date()).setStatusId(this.statusId).setUserId(0).build());
                }
                if ((fileList = this.patternFileStorage.getFilesListByOwner(this.pattern.getId())) != null && !fileList.isEmpty()) {
                    BGServerFile patternServerFile = (BGServerFile)fileList.get(0);
                    if (patternServerFile == null) break block16;
                    this.getLogger().debug("\u0424\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043b\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438: {}", (Object)patternServerFile.getTitle());
                    SupportedFileFormat fileFormat = this.getFileExtensionByFilename(patternServerFile.getTitle());
                    try (FileInputStream fis = this.patternFileStorage.load(patternServerFile.getId());){
                        File tempFile = DocumentProcessorFactory.getInstance().getProcessor(this.con, document, this.pattern, fileFormat, this.variableData, this.tableData).process(fis);
                        this.saveFileToFilestorage(document, tempFile);
                        break block16;
                    }
                    catch (IOException e) {
                        throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0444\u0430\u0439\u043b\u043e\u043c \u0448\u0430\u0431\u043b\u043e\u043d\u0430!", (Throwable)e);
                    }
                    catch (BGIllegalArgumentException e) {
                        throw new BGException("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 " + String.valueOf(fileFormat), (Throwable)e);
                    }
                }
                throw new BGException("\u041d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430!");
            }
            catch (BGException ex) {
                this.documentDao.deleteDocument(document.getId());
                throw new BGException(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                this.documentDao.deleteDocument(document.getId());
                throw new BGException("\u041d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438: " + ex.toString(), (Throwable)ex);
            }
        }
        return document;
    }

    private void prepareData(Map<String, String> customValues, Map<String, String> dynClassData, boolean isPrepare) throws Exception {
        if (this.getLogger().isDebugEnabled() && isPrepare) {
            this.getLogger().debug("\u041f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u0435");
        }
        if (customValues != null) {
            this.variableData.putAll(customValues);
        }
        if (dynClassData != null) {
            for (String keyElement : dynClassData.keySet()) {
                if (this.variableData.containsKey(keyElement)) continue;
                this.variableData.put(keyElement, dynClassData.get(keyElement));
            }
        }
        Contract contract = null;
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            contract = (Contract)contractDao.get(this.contractId);
        }
        List variableList = this.pattern.getVariableList();
        variableList.sort(Comparator.comparing(DocumentVariable::getType));
        JSONObject customerJSON = null;
        for (DocumentVariable var : variableList) {
            if (this.variableData.containsKey(var.getTitle())) continue;
            DocumentVariableType varType = var.getType();
            Object value = null;
            switch (varType) {
                case CONTRACT_PARAM: {
                    try (ContractParameterManager cpm = new ContractParameterManager(this.con);){
                        int paramType = Utils.parseInt((String)var.getAdditionalParam(), (int)1);
                        int pid = Utils.parseInt((String)var.getValue());
                        HashMap map = cpm.getValuesForPids(Utils.toIntegerSet((String)("" + pid)), this.contractId);
                        String parameter = (String)map.get(pid);
                        if (parameter != null && (paramType == 3 || paramType == 5)) {
                            parameter = paramType == 3 ? parameter.replaceAll(";", ",") : (Utils.parseBoolean((String)parameter) ? "\u0414\u0430" : "\u041d\u0435\u0442");
                        }
                        value = Utils.maskBlank((String)parameter, (String)"").trim();
                        break;
                    }
                }
                case CUSTOMER_PARAM: {
                    Object varValue;
                    Customer customer;
                    CustomerDao customerDao;
                    int customerId;
                    if (customerJSON == null && (customerId = (customerDao = new CustomerDao(this.con)).getCustomerLink(this.contractId, LocalDateTime.now()).map(a -> a.getCustomerId()).orElse(-1).intValue()) > 0 && (customer = customerDao.getCustomer(customerId)) != null) {
                        customerJSON = new JSONObject(customer.getData());
                    }
                    if (customerJSON == null || !((varValue = customerJSON.query(var.getValue())) instanceof String)) break;
                    value = (String)varValue;
                    break;
                }
                case CONST: {
                    String constantValue = DocumentPatternUtils.insertPatternPart(var.getValue(), "contract_title", contract.getTitle());
                    constantValue = DocumentPatternUtils.insertPatternPart(constantValue, "contract_comment", contract.getComment());
                    constantValue = DocumentPatternUtils.insertPatternPart(constantValue, "current_user", UserMap.getUser((Integer)this.userId).getName());
                    int user = 0;
                    Pattern pattern = Pattern.compile("(.*)(\\$\\{user_\\d+\\})(.*)");
                    Matcher matcher = pattern.matcher(constantValue);
                    if (matcher.matches()) {
                        String macro = matcher.group(2);
                        int beginIndex = macro.indexOf("_");
                        int endIndex = macro.indexOf("}");
                        user = Utils.parseInt((String)macro.substring(beginIndex + 1, endIndex));
                    }
                    constantValue = DocumentPatternUtils.insertPatternPart(constantValue, "user_" + user, UserMap.getUser((Integer)user).getName());
                    value = Utils.maskBlank((String)constantValue, (String)"").trim();
                    break;
                }
                case DATE: {
                    String varValue;
                    String additionalParam = var.getAdditionalParam();
                    if (!Utils.notBlankString((String)additionalParam)) {
                        additionalParam = "dd.MM.yyyy";
                    }
                    if ((varValue = var.getValue()).contains("date_now") || varValue.contains("contract_date")) {
                        varValue = DocumentPatternUtils.insertPatternPart(var.getValue(), "date_now", TimeUtils.format((Date)new Date(), (String)additionalParam));
                        varValue = DocumentPatternUtils.insertPatternPart(varValue, "contract_date", TimeUtils.format((Date)contract.getDateFrom(), (String)additionalParam));
                    } else {
                        varValue = TimeUtils.format((Date)TimeUtils.parseDate((String)varValue, (String)"dd.MM.yyyy"), (String)additionalParam);
                    }
                    value = Utils.maskBlank((String)varValue, (String)"").trim();
                    break;
                }
                case SQL: {
                    String query = DocumentPatternUtils.insertPatternPart(var.getValue(), "cid", String.valueOf(this.contractId));
                    value = Utils.maskBlank((String)this.runSQL(query), (String)"").trim();
                    break;
                }
                case URL: {
                    try {
                        String line;
                        URL url = new URL(var.getValue());
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        StringBuilder result = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            result.append(line);
                        }
                        reader.close();
                        value = Utils.maskBlank((String)result.toString(), (String)"").trim();
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c URL(" + var.getValue() + "): " + e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 (" + var.getValue() + ")" + e.getMessage(), (Throwable)e);
                    }
                }
                case BARCODE: {
                    try {
                        int w = 150;
                        int h = 150;
                        String text = var.getValue();
                        int pos = text.indexOf(59);
                        if (pos != -1) {
                            String _sizes = text.substring(0, pos);
                            text = text.substring(pos + 1);
                            String[] _wh = _sizes.split("[xX]");
                            w = Integer.valueOf(_wh[0]);
                            h = Integer.valueOf(_wh[1]);
                        }
                        text = DocumentPatternUtils.insertPatternPart(text, "cid", String.valueOf(this.contractId));
                        text = DocumentPatternUtils.insertPatternPart(text, "contract_title", contract.getTitle());
                        text = DocumentPatternUtils.insertPatternPart(text, "contract_comment", contract.getComment());
                        text = DocumentPatternUtils.insertPatternPart(text, "current_user", UserMap.getUser((Integer)this.userId).getName());
                        List<String> varList = DocumentPatternUtils.getKeysFromString(text);
                        for (String varName : varList) {
                            text = DocumentPatternUtils.replaceText(text, varName, (String)this.variableData.get(varName));
                        }
                        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
                        hints.put(EncodeHintType.MARGIN, 2);
                        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                        QRCodeWriter qrCodeWriter = new QRCodeWriter();
                        BitMatrix byteMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, w, h, hints);
                        int matrixWidth = byteMatrix.getWidth();
                        int matrixHeight = byteMatrix.getHeight();
                        BufferedImage image = new BufferedImage(matrixWidth, matrixHeight, 1);
                        image.createGraphics();
                        Graphics2D graphics = (Graphics2D)image.getGraphics();
                        graphics.setColor(Color.WHITE);
                        graphics.fillRect(0, 0, matrixWidth, matrixWidth);
                        graphics.setColor(Color.BLACK);
                        for (int i = 0; i < matrixWidth; ++i) {
                            for (int j = 0; j < matrixWidth; ++j) {
                                if (!byteMatrix.get(i, j)) continue;
                                graphics.fillRect(i, j, 1, 1);
                            }
                        }
                        Path barcodeTempFile = Files.createTempFile(String.valueOf(System.currentTimeMillis()), ".gif", new FileAttribute[0]);
                        MatrixToImageWriter.writeToPath((BitMatrix)byteMatrix, (String)"gif", (Path)barcodeTempFile);
                        BarcodeItem item = new BarcodeItem();
                        item.setBarcodePath(barcodeTempFile);
                        item.setWidth(w);
                        item.setHeight(h);
                        value = item;
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434! \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e url!", (Throwable)e);
                    }
                    catch (WriterException | IOException e) {
                        throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434!", e);
                    }
                }
            }
            if (this.getLogger().isDebugEnabled() && isPrepare) {
                this.getLogger().debug("\t\u0418\u043c\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439: " + var.getTitle() + "; \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438: " + var.getValue() + "; \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438: " + String.valueOf(value));
            }
            this.variableData.put(var.getTitle(), value);
        }
    }

    public List<String> getNotFillParameters() throws Exception {
        this.prepareData(null, null, false);
        ArrayList<String> variables = new ArrayList<String>();
        ContractParameterPrefDao prefDao = new ContractParameterPrefDao(this.con);
        List variableList = this.pattern.getVariableList();
        variableList = variableList.stream().filter(n -> n.getType().equals((Object)DocumentVariableType.CONTRACT_PARAM)).collect(Collectors.toList());
        for (DocumentVariable var : variableList) {
            Object value = this.variableData.get(var.getTitle());
            if (value != null) continue;
            variables.add(((ContractParameterPref)prefDao.get(Utils.parseInt((String)var.getValue()))).getTitle());
        }
        return variables;
    }

    private void saveFileToFilestorage(Document document, File tempDocumentFile) throws BGException {
        block15: {
            try (FileInputStream fis = new FileInputStream(tempDocumentFile);){
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b " + tempDocumentFile.getName());
                }
                this.getLogger().info("\u0417\u0430\u043f\u0438\u0441\u044c \u0444\u0430\u0439\u043b\u0430 \u0432 filestorage \u0438 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0435\u0433\u043e \u043a \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0443");
                BGServerFile serverFile = new BGServerFile();
                serverFile.setContractId(document.getContractId());
                serverFile.setOwnerId(document.getId());
                serverFile.setUserId(document.getUserId());
                serverFile.setSize((long)fis.available());
                serverFile.setDate(new Date());
                serverFile.setComment((String)(Utils.notBlankString((String)this.pattern.getFileComment()) ? this.pattern.getFileComment() : "\u0424\u0430\u0439\u043b \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d " + TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy HH:mm:ss")));
                SupportedFileFormat fileFormat = this.getFileExtensionByFilename(((BGServerFile)this.patternFileStorage.getFilesListByOwner(this.pattern.getId()).get(0)).getTitle());
                serverFile.setTitle((Utils.notBlankString((String)this.pattern.getGeneratedFileNamePattern()) ? this.pattern.getGeneratedFileNamePattern() : "file") + "." + fileFormat.toString().toLowerCase());
                this.documentsFileStorage.updateFile(serverFile);
                if (serverFile.getId() <= 0) break block15;
                try {
                    String rootPath = this.plugin.getSetup().get("file.net.share.root.path");
                    if (!Utils.isEmptyString((String)rootPath)) {
                        String formatFile = FilenameUtils.getExtension((String)serverFile.getTitle());
                        this.documentsFileStorage.saveStream(serverFile.getId(), fis, formatFile);
                    } else {
                        this.documentsFileStorage.saveStream(serverFile.getId(), fis);
                    }
                }
                catch (IOException e) {
                    this.documentsFileStorage.deleteFile(serverFile.getId());
                    throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u0432 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u043f\u043b\u0430\u0433\u0438\u043d\u0430!", (Throwable)e);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                throw new BGException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                tempDocumentFile.delete();
            }
        }
    }

    private String runSQL(String query) throws BGException {
        String result = null;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private SupportedFileFormat getFileExtensionByFilename(String fileName) {
        String[] fileParts = fileName.split("\\.");
        return SupportedFileFormat.getSupportedFormat((String)fileParts[fileParts.length - 1]);
    }

    @Deprecated
    public void setTableData(int tablePos, List<Map<String, String>> tableData) {
        this.tableData.put(String.valueOf(tablePos), tableData);
    }

    public void setTableData(String tableIdentifier, List<Map<String, String>> tableData) {
        this.tableData.put(tableIdentifier, tableData);
    }

    @Override
    public void close() {
        try {
            this.documentDao.close();
            this.documentStatusDao.close();
        }
        catch (BGException ex) {
            this.logError("error close DocumentsPatternGenerator", ex);
        }
    }
}

