/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.common.service.CloudPaymentsService;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsAutopaymentEvent;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cloudpayments.common.service.CloudPaymentsService")
public class CloudPaymentsServiceImpl
extends AbstractService
implements CloudPaymentsService {
    @Resource
    private ContractAutopaymentService contractAutopaymentService;

    private TransactionManager getTransactionManager() {
        return new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws Exception {
        SearchResult transactionSearchResult = new SearchResult(searchParam.getPeriod(), searchParam.getPage(), searchParam.getSort());
        this.getTransactionManager().searchTransaction(transactionSearchResult, searchParam);
        return transactionSearchResult;
    }

    public void checkTransactions(int contractId) throws Exception {
        EventProcessor.getInstance().publish((Event)new CloudPaymentsCheckEvent(this.moduleId, contractId, true));
        EventProcessor.getInstance().publish((Event)new CloudPaymentsCheckEvent(this.moduleId, contractId, false));
    }

    public Autopayment autopaymentGet(int contractId) throws Exception {
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        return autopaymentManager.getCurrentAutopayment(contractId);
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws Exception {
        this.beginAutopaymentTransaction(contractId, amount, url, mode, paramsHolder, null);
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder, ContractAutopaymentMode autopaymentMode) throws Exception {
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (amount == null) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if ((amount = amount.setScale(2, RoundingMode.HALF_EVEN)).compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.", "contractModule.notEnabled");
        }
        if (mode != null) {
            mode.value = "redirect";
        }
        ModuleSetup moduleSetup = this.getModuleSetup();
        BigDecimal sum = amount;
        if (autopaymentMode == null) {
            BigDecimal sumMin = moduleSetup.getBigDecimal("cloudpayments.sum.min", new BigDecimal(100));
            BigDecimal sumMax = moduleSetup.getBigDecimal("cloudpayments.sum.max", new BigDecimal(5000));
            if (sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
            }
        }
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(contractId));
        String contractTitle = contractRuntime.getContractTitle();
        Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
        String resultUrl = (String)params.get("resultUrl");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String customerAddress = (String)params.get("receiptTo");
        if (autopaymentMode != null) {
            this.autopayment(contractId, contractTitle, autopaymentMode, customerAddress, dataMap, resultUrl);
        }
        url.value = Optional.ofNullable(dataMap.get("formUrl")).map(a -> String.valueOf(a)).orElse(null);
        if (url.value == null) {
            throw new BGMessageException(String.valueOf(dataMap.get("errorMessage")) + " [errorCode=" + String.valueOf(dataMap.get("errorCode")) + "]");
        }
        if (paramsHolder != null) {
            paramsHolder.value = new MapHolder(dataMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> String.valueOf(e.getValue()))));
        }
    }

    public void autopaymentDeactivate(int contractId) throws Exception {
        ContractAutopaymentMode.ContractAutopaymentModePeriodic mode = new ContractAutopaymentMode.ContractAutopaymentModePeriodic();
        mode.setMode(AutopaymentMode.OFF);
        this.autopayment(contractId, null, (ContractAutopaymentMode)mode, null, null, null);
    }

    private void autopayment(int contractId, String contractTitle, ContractAutopaymentMode mode, String customerAddress, Map<String, Object> dataMap, String resultUrl) throws Exception {
        AutopaymentManager autopaymentManager;
        Autopayment autopayment;
        if (mode != null && mode.getMode() != AutopaymentMode.OFF) {
            this.contractAutopaymentService.contractAutopaymentModeCheck(contractId, mode);
        }
        if ((autopayment = (autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId)).getCurrentAutopayment(contractId)) != null) {
            if (autopayment.getMode() != AutopaymentMode.OFF) {
                autopaymentManager.autopaymentOff(autopayment);
            }
            if (mode.getMode() != autopayment.getMode()) {
                autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                autopaymentManager.updateAutopayment(autopayment);
                autopayment = null;
            }
        } else if (mode.getMode() == AutopaymentMode.OFF) {
            throw new BGMessageException("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.", "autopayment.notFound");
        }
        if (autopayment == null) {
            autopayment = Autopayment.builder().setContractId(contractId).build();
        }
        if (mode.getMode() == AutopaymentMode.OFF) {
            autopayment.setMode(AutopaymentMode.OFF);
            autopayment.setModeData("");
            autopayment.setSum(BigDecimal.ZERO);
            autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
            autopayment.setAccessToken(null);
        } else {
            mode.toAutopayment(autopayment);
        }
        autopaymentManager.updateAutopayment(autopayment);
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws Exception {
        this.getTransactionManager().doCheckRequest(contractId, false);
    }

    public List<String[]> getAutopaymentBindingData(int contractId) throws Exception {
        ModuleSetup moduleSetup = this.getModuleSetup();
        String billingName = moduleSetup.get("cloudpayments.billing.name", Setup.getSetup().get("billing.name"));
        StringBuilder clientId = new StringBuilder();
        if (billingName != null) {
            clientId.append(billingName).append("_");
        }
        clientId.append(this.moduleId).append("_").append(contractId);
        StringBuilder spec = new StringBuilder();
        spec.append("?clientId=").append(clientId.toString());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
        }
        StringBuilder resultJson = new StringBuilder();
        try {
            URL registerUrl = new URL(spec.toString());
            HttpsURLConnection connection = (HttpsURLConnection)registerUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(false);
            connection.setDoInput(true);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    resultJson.append(line);
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: " + resultJson.toString());
            }
        }
        catch (Exception ex) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0421\u0431\u0435\u0440\u0431\u0430\u043d\u043a\u0430", "cloudpayments.connectionError");
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] errorData = new String[2];
        JSONObject resultJsonObject = new JSONObject(resultJson.toString());
        if (resultJsonObject.has("errorCode")) {
            errorData[0] = resultJsonObject.getString("errorCode");
        }
        if (resultJsonObject.has("errorMessage")) {
            errorData[1] = resultJsonObject.getString("errorMessage");
        }
        if (resultJsonObject.has("bindings")) {
            JSONArray array = resultJsonObject.getJSONArray("bindings");
            for (int index = 0; index < array.length(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                String[] listData = new String[]{jsonObject.getString("bindingId"), jsonObject.getString("maskedPan"), jsonObject.getString("expiryDate")};
                list.add(listData);
            }
        }
        list.add(0, errorData);
        return list;
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        SearchResult searchResult = new SearchResult(period, page, sort);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws Exception {
        AutopaymentManager autopaymentManager;
        Autopayment autopayment;
        if (contractId > 0 && (autopayment = (autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId)).getCurrentAutopayment(contractId)) != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
            EventProcessor.getInstance().publish((Event)new CloudPaymentsAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
        }
    }
}

