/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus.DeviceStatus;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus.PrinterStarrusException;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus.StarrusPrinter;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.DriverException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.FrkException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.NotImplementedException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.Utils;

public class Driver
extends BGLogger
implements ICashCheckDriver {
    private String address;
    private int port;
    private boolean cutterDisabled = false;
    private static int TYPE_PAY = 0;
    private static int TYPE_RETURN_PAY = 2;

    @Override
    public void init(Map<String, String> config) throws Exception {
        this.address = config.get("address");
        this.port = FrkUtils.parseInt(config.get("port"));
        this.cutterDisabled = Utils.parseBoolean((String)config.get("cutterDisabled"), (boolean)this.cutterDisabled);
    }

    @Override
    public void touchDriver() throws Exception {
        this.getLogger().debug("not implemented");
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return "device=" + this.address + ":" + this.port;
    }

    @Override
    public void printtext(String ... parameters) throws FrkException {
        int oppass = FrkUtils.parseInt(parameters[0]);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer._startBatch();
        for (int i = 1; i < parameters.length; ++i) {
            if ("!CUT%)".equals(parameters[i]) && !this.cutterDisabled) {
                printer.CutPaper(true);
                continue;
            }
            printer.PrintString(parameters[i]);
        }
        printer._doBatch();
    }

    @Override
    public String name(String operatorPass) throws FrkException {
        return "--\u0420\u041f \u0421\u0438\u0441\u0442\u0435\u043c\u0430 1\u0424\u0410";
    }

    @Override
    public String status(String operatorPass) throws FrkException {
        long oppass = FrkUtils.parseLong(operatorPass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        DeviceStatus ps = printer.LongDeviceStatus();
        return this.getStringStatus(ps);
    }

    private String getStringStatus(DeviceStatus ps) {
        return "\u0412\u0435\u0440\u0441\u0438\u044f: " + ps.Version1 + "." + ps.Version2 + "." + ps.Build + " (" + DateTimeUtils.formatDate((LocalDate)ps.SoftwareDate) + ")\n\u0421\u0440\u043e\u043a \u0430\u0440\u0435\u043d\u0434\u044b: " + DateTimeUtils.formatDate((LocalDate)ps.LeasedTo) + "\n\u041a\u043e\u0434 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430: " + String.valueOf((Object)ps.Mode) + "\n\u0424\u0430\u0437\u0430 \u0436\u0438\u0437\u043d\u0438 \u0424\u041d: " + String.valueOf((Object)ps.FNStatus) + "\n\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + String.valueOf((Object)ps.LastPrinterStatus) + "\n\u0421\u0440\u043e\u043a \u0436\u0438\u0437\u043d\u0438 \u0424\u041d: " + DateTimeUtils.formatDate((LocalDate)ps.FNExpirationDate) + "\n\u0424\u043b\u0430\u0433\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0424\u041d: " + String.valueOf(ps.FNFlags) + "\n\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + String.valueOf(ps.CurrentPrinterStatus) + "\n\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f: " + DateTimeUtils.formatDateTime((LocalDateTime)ps.CurrentDateTime) + "\n\u0420\u0435\u0436\u0438\u043c \u0430\u0440\u0435\u043d\u0434\u044b: " + ps.LeaseMode + "\n\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0424\u041d: " + ps.FNSerialNumber + "\n\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + ps.FNLastFiscalDocumentNumber + "\n\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u043a\u043e\u0440\u043e\u0433\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0430\u0440\u0435\u043d\u0434\u044b: " + ps.LeaseExpiredSoon + "\n\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + DateTimeUtils.formatDateTime((LocalDateTime)ps.FNLastFiscalDocumentDate);
    }

    @Override
    public void xreport(String adminPass) throws FrkException {
        long oppass = FrkUtils.parseLong(adminPass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer.IntermediateTurnReport();
    }

    @Override
    public void divreport(String adminPass) throws FrkException {
        throw new NotImplementedException("divreport", "\u043a\u0430\u0436\u0435\u0442\u0441\u044f \u0447\u0442\u043e \u0432 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0435 \u043d\u0435\u0442");
    }

    @Override
    public void zreport(String adminPass) throws FrkException {
        long oppass = FrkUtils.parseLong(adminPass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer.CloseTurn();
    }

    @Override
    public String closecheck_fix(String adminPass, String summa) throws FrkException {
        throw new NotImplementedException("closecheck_fix", "\u043d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u043e \u0437\u0430\u0447\u0435\u043c \u043d\u0443\u0436\u043d\u043e");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buzzer(String operatorPass) throws FrkException {
        long oppass = FrkUtils.parseLong(operatorPass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer.IdentDevice(true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            printer.IdentDevice(false);
        }
    }

    private int vat_convert(Integer vat) {
        if (vat == null) {
            return -1;
        }
        switch (vat) {
            default: {
                return vat;
            }
            case 1000020: {
                return 1;
            }
            case 1000010: {
                return 2;
            }
            case 1000000: {
                return 3;
            }
            case 1000999: {
                return 4;
            }
            case 1000120: {
                return 5;
            }
            case 1000110: 
        }
        return 6;
    }

    private static Integer payMethod_convert(Integer payMethod) {
        if (payMethod == null) {
            return null;
        }
        switch (payMethod) {
            case 1214001: {
                return 1;
            }
            case 1214002: {
                return 2;
            }
            case 1214003: {
                return 3;
            }
            case 1214004: {
                return 4;
            }
            case 1214005: {
                return 5;
            }
            case 1214006: {
                return 6;
            }
            case 1214007: {
                return 7;
            }
        }
        return payMethod;
    }

    private static Integer payObject_convert(Integer payObject) {
        if (payObject == null) {
            return null;
        }
        switch (payObject) {
            case 1212001: {
                return 1;
            }
            case 1212003: {
                return 3;
            }
            case 1212004: {
                return 4;
            }
            case 1212010: {
                return 10;
            }
            case 1212011: {
                return 11;
            }
            case 1212013: {
                return 13;
            }
        }
        return payObject;
    }

    private String _check(int type, String ... parameters) throws FrkException {
        Check commandCheckParameters = FrkUtils.processCommandCheckParameters(parameters, this.getLogger());
        if (commandCheckParameters.getCheckType() != null) {
            int newtype = -1;
            switch (commandCheckParameters.getCheckType()) {
                case PAYMENT: {
                    newtype = TYPE_PAY;
                    break;
                }
                case PAYMENTREFUND: {
                    newtype = TYPE_RETURN_PAY;
                    break;
                }
                case PAYMENTCORRECTION: {
                    throw new NotImplementedException("checkType=PAYMENTCORRECTION", NotImplementedException.CAN_BE_IMPLEMENTED);
                }
                case PAYMENTREFUNDCORRECTION: {
                    throw new NotImplementedException("checkType=PAYMENTREFUNDCORRECTION", NotImplementedException.CAN_BE_IMPLEMENTED);
                }
            }
            if (newtype != type) {
                this.getLogger().debug("Driver: overwrite check type from " + type + " to " + newtype);
                type = newtype;
            }
        }
        int oppass = FrkUtils.parseInt(parameters[0]);
        BigDecimal par1 = FrkUtils.parseBigDecimal(parameters[1]);
        BigDecimal clientsumma = type == TYPE_PAY ? par1 : commandCheckParameters.getPaymentsum();
        BigDecimal mul100 = new BigDecimal(100);
        this.getLogger().debug("Driver: check/checkreturn(clientsumma=" + String.valueOf(clientsumma) + ",type=" + type + "):");
        BigDecimal summa = commandCheckParameters.getPaymentsum();
        Integer taxTotal = commandCheckParameters.getTax();
        Integer payMethodTotal = commandCheckParameters.getPayMethod();
        Integer payObjectTotal = commandCheckParameters.getPayObject();
        Integer paymentType = commandCheckParameters.getPaymentType();
        if (type == TYPE_PAY && clientsumma.compareTo(summa) < 0) {
            throw new PrinterStarrusException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + clientsumma.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + summa.toPlainString() + ")");
        }
        boolean addedPhoneOrEmailOfCustomer = false;
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer._startBatch();
        printer.OpenTurnIfNeed();
        printer.OpenDocument(type);
        for (Check.CheckLine cl : commandCheckParameters.getLines()) {
            if (cl.getSumma() == null) {
                printer.AddPostText(cl.getText());
                continue;
            }
            int DocumentType = type;
            int Qty = 1000;
            long Price = cl.getSumma().multiply(mul100).longValue();
            Integer payMethod = Driver.payMethod_convert(cl.payMethod != null ? cl.payMethod : payMethodTotal);
            Integer payObject = Driver.payObject_convert(cl.payObject != null ? cl.payObject : payObjectTotal);
            int PayAttribute = payMethod != null ? payMethod : -1;
            int Linettribute = payObject != null ? payObject : -1;
            Integer tax = cl.tax != null ? cl.tax : taxTotal;
            int TaxId = this.vat_convert(tax);
            String Description = cl.getText();
            printer.AddLineToDocument(DocumentType, Qty, Price, PayAttribute, Linettribute, TaxId, Description);
            if (addedPhoneOrEmailOfCustomer) continue;
            if (commandCheckParameters.getCustomerEmail() != null) {
                printer.AddPhoneOrEmailOfCustomer(commandCheckParameters.getCustomerEmail());
            }
            addedPhoneOrEmailOfCustomer = true;
        }
        long sum = clientsumma.multiply(mul100).longValue();
        long Cash = 0L;
        long NonCash2 = 0L;
        long NonCash3 = 0L;
        long NonCash4 = 0L;
        if (paymentType == null || paymentType == 1 || paymentType == 1001) {
            Cash = sum;
        } else if (paymentType == 2 || paymentType == 1002) {
            NonCash2 = sum;
        } else if (paymentType == 3) {
            NonCash3 = sum;
        } else if (paymentType == 4) {
            NonCash4 = sum;
        } else {
            throw new DriverException("payment type must be 1..4");
        }
        printer.CloseDocument(Cash, NonCash2, NonCash3, NonCash4);
        printer._doBatch();
        return clientsumma.subtract(summa).toPlainString();
    }

    @Override
    public String check(String ... parameters) throws FrkException {
        return this._check(TYPE_PAY, parameters);
    }

    @Override
    public String checkreturn(String ... parameters) throws FrkException {
        return this._check(TYPE_RETURN_PAY, parameters);
    }

    @Override
    public void repeatcheck(String operatorPass) throws FrkException {
        long oppass = FrkUtils.parseLong(operatorPass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer.PrintLastSavedDocument();
    }

    @Override
    public String purecommand(String operatorPass, String command) throws FrkException {
        int oppass = FrkUtils.parseInt(operatorPass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        return printer.pureCmd(command);
    }

    @Override
    public void continueprint(String pass) throws FrkException {
        throw new NotImplementedException("continueprint", "\u043a\u0430\u0436\u0435\u0442\u0441\u044f \u0447\u0442\u043e \u0432 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0435 \u043d\u0435\u0442");
    }

    @Override
    public void cancelcheck(String pass) throws FrkException {
        long oppass = FrkUtils.parseLong(pass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer.CancelDocument();
    }

    @Override
    public void openday(String pass) throws FrkException {
        long oppass = FrkUtils.parseLong(pass);
        StarrusPrinter printer = new StarrusPrinter(this.address, this.port, oppass);
        printer.OpenTurn();
    }
}

