/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import java.util.Calendar;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Update;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.StopableThread;
import ru.bitel.common.Utils;

public class DNSUpdater
extends StopableThread {
    private static DNSUpdater updater;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean updateDNS = false;
    private Queue<Task> queue = new ConcurrentLinkedQueue<Task>();
    private String zone;
    private String dnsResolver;
    private String sharedKeyName;
    private String sharedKeyValue;
    private int ttl;
    private DialUpRadiusProcessor processor;

    public static void initUpdater(int moduleId, DialUpRadiusProcessor processor) {
        if (updater != null) {
            updater.shutdown();
        }
        updater = new DNSUpdater(moduleId, processor);
    }

    public static DNSUpdater getUpdater() {
        return updater;
    }

    private DNSUpdater(int moduleId, DialUpRadiusProcessor processor) {
        ModuleSetup setup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.zone = setup.get("dyn.dns.zone", null);
        this.dnsResolver = setup.get("dyn.dns.resolver", null);
        this.sharedKeyName = setup.get("dyn.dns.shared.key.name", null);
        this.sharedKeyValue = setup.get("dyn.dns.shared.key.value", null);
        this.ttl = setup.getInt("dyn.dns.ttl", 3600);
        this.updateDNS = Utils.notBlankString((String)this.zone) && Utils.notBlankString((String)this.dnsResolver) && Utils.notBlankString((String)this.sharedKeyName) && Utils.notBlankString((String)this.sharedKeyValue);
        this.processor = processor;
        this.log.info("Dynamic DNS init => " + this.updateDNS);
        if (this.updateDNS) {
            this.log.info("zone: " + this.zone + "; resolver: " + this.dnsResolver + "; sharedKeyName: " + this.sharedKeyName + "; sharedKeyValue: " + this.sharedKeyValue);
            this.start();
        }
    }

    public void run() {
        while (this.working) {
            try {
                Task nextTask = this.queue.poll();
                if (nextTask != null) {
                    if (nextTask.type == 1) {
                        this.regHost(nextTask.session);
                        continue;
                    }
                    this.unregHost(nextTask.session);
                    continue;
                }
                DNSUpdater.sleep((long)100L);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.log.info("Stopping DnsUpdater");
    }

    public void registerHost(DialUpSessionRealtime session) {
        int dnsType = session.getDynDNSType();
        if (this.updateDNS && (dnsType == 1 || dnsType == 2)) {
            Task task = new Task();
            task.type = 1;
            task.session = session;
            this.queue.add(task);
        }
    }

    public void unregisterHost(DialUpSessionRealtime session) {
        int dnsType = session.getDynDNSType();
        if (this.updateDNS && (dnsType == 1 || dnsType == 2)) {
            Task task = new Task();
            task.type = 2;
            task.session = session;
            this.queue.add(task);
        }
    }

    private void regHost(DialUpSessionRealtime session) {
        Name zone = null;
        Name host = null;
        SimpleResolver res = null;
        try {
            zone = Name.fromString((String)this.zone);
            host = Name.fromString((String)this.getHostName(session), (Name)zone);
            Update update = new Update(zone);
            update.replace(host, 1, (long)this.ttl, IPUtils.convertLongIpToString((long)session.getIpAddress()));
            session.addLogInfo("Register dynamic host " + String.valueOf(host) + " => " + IPUtils.convertLongIpToString((long)session.getIpAddress()));
            res = new SimpleResolver(this.dnsResolver);
            res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, this.sharedKeyName, this.sharedKeyValue));
            res.setTCP(false);
            res.send((Message)update);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void unregHost(DialUpSessionRealtime session) {
        Name zone = null;
        Name host = null;
        SimpleResolver res = null;
        try {
            String closedLogin = this.getHostName(session);
            Calendar closedStart = session.getStartTime();
            if (closedStart == null) {
                session.addLogInfo("Skip remove DNS record, becouse startTime=null");
                return;
            }
            for (DialUpNasConnection nasCon : this.processor.connections()) {
                Calendar startTime;
                DialUpSessionRealtime dialupSession = (DialUpSessionRealtime)nasCon.getSession();
                String login = this.getHostName(dialupSession);
                if (!login.equals(closedLogin) || (startTime = dialupSession.getStartTime()) == null || !startTime.after(closedStart)) continue;
                session.addLogInfo("DNS not removed, find later session");
                return;
            }
            zone = Name.fromString((String)this.zone);
            host = Name.fromString((String)closedLogin, (Name)zone);
            session.addLogInfo("Unregister dynamic host " + String.valueOf(host));
            Update update = new Update(zone);
            update.delete(host);
            res = new SimpleResolver(this.dnsResolver);
            res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, this.sharedKeyName, this.sharedKeyValue));
            res.setTCP(false);
            res.send((Message)update);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getHostName(DialUpSessionRealtime session) {
        Object result = null;
        int dynDNSType = session.getDynDNSType();
        String loginName = session.getLoginName();
        if (dynDNSType == 2) {
            result = loginName.replace('@', '-').toLowerCase();
        } else {
            result = String.valueOf(session.getLogin().getLogin());
            int pos = loginName.indexOf(64);
            if (pos > 0) {
                result = (String)result + "-" + loginName.substring(pos + 1);
            }
        }
        return result;
    }

    private static class Task {
        public static final int TYPE_REGISTER = 1;
        public static final int TYPE_UNREGISTER = 2;
        public int type = 1;
        public DialUpSessionRealtime session;

        private Task() {
        }
    }
}

