/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class AmountRangeTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    private int amount;
    private long from;
    private long to;

    public AmountRangeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.amount = parameterMap.getInt("amount", 0);
        int type = parameterMap.getInt("type", 0);
        int from = parameterMap.getInt("from", 0);
        this.from = this.getServiceAmount(type, from);
        int to = parameterMap.getInt("to", 0);
        this.to = this.getServiceAmount(type, to);
    }

    protected int executeImpl(Long treeNodeId, NPayTariffRequest req, NPayTariffContext context) {
        ModuleAmount moduleAmount = context.getModuleAmount(this.amount);
        if (moduleAmount == null) {
            req.addError("Not found amount " + this.amount);
            return 0;
        }
        long amountValue = TimeUtils.compare((Calendar)((NPayServiceCost)req.serviceCost).getDate1(), (Calendar)((NPayServiceCost)req.serviceCost).getDate2(), (int)5) == 0 ? moduleAmount.getDayAmount(req.getConnection(), req.contractId, ((NPayServiceCost)req.serviceCost).getDate1()) : moduleAmount.getPeriodAmount(req.getConnection(), req.contractId, ((NPayServiceCost)req.serviceCost).getDate1(), ((NPayServiceCost)req.serviceCost).getDate2());
        if (req.isInfoEnabled()) {
            req.addInfo("RANGE amountValue: " + amountValue + "; from: " + this.from + "; to: " + this.to);
        }
        if (amountValue >= this.from && (this.to == 0L || amountValue <= this.to)) {
            if (req.isInfoEnabled()) {
                req.addInfo("range_ok");
            }
            ((NPayServiceCost)req.serviceCost).periodAmount = BigDecimal.valueOf(amountValue);
            ((NPayServiceCost)req.serviceCost).monthAmount = BigDecimal.valueOf(this.to);
            return 1;
        }
        return 0;
    }

    protected int postExecuteImpl(Long treeNodeId, NPayTariffRequest req, NPayTariffContext context, int executeResult) {
        ((NPayServiceCost)req.serviceCost).periodAmount = null;
        ((NPayServiceCost)req.serviceCost).monthAmount = null;
        return super.postExecuteImpl(treeNodeId, (AbstractTariffRequest)req, (TariffContext)context, executeResult);
    }
}

