/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.client;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.dialup.client.TableLoginParameter;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class SPP_Parameter
extends ServicePanel {
    private TableLoginParameter parameterTable = new TableLoginParameter();
    private BGTable logTable = new BGTable();
    private JPanel logPanel = new JPanel();

    public SPP_Parameter() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setBorder((Border)new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.parameterTable));
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.parameterTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    SPP_Parameter.this.viewLogs();
                }
            }
        });
        this.logTable.setHeader(this.rb_name, this.moduleDoc, "login_parameters_log");
        this.logPanel.setBorder((Border)new BGTitleBorder("\u041b\u043e\u0433\u0438 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439"));
        JScrollPane scrollPane2 = new JScrollPane((Component)this.logTable);
        this.logPanel.setLayout(new GridBagLayout());
        this.logPanel.setVisible(false);
        this.logPanel.add((Component)scrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.logPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    public void setData() throws Exception {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetLoginParameter");
        request.setModuleId(this.getModuleId());
        request.setAttribute("lid", String.valueOf(this.id));
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.parameterTable.setRowsData(XMLUtils.selectElement((Node)doc, (String)"//parameters/data"));
        }
        this.logPanel.setVisible(false);
    }

    public boolean updateData() {
        StringBuilder values = new StringBuilder();
        int n = this.parameterTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.parameterTable.getValueAt(i, 1);
            String value = null;
            value = obj instanceof ComboBoxItem ? ((ComboBoxItem)obj).getObject().toString() : obj.toString();
            String name = this.parameterTable.getValueAt(i, 3).toString();
            if (values.length() > 0) {
                values.append(",");
            }
            values.append(name);
            values.append(":");
            values.append(value);
        }
        if (this.module != null && this.getModuleId() != 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("SaveLoginParameter");
            request.setAttribute("lid", String.valueOf(this.id));
            request.setAttribute("values", values.toString().trim());
            Document doc = this.getDocument(request);
            if (Utils.notBlankString((String)doc.getDocumentElement().getAttribute("access_error"))) {
                return true;
            }
            return ClientUtils.checkStatus((Document)doc);
        }
        return true;
    }

    private void viewLogs() {
        this.logPanel.setVisible(!this.logPanel.isVisible());
        if (this.isVisible()) {
            this.setLogs();
        }
    }

    public void setLogs() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("DynDNSLog");
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAttribute("lid", String.valueOf(this.id));
        String name = this.parameterTable.getValueAt(this.parameterTable.getSelectedRow(), 3).toString();
        request.setAttribute("name", name);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.logTable.updateData(XMLUtils.getNode((Document)doc, (String)"logs"));
        }
    }
}

