/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.server;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.CachedDirectory;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItemModifiedEvent;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryInfo;
import ru.bitel.common.model.Id;

class CachedServerDirectoryView<K extends Id>
implements Directory<K> {
    private final ServerDirectoryInfo<K> info;
    private final int moduleId;
    private final ServerContext context;
    private final Directory<K> service;
    private final CachedDirectory<K> cache;

    public CachedServerDirectoryView(ServerContext context, ServerDirectoryInfo<K> info, int moduleId, Directory<K> service, boolean cached) throws BGException {
        this.info = info;
        this.moduleId = moduleId;
        this.context = context;
        this.service = service;
        this.cache = cached ? info.getCache(moduleId) : new CachedDirectory(new AtomicLong());
    }

    @Override
    public K get(int id) throws BGException {
        try {
            return this.cache.get(this.service, id);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public K get(String title) throws BGException {
        return this.cache.get(this.service, title);
    }

    @Override
    public List<K> list() throws Exception {
        return this.cache.list(this.service);
    }

    @Override
    public void update(K k) throws Exception {
        K oldValue = this.cache.get(this.service, ((Id)k).getId());
        this.cache.update(this.service, k);
        this.fireModified(oldValue, k);
    }

    @Override
    public int delete(int id) throws Exception {
        K oldValue = this.cache.get(this.service, id);
        int result = this.cache.delete(this.service, id);
        this.fireModified(oldValue, null);
        return result;
    }

    private void fireModified(K oldValue, K newValue) throws BGException {
        DirectoryItemModifiedEvent<?> modifiedEvent = this.info.newModifiedEvent(this.moduleId, this.context.getUserId(), oldValue, newValue);
        if (modifiedEvent != null) {
            this.context.publishAfterCommit(modifiedEvent);
        }
    }
}

