/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ContractTitlePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostEditorDialog;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ForpostContractUserPanel
extends ForpostContractBasePanel {
    private UserTableModel tableModel;

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new ContractTitlePanel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438:", (JComponent)((Object)this)), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapScrollPane((JComponent)this.getTable(), (int)300, (int)100), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void deleteAccountUsers(int id) throws Exception {
        this.getForpostService().forpostAccountUsersDelete(this.accountId);
    }

    @Override
    protected BGTableModel<?> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new UserTableModel();
        }
        return this.tableModel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            ForpostUser forpostUser = this.getForpostService().forpostUserDefaultGet(((ClientContext)this.getContext()).getContractId(), this.accountId);
            new ForpostEditorDialog<ForpostUser>(forpostUser, "forpost.contractUserAdd", (ClientContext)this.getContext(), (JPanel)((Object)this)).getDialog().setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            ForpostUser forpostUser = (ForpostUser)((UserTableModel)this.getTableModel()).getSelectedRow();
            if (forpostUser == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\" \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.");
            } else {
                new ForpostEditorDialog<ForpostUser>(forpostUser, "forpost.contractUserEdit", (ClientContext)this.getContext(), (JPanel)((Object)this)).getDialog().setVisible(true);
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ForpostUser forpostUser = (ForpostUser)((UserTableModel)this.getTableModel()).getSelectedRow();
            if (forpostUser == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\" \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f.");
            } else if (ClientUtils.confirmDelete((Object)forpostUser.getLogin())) {
                this.getForpostService().forpostUserDelete(forpostUser.getId());
                this.performAction("user.refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("user.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", ICON_REFRESH){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((UserTableModel)ForpostContractUserPanel.this.getTableModel()).setData(ForpostContractUserPanel.this.getForpostService().forpostAccountUserSearch(ForpostContractUserPanel.this.accountId).getList());
            }
        };
    }

    class UserTableModel
    extends BGTableModel<ForpostUser> {
        public UserTableModel() {
            super(UserTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 150, 150, 150, "login", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u043e\u043b\u044c", 150, 150, 150, "isReadOnly", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0424\u0418\u041e", 100, 500, -1, "fio", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", 100, 500, -1, "phone", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("Email", 100, 500, -1, "email", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u0435\u043d", Boolean.class, 70, 70, 70, "isActive", true);
        }

        public Object getValueAt(ForpostUser forpostUser, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            Map map = Utils.linesToPairsHash((String)forpostUser.getData());
            if ("isActive".equals(identifier)) {
                return forpostUser.getIsActive() == 1;
            }
            if ("email".equals(identifier)) {
                return map.get("Email");
            }
            if ("phone".equals(identifier)) {
                return map.get("Phone");
            }
            if ("fio".equals(identifier)) {
                return map.get("FIO");
            }
            if ("isReadOnly".equals(identifier)) {
                String isReadOnly = (String)map.get("IsReadOnly");
                return isReadOnly == null ? "" : (isReadOnly.equals("1") ? "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c" : "\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440");
            }
            return super.getValueAt((Object)forpostUser, column);
        }
    }
}

