/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.zip.Deflater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZLIBWritableChannel
implements WritableByteChannel {
    private static final Logger log = LogManager.getLogger();
    protected final Deflater deflater;
    protected final WritableByteChannel writableByteChannel;
    protected final ByteBuffer byteBuffer;
    protected final int bufferLength;

    public ZLIBWritableChannel(WritableByteChannel writableByteChannel, ByteBuffer buffer, int level, int strategy) {
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException();
        }
        this.writableByteChannel = writableByteChannel;
        this.byteBuffer = buffer;
        this.deflater = new Deflater(level);
        this.deflater.setStrategy(strategy);
        this.bufferLength = this.byteBuffer.capacity();
        log.debug("ZLIBWritableChannel bufferLength=" + this.bufferLength);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        assert (src.hasArray());
        int limit = src.remaining();
        this.deflater.setInput(src.array(), src.arrayOffset() + src.position(), limit);
        this.deflate();
        return limit;
    }

    protected int deflate() throws IOException {
        int len = this.deflater.deflate(this.byteBuffer.array(), 0, this.byteBuffer.limit());
        if (len > 0) {
            this.byteBuffer.position(0);
            this.byteBuffer.limit(len);
            this.writableByteChannel.write(this.byteBuffer);
            this.byteBuffer.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug("Deflating... " + this.byteBuffer.limit() + " " + len);
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        log.debug("Close ZLIBWritableChannel...");
        try {
            if (!this.deflater.finished()) {
                this.deflater.finish();
                while (!this.deflater.finished()) {
                    int len = this.deflate();
                    this.byteBuffer.position(0);
                    this.byteBuffer.limit(len);
                }
            }
        }
        finally {
            try {
                this.deflater.end();
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            try {
                this.writableByteChannel.close();
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.writableByteChannel.isOpen();
    }

    public static class ZLIBWritableChannelSync
    extends ZLIBWritableChannel {
        public ZLIBWritableChannelSync(WritableByteChannel writableByteChannel, ByteBuffer buffer, int level, int strategy) {
            super(writableByteChannel, buffer, level, strategy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws IOException {
            ZLIBWritableChannelSync zLIBWritableChannelSync = this;
            synchronized (zLIBWritableChannelSync) {
                return super.write(src);
            }
        }
    }
}

