/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.plugins.assistant.client.admin.AssistantActionLibraryTab;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ExportImportDialog;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.common.ZipUtils;

public class ImportAssistantMaster {
    private ClientContext context;
    private AssistantActionLibraryTab parent;
    private List<AssistantAction> importActions = new ArrayList<AssistantAction>();
    private Map<String, byte[]> dynamicClasses = new HashMap<String, byte[]>();

    public ImportAssistantMaster(ClientContext context, AssistantActionLibraryTab parent) {
        this.context = context;
        this.parent = parent;
        this.showImportDialog();
    }

    private void showImportDialog() {
        File file;
        BGFileChooser fileChooser = new BGFileChooser((Component)((Object)this.parent));
        fileChooser.setDialogTitle("\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u0430\u0441\u0442\u0435\u0440 \u0432 \u043f\u043b\u0430\u0433\u0438\u043d \u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a");
        fileChooser.setApproveButtonText("\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        fileChooser.setFileFilter(new FileFilter(this){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".action");
            }

            @Override
            public String getDescription() {
                return "(*.action)";
            }
        });
        int responce = fileChooser.showOpenDialog((Component)((Object)this.parent));
        if (responce == 0 && (file = fileChooser.getSelectedFile()) != null) {
            this.showImportDialog(file);
            this.parent.performAction("refresh");
        }
    }

    private void showImportDialog(File zipFile) {
        ImportDialog importDialog = new ImportDialog(this.parent);
        importDialog.setDataImportDialog(zipFile);
        if (importDialog.showDialog().equals("ok")) {
            this.saveActions();
        }
    }

    private void saveActions() {
        AssistantService assistantService = (AssistantService)this.context.getPort(AssistantService.class);
        this.importActions.forEach(action -> {
            try {
                assistantService.assistantActionUpdate(action);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        this.dynamicClasses.forEach((className, classData) -> {
            try {
                this.saveSource((String)className, (byte[])classData);
            }
            catch (IOException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }

    private void saveSource(String className, byte[] source) throws IOException {
        try {
            DynamicCodeService dynCodeService = (DynamicCodeService)this.context.getPort(DynamicCodeService.class);
            dynCodeService.updateSource(className, new String(source, StandardCharsets.UTF_8));
            dynCodeService.compile(className);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class ImportDialog
    extends ExportImportDialog {
        ImportDialog(AssistantActionLibraryTab parent) {
            super(parent, "\u0414\u0430\u043d\u043d\u044b\u0435 \u041c\u0430\u0441\u0442\u0435\u0440\u0430 \u0431\u0443\u0434\u0443\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u044b", "");
            this.setTitle("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            this.setResizable(false);
            this.actionList.setEnabled(false);
            this.pack();
            this.moveWindowToCenterScreen();
        }

        void setDataImportDialog(File zipFile) {
            try {
                Map files = ZipUtils.unZip((String)zipFile.getAbsolutePath());
                files.forEach((fileName, data) -> {
                    if (fileName.equals("description") && data != null) {
                        this.version.setText(this.getMasterVersion((byte[])data));
                        this.description.setText(this.getDescriptionMaster((byte[])data));
                        return;
                    }
                    if (fileName.endsWith(".java")) {
                        String correctClassName = this.getCorrectClassName((String)fileName);
                        String[] mas = new String((byte[])data).split("\n");
                        StringBuilder dataResult = new StringBuilder();
                        dataResult.append(this.getPackage(correctClassName));
                        for (int x = 1; x < mas.length; ++x) {
                            dataResult.append(mas[x]).append("\n");
                        }
                        try {
                            ImportAssistantMaster.this.dynamicClasses.put(correctClassName, dataResult.toString().getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    } else {
                        ImportAssistantMaster.this.importActions.add(this.getAssistantAction((byte[])data));
                    }
                });
                ImportAssistantMaster.this.importActions.forEach(action -> {
                    AssistantActionItem actionItem = new AssistantActionItem();
                    actionItem.setTitle(action.getTitle());
                    this.listModel.addElement(actionItem);
                });
            }
            catch (IOException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        private String getPackage(String fullClassName) {
            StringBuilder result = new StringBuilder("package ");
            String[] mas = fullClassName.split("\\.");
            for (int x = 0; x < mas.length - 1; ++x) {
                result.append(mas[x]).append(".");
            }
            if (result.toString().endsWith(".")) {
                result.replace(result.length() - 1, result.length(), "");
            }
            result.append(";");
            result.append("\n");
            return result.toString();
        }

        private String getMasterVersion(byte[] data) {
            String descriptionText = new String(data);
            try {
                JSONObject descriptionJSON = new JSONObject(descriptionText);
                return descriptionJSON.getString("version");
            }
            catch (JSONException ex) {
                return "\u0412\u0435\u0440\u0441\u0438\u044f \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u041c\u0430\u0441\u0442\u0435\u0440\u0430: ?";
            }
        }

        private String getDescriptionMaster(byte[] data) {
            String description = new String(data);
            try {
                JSONObject json = new JSONObject(description);
                String descriptionAuthor = json.getString("description");
                String comment = "\n\n\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0430\u0432\u0442\u043e\u0440\u0430 \u043a \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u041c\u0430\u0441\u0442\u0435\u0440\u0443:\n" + json.getString("comment");
                return descriptionAuthor + comment;
            }
            catch (JSONException ex) {
                return "";
            }
        }

        private String getCorrectClassName(String fileName) {
            StringBuilder correct = new StringBuilder();
            String[] mas = fileName.split("\\.");
            for (int x = 0; x < mas.length; ++x) {
                if (mas[x].contains("java")) continue;
                correct.append(mas[x]).append(".");
            }
            String result = correct.toString().endsWith(".") ? correct.toString().substring(0, correct.length() - 1) : correct.toString();
            return result;
        }

        private AssistantAction getAssistantAction(byte[] data) {
            String dataStr = new String(data);
            JSONObject json = new JSONObject(dataStr);
            AssistantAction assistantAction = new AssistantAction();
            assistantAction.setTitle(json.getString("title"));
            assistantAction.setConfig(json.getString("config"));
            assistantAction.setDependent(json.getInt("dependent"));
            assistantAction.setActionClass(json.getString("actionClass"));
            assistantAction.setActionId(json.getString("actionId"));
            return assistantAction;
        }
    }
}

