/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.server.dao.AttributeLinkKitDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class StockItemAttributeKitDao
extends AbstractIdDao<StockItemAttributeKit> {
    private final AttributeLinkKitDao linkKitDao;
    private final StockItemAttributeDao attributeDao;

    public StockItemAttributeKitDao(Connection con, int moduleId) {
        super(con, moduleId, "stock_item_attribute_kit");
        this.linkKitDao = new AttributeLinkKitDao(con);
        this.attributeDao = new StockItemAttributeDao(con, moduleId);
    }

    protected StockItemAttributeKit getFromRS(ResultSet rs) throws SQLException, BGException {
        StockItemAttributeKit kit = new StockItemAttributeKit();
        kit.setId(rs.getInt("id"));
        kit.setTitle(rs.getString("title"));
        kit.setAttributes(this.linkKitDao.getAttributesByKitId(kit.getId(), this.attributeDao));
        return kit;
    }

    protected void updateImpl(StockItemAttributeKit kit) throws BGException, SQLException {
        boolean isNew = kit.getId() <= 0;
        String prefix = isNew ? "INSERT INTO " : "UPDATE ";
        String query = prefix + this.tableName + " SET title=?" + (isNew ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, kit.getTitle());
            if (!isNew) {
                ps.setInt(2, kit.getId());
            }
            ps.executeUpdate();
            if (isNew) {
                kit.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
    }

    public List<StockItemAttributeKit> getList() throws BGException {
        ArrayList<StockItemAttributeKit> result = new ArrayList<StockItemAttributeKit>();
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM " + this.tableName);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

