/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceServiceCost;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ServiceSetTariffTreeNode
extends DefaultTariffTreeNode<VoiceTariffRequest, TariffContext> {
    private final Pattern pattern;
    private final Integer serviceId;

    public ServiceSetTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String regexp = parameterMap.get("regexp", null);
        this.pattern = Utils.notBlankString((String)regexp) ? Pattern.compile(regexp) : null;
        this.serviceId = parameterMap.getInt("sid", 0);
    }

    protected int executeImpl(Long treeNodeId, VoiceTariffRequest req, TariffContext ctx) {
        String phone = req.getPhoneOriginalTo();
        if (Utils.notBlankString((String)phone) && (this.pattern == null || this.pattern.matcher(phone).find())) {
            ArrayList<VoiceServiceCost> serviceCosts = (ArrayList<VoiceServiceCost>)req.getServiceCost().get(((VoiceServiceCost)req.serviceCost).getServiceId());
            if (serviceCosts != null) {
                serviceCosts.remove(req.serviceCost);
            }
            ((VoiceServiceCost)req.serviceCost).setServiceId(this.serviceId);
            serviceCosts = (List)req.getServiceCost().get(this.serviceId);
            if (serviceCosts == null) {
                serviceCosts = new ArrayList<VoiceServiceCost>();
                req.getServiceCost().put(this.serviceId, serviceCosts);
            }
            serviceCosts.add((VoiceServiceCost)req.serviceCost);
            return 1;
        }
        return 0;
    }
}

