/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.license.client.contract.LicenceBGUTable;
import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.AdditionalAgreement;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrder;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderPermanentNew;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderTestNew;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class OrdersPanel
extends BGUPanel {
    private int copyId = -1;
    private static final String PANEL_LIST = "list";
    private static final String PANEL_NEW = "new";
    private BGTableModel<LicenseOrder> ordersTableModel;
    private FilterPanel filter = new FilterPanel();
    private CardLayout cardLayout = new CardLayout();
    private ComponentPanel componentPanel = new ComponentPanel();
    private BGUTable permanentOrderTable;
    private BGTableModel<LicenseOrderPermanentNew> permanentModel;
    private BGUTable testOrderTable;
    private BGTableModel<LicenseOrderTestNew> testModel;
    private List<LicenseComponent> componentList;
    private JPanel newOrderPanel;
    private ActionListener componentActionListener;
    final BGTextField superTotalCost = new BGTextField(10);
    final BGButton saveButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    final BGButton transferButton = new BGButton("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0437\u0430\u043a\u0430\u0437\u044b \u0438\u0437 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
    AbstractBGUPanel.DefaultAction deletePermanentOrder;
    AbstractBGUPanel.DefaultAction deleteTestOrder;
    AbstractBGUPanel.DefaultAction setDataOrder;
    private BGUPanel.WebServiceHolder<LicenseService> licenseService = new BGUPanel.WebServiceHolder((BGUPanel)this, LicenseService.class);
    JMenu testOrdersJMenu = new JMenu("\u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0435(\u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441)");
    JMenu permanentOrdersJMenu = new JMenu("\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0435(\u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441)");

    public void setCopyId(int id) {
        this.copyId = id;
        this.tryCall(() -> {
            List list = ((LicenseService)this.licenseService.get()).additionalAgreements(((ClientContext)this.getContext()).getContractId(), this.copyId);
            this.transferButton.setVisible(list.size() == 0);
            if (list.size() == 0 && this.transferButton.getActionListeners().length == 0) {
                this.addActionForTransferButton();
            }
        });
    }

    public OrdersPanel() {
        this.ordersTableModel = new BGTableModel<LicenseOrder>("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u0437\u0430\u043a\u0430\u0437\u043e\u0432"){

            protected void initColumns() {
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 120, 120, 120, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u0422\u0438\u043f", 150, 150, 150, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "componentTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 120, 120, 120, "count", true);
                this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", 160, 160, 160, "createDate", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
                this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 200, 200, 200, "userName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumnId();
            }

            public Object getValue(LicenseOrder order, int column) throws Exception {
                Object value = null;
                String columnIdentifier = this.getIdentifier(this.table.getColumnModel().getColumn(column).getModelIndex());
                if ("status".equals(columnIdentifier)) {
                    value = OrderUtils.getStatus((int)order.getStatus());
                } else if ("type".equals(columnIdentifier)) {
                    String type = OrderUtils.getType((LicenseOrderType)order.getType());
                    value = order.getType() == LicenseOrderType.TEST ? type + OrderUtils.getTerm((int)order.getTerm()) : OrderUtils.getType((LicenseOrderType)order.getType());
                } else {
                    value = "count".equals(columnIdentifier) ? OrderUtils.getCount((Integer)order.getCount()) : super.getValue((Object)order, column);
                }
                return value;
            }
        };
    }

    public void jbInit() {
        this.setLayout(this.cardLayout);
        this.add(this.getOrderPanel(), PANEL_LIST);
    }

    private JPanel getOrderPanel() {
        final LicenceBGUTable ordersTable = new LicenceBGUTable((TableModel)this.ordersTableModel, new String[]{"count"});
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.filter, (String)"\u0424\u0438\u043b\u044c\u0442\u0440"), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.transferButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)((Object)ordersTable)), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        ordersTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && ordersTable.getSelectedRow() != -1) {
                    boolean flag = false;
                    if (((LicenseOrder)OrdersPanel.this.ordersTableModel.getSelectedRow()).getType() == LicenseOrderType.TEST) {
                        flag = true;
                    }
                    OrdersPanel.this.testOrdersJMenu.setVisible(flag);
                    OrdersPanel.this.permanentOrdersJMenu.setVisible(!flag);
                    OrdersPanel.this.getPopupMenu().show((Component)ordersTable, e.getX(), e.getY());
                }
            }
        });
        return panel;
    }

    private JPanel getNewOrderPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        BGButton deletePermanentOrderButton = new BGButton((Action)this.deletePermanentOrder);
        BGButton deleteTestOrderButton = new BGButton((Action)this.deleteTestOrder);
        BGButton copySelectedPermanentToTest = new BGButton("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0432 \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0435");
        this.saveButton.setEnabled(false);
        this.superTotalCost.setEditable(false);
        this.superTotalCost.setHorizontalAlignment(4);
        this.permanentModel = new BGTableModel<LicenseOrderPermanentNew>(""){

            protected void initColumns() {
                this.addColumn("\u2116", 30, 30, 30, "number", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", "componentName", true);
                this.addColumn("\u041a\u043e\u043b-\u0432\u043e", Integer.class, 120, 120, 120, "addCount", false, true, null);
                this.addColumn("\u041d\u0435\u043e\u0433", Boolean.class, 30, 50, 70, "unlimited", true, true, null);
                this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u0442\u0435\u043a\u0443\u0449\u0435\u0435", 120, 120, 120, "presentCount", false);
                this.addColumn("\u041d\u0430 \u0441\u0443\u043c\u043c\u0443", 100, 100, 100, "presentSum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
                this.addColumn("\u041e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b-\u0432\u043e", 120, 120, 120, "totalCount", true);
                this.addColumn("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430", 100, 100, 100, "totalSum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            }

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                OrdersPanel.this.tryCall(() -> {
                    LicenseOrderPermanentNew order = (LicenseOrderPermanentNew)this.getRows().get(rowIndex);
                    switch (columnIndex) {
                        case 2: {
                            order.setCount(((Integer)value).intValue());
                            if (order.getCount() == 0) {
                                order.setTotalCount(Integer.valueOf(0));
                            } else {
                                order.setTotalCount(Integer.valueOf(order.getPresentCount() == -1 ? order.getCount() : order.getCount() + order.getPresentCount()));
                            }
                            BigDecimal totalCost = order.getTotalCount() > -1 ? ((LicenseService)OrdersPanel.this.licenseService.get()).getCostComponent(order.getComponentName(), order.getTotalCount().intValue(), OrdersPanel.this.copyId) : BigDecimal.ZERO;
                            order.setTotalSum(totalCost.setScale(2, RoundingMode.CEILING));
                            if (order.getCount() == 0) {
                                order.setUnlimited(true);
                            }
                            OrdersPanel.this.setSuperTotalCost();
                            OrdersPanel.this.saveButton.setEnabled(true);
                            break;
                        }
                        case 3: {
                            order.setUnlimited(((Boolean)value).booleanValue());
                            order.setCount((Boolean)value != false ? 0 : 1);
                            int presentCount = order.getPresentCount() == -1 ? 0 : order.getPresentCount();
                            order.setTotalCount(Integer.valueOf(order.getCount() == 0 ? 0 : order.getCount() + presentCount));
                            BigDecimal totalCost = order.getTotalCount() > -1 ? ((LicenseService)OrdersPanel.this.licenseService.get()).getCostComponent(order.getComponentName(), order.getTotalCount().intValue(), OrdersPanel.this.copyId) : BigDecimal.ZERO;
                            order.setTotalSum(totalCost.setScale(2, RoundingMode.CEILING));
                            OrdersPanel.this.setSuperTotalCost();
                            OrdersPanel.this.permanentOrderTable.repaint();
                            OrdersPanel.this.saveButton.setEnabled(true);
                            break;
                        }
                        case 6: {
                            if ((Integer)value <= order.getPresentCount()) break;
                            order.setCount((Integer)value - order.getPresentCount());
                            order.setTotalCount((Integer)value);
                            BigDecimal totalCost = order.getTotalCount() > -1 ? ((LicenseService)OrdersPanel.this.licenseService.get()).getCostComponent(order.getComponentName(), order.getTotalCount().intValue(), OrdersPanel.this.copyId) : BigDecimal.ZERO;
                            order.setTotalSum(totalCost.setScale(2, RoundingMode.CEILING));
                            OrdersPanel.this.setSuperTotalCost();
                            OrdersPanel.this.saveButton.setEnabled(true);
                            break;
                        }
                        default: {
                            super.setValueAt(value, rowIndex, columnIndex);
                        }
                    }
                    OrdersPanel.this.permanentOrderTable.repaint();
                });
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (columnIndex == 2 && ((LicenseOrderPermanentNew)this.getRows().get(rowIndex)).isUnlimited()) {
                    return false;
                }
                if (columnIndex == 3 && ((LicenseOrderPermanentNew)this.getRows().get(rowIndex)).isComponentUnlimit()) {
                    return false;
                }
                return super.isCellEditable(rowIndex, columnIndex);
            }

            public void addRow(LicenseOrderPermanentNew item) {
                for (LicenseOrderPermanentNew permanentOrder : this.getRows()) {
                    if (permanentOrder.getComponentId() != item.getComponentId()) continue;
                    ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0443\u0436\u0435 \u0431\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d.");
                    return;
                }
                item.setNumber(this.getRowCount() + 1);
                super.addRow((Object)item);
                OrdersPanel.this.saveButton.setEnabled(true);
            }

            public Object getValue(LicenseOrderPermanentNew val, int column) throws Exception {
                switch (column) {
                    case 2: {
                        return val.getCount() == 0 ? "\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e" : Integer.valueOf(val.getCount());
                    }
                    case 4: {
                        return val.getPresentCount() == -1 ? Integer.valueOf(0) : super.getValue((Object)val, column);
                    }
                    case 6: {
                        return OrderUtils.getCount((Integer)val.getTotalCount());
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.testModel = new BGTableModel<LicenseOrderTestNew>(""){

            protected void initColumns() {
                this.addColumn("\u2116", 30, 30, 30, "number", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "componentName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u041a\u043e\u043b-\u0432\u043e", Integer.class, 120, 120, 120, "count", false, true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                this.addColumn("\u041d\u0435\u043e\u0433", Boolean.class, 30, 50, 70, "unlimited", true, true, null);
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0432 \u0434\u043d\u044f\u0445", 120, 120, 120, "term", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                this.addColumn("\u0414\u043e \u0434\u0430\u0442\u044b", 100, 100, 100, "toDate", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            }

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                LicenseOrderTestNew order = (LicenseOrderTestNew)this.getRows().get(rowIndex);
                switch (columnIndex) {
                    case 2: {
                        order.setCount(((Integer)value).intValue());
                        OrdersPanel.this.saveButton.setEnabled(true);
                        break;
                    }
                    case 3: {
                        order.setUnlimited(((Boolean)value).booleanValue());
                        order.setCount((Boolean)value != false ? 0 : 1);
                        OrdersPanel.this.saveButton.setEnabled(true);
                        break;
                    }
                    case 4: {
                        order.setTerm(((Integer)value).intValue());
                        Date date = TimeUtils.nowPlusPeriod((int)5, (int)((Integer)value));
                        order.setToDate(date);
                        OrdersPanel.this.saveButton.setEnabled(true);
                        break;
                    }
                    default: {
                        super.setValueAt(value, rowIndex, columnIndex);
                    }
                }
                OrdersPanel.this.testOrderTable.repaint();
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (columnIndex == 2 && ((LicenseOrderTestNew)this.getRows().get(rowIndex)).isUnlimited()) {
                    return false;
                }
                if (columnIndex == 3 && ((LicenseOrderTestNew)this.getRows().get(rowIndex)).isComponentUnlimit()) {
                    return false;
                }
                if (columnIndex == 4) {
                    return true;
                }
                return super.isCellEditable(rowIndex, columnIndex);
            }

            public void addRow(LicenseOrderTestNew item) {
                for (LicenseOrderTestNew testOrder : this.getRows()) {
                    if (testOrder.getComponentId() != item.getComponentId()) continue;
                    ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0443\u0436\u0435 \u0431\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d.");
                    return;
                }
                item.setNumber(this.getRowCount() + 1);
                super.addRow((Object)item);
                OrdersPanel.this.saveButton.setEnabled(true);
            }

            public Object getValue(LicenseOrderTestNew val, int column) throws Exception {
                switch (column) {
                    case 2: {
                        return val.getCount() == 0 ? "\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e" : Integer.valueOf(val.getCount());
                    }
                    case 3: {
                        if (val.getCount() == 0) {
                            val.setUnlimited(true);
                        }
                        return val.isUnlimited();
                    }
                    case 5: {
                        if (val.getToDate() == null) {
                            Date date = TimeUtils.nowPlusPeriod((int)5, (int)val.getTerm());
                            val.setToDate(date);
                        }
                        return super.getValue((Object)val, column);
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.permanentOrderTable = new LicenceBGUTable((TableModel)this.permanentModel, new String[]{"totalCount", "presentCount", "addCount"});
        this.testOrderTable = new LicenceBGUTable((TableModel)this.testModel, new String[]{"count"});
        BGTextField countDay = new BGTextField(3);
        BGCalendarButton dateTo = new BGCalendarButton();
        panel.add((Component)this.componentPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        JPanel rightPanelBottom0 = new JPanel(new GridBagLayout());
        rightPanelBottom0.add((Component)deletePermanentOrderButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 5, 0), 0, 0));
        rightPanelBottom0.add((Component)copySelectedPermanentToTest, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 20, 5, 0), 0, 0));
        rightPanelBottom0.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanelBottom0.add((Component)new JLabel("\u0418\u0442\u043e\u0433\u043e\u0432\u0430\u044f \u0441\u0443\u043c\u043c\u0430"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 5, 0), 0, 0));
        rightPanelBottom0.add((Component)this.superTotalCost, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 5, 20), 0, 0));
        JPanel rightPanelBottom1 = new JPanel(new GridBagLayout());
        JLabel selectLabel = new JLabel("\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 ");
        selectLabel.setMinimumSize(new Dimension(20, 0));
        rightPanelBottom1.add((Component)deleteTestOrderButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 15), 0, 0));
        rightPanelBottom1.add((Component)selectLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        rightPanelBottom1.add((Component)countDay, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        rightPanelBottom1.add((Component)new JLabel(" \u0434\u043d\u0435\u0439 \u0438\u043b\u0438 \u0434\u043e \u0434\u0430\u0442\u044b - "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        rightPanelBottom1.add((Component)dateTo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        rightPanelBottom1.add((Component)Box.createHorizontalBox(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanelBottom1.add((Component)this.saveButton, new GridBagConstraints(6, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.setBorder((Border)new BGTitleBorder(" \u041d\u043e\u0432\u044b\u0439 \u0437\u0430\u043a\u0430\u0437: "));
        rightPanel.add((Component)new JScrollPane((Component)this.permanentOrderTable), new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 5, 5), 0, 0));
        rightPanel.add((Component)rightPanelBottom0, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JScrollPane((Component)this.testOrderTable), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 5, 5), 0, 0));
        rightPanel.add((Component)rightPanelBottom1, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)rightPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButton backToOrders = new BGButton("\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u0441\u043f\u0438\u0441\u043a\u0443 \u0437\u0430\u043a\u0430\u0437\u043e\u0432");
        backToOrders.addActionListener(e -> {
            this.performAction("refresh");
            this.cardLayout.show((Container)((Object)this), PANEL_LIST);
        });
        this.saveButton.addActionListener(e -> this.tryCall(() -> {
            if (this.permanentOrderTable.getCellEditor() != null) {
                this.permanentOrderTable.getCellEditor().stopCellEditing();
            }
            if (this.testOrderTable.getCellEditor() != null) {
                this.testOrderTable.getCellEditor().stopCellEditing();
            }
            for (LicenseOrderTestNew order : this.testModel.getSelectedRows()) {
                int day = Utils.parseInt((String)countDay.getText(), (int)-1);
                if (day == -1) continue;
                order.setTerm(day);
                Date date = TimeUtils.nowPlusPeriod((int)5, (int)day);
                order.setToDate(date);
                this.saveButton.setEnabled(true);
            }
            this.testOrderTable.repaint();
            boolean ifMinus = false;
            for (LicenseOrderPermanentNew order : this.permanentModel.getRows()) {
                if (order.getCount() >= 0) continue;
                ifMinus = true;
                break;
            }
            for (LicenseOrderTestNew order : this.testModel.getRows()) {
                if (!ifMinus && order.getCount() >= 0) continue;
                ifMinus = true;
                break;
            }
            if (ifMinus) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u043e\u043b-\u0432\u043e \u0437\u0430\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 0");
            } else {
                for (LicenseOrderPermanentNew order : this.permanentModel.getRows()) {
                    ((LicenseService)this.licenseService.get()).orderUpdate((LicenseOrder)order);
                }
                for (LicenseOrderTestNew order : this.testModel.getRows()) {
                    ((LicenseService)this.licenseService.get()).orderUpdate((LicenseOrder)order);
                }
                this.permanentModel.setData(((LicenseService)this.licenseService.get()).getNewPermanentOrders(this.copyId));
                this.testModel.setData(((LicenseService)this.licenseService.get()).getNewTestOrders(this.copyId));
                this.performAction("refresh");
                this.saveButton.setEnabled(false);
            }
        }));
        copySelectedPermanentToTest.addActionListener(e -> {
            for (LicenseOrderPermanentNew permanent : this.permanentModel.getSelectedRows()) {
                LicenseOrderTestNew test = new LicenseOrderTestNew(permanent.getComponentId(), permanent.getComponentName(), permanent.isComponentUnlimit(), permanent.getCopyId());
                int presentCount = permanent.getPresentCount() == -1 ? 0 : permanent.getPresentCount();
                test.setCount(permanent.getCount() == 0 ? 0 : permanent.getCount() + presentCount);
                test.setTerm(10);
                this.testModel.addRow((Object)test);
            }
            this.testOrderTable.repaint();
        });
        countDay.addActionListener(e -> {
            for (LicenseOrderTestNew order : this.testModel.getSelectedRows()) {
                int day = Utils.parseInt((String)countDay.getText(), (int)-1);
                if (day == -1) continue;
                order.setTerm(day);
                Date date = TimeUtils.nowPlusPeriod((int)5, (int)day);
                order.setToDate(date);
                this.saveButton.setEnabled(true);
            }
            this.testOrderTable.repaint();
        });
        dateTo.addPropertyChangeListener("updateCalendar", e -> {
            if (dateTo.getCalendar() != null) {
                for (LicenseOrderTestNew order : this.testModel.getSelectedRows()) {
                    int day = TimeUtils.daysDelta((Calendar)new GregorianCalendar(), (Calendar)dateTo.getCalendar());
                    if (day > 0) {
                        order.setTerm(TimeUtils.daysDelta((Calendar)new GregorianCalendar(), (Calendar)dateTo.getCalendar()));
                        order.setToDate(dateTo.getCalendar().getTime());
                        countDay.setText("");
                        this.saveButton.setEnabled(true);
                        continue;
                    }
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u0437\u0430\u0434 \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u0435 \u043d\u0435\u043b\u044c\u0437\u044f!!!", "Error", 0);
                }
                this.testOrderTable.repaint();
            }
        });
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)backToOrders, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bottomPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        return panel;
    }

    private BigDecimal getOrdersCost() {
        BigDecimal sum = new BigDecimal(0);
        for (LicenseOrderPermanentNew order : this.permanentModel.getRows()) {
            sum = sum.add(order.getTotalSum().subtract(order.getPresentSum()));
        }
        return sum;
    }

    private void updateOrder(String actionCommand) throws Exception {
        String nameComponent = null;
        boolean componentUnlimit = false;
        for (LicenseComponent component : this.componentList) {
            if (!actionCommand.substring(1).equals(String.valueOf(component.getId()))) continue;
            nameComponent = component.getName();
            componentUnlimit = component.getUnlimited() == 1;
            break;
        }
        if (nameComponent != null) {
            int componentId = Utils.parseInt((String)actionCommand.substring(1));
            if (actionCommand.substring(0, 1).equals("p")) {
                Integer presentCount = ((LicenseService)this.licenseService.get()).getCountOrderedComponents(nameComponent, this.copyId);
                if (presentCount != null) {
                    if (presentCount == 0) {
                        ClientUtils.showErrorMessageDialog((String)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0443\u0436\u0435 \u0438\u043c\u0435\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - \u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e.");
                    } else {
                        BigDecimal cost = presentCount > -1 ? ((LicenseService)this.licenseService.get()).getCostComponent(nameComponent, presentCount.intValue(), this.copyId) : BigDecimal.ZERO;
                        LicenseOrderPermanentNew order = new LicenseOrderPermanentNew(componentId, nameComponent, presentCount.intValue(), cost.setScale(2, RoundingMode.CEILING), componentUnlimit, this.copyId);
                        order.setTotalSum(((LicenseService)this.licenseService.get()).getCostComponent(nameComponent, order.getTotalCount().intValue(), this.copyId));
                        this.permanentModel.addRow((Object)order);
                    }
                }
            } else {
                this.testModel.addRow((Object)new LicenseOrderTestNew(componentId, nameComponent, componentUnlimit, this.copyId));
            }
            this.setSuperTotalCost();
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            ActionListener popupMenuListener = e -> {
                JMenuItem c = (JMenuItem)e.getSource();
                int status = Integer.valueOf(c.getActionCommand());
                this.changeStatus(status, this.testOrdersJMenu.isMenuComponent(c) ? LicenseOrderType.TEST : LicenseOrderType.BUY);
                this.performAction("refresh");
            };
            JMenuItem item = new JMenuItem("\u043d\u043e\u0432\u044b\u0439");
            item.addActionListener(popupMenuListener);
            item.setActionCommand(String.valueOf(0));
            this.testOrdersJMenu.add(item);
            item = new JMenuItem("\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d");
            item.addActionListener(popupMenuListener);
            item.setActionCommand(String.valueOf(3));
            this.testOrdersJMenu.add(item);
            item = new JMenuItem("\u043e\u0442\u043a\u0430\u0437\u0430\u043d\u043e");
            item.addActionListener(popupMenuListener);
            item.setActionCommand(String.valueOf(1));
            this.testOrdersJMenu.add(item);
            item = new JMenuItem("\u043d\u043e\u0432\u044b\u0439");
            item.addActionListener(popupMenuListener);
            item.setActionCommand(String.valueOf(0));
            this.permanentOrdersJMenu.add(item);
            item = new JMenuItem("\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
            item.addActionListener(popupMenuListener);
            item.setActionCommand(String.valueOf(2));
            this.permanentOrdersJMenu.add(item);
            item = new JMenuItem("\u043e\u0442\u043a\u0430\u0437\u0430\u043d\u043e");
            item.addActionListener(popupMenuListener);
            item.setActionCommand(String.valueOf(1));
            this.permanentOrdersJMenu.add(item);
            this.testOrdersJMenu.setVisible(false);
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.testOrdersJMenu);
            this.popupMenu.add(this.permanentOrdersJMenu);
        }
        return this.popupMenu;
    }

    private void changeStatus(int status, LicenseOrderType type) {
        for (LicenseOrder order : this.ordersTableModel.getSelectedRows()) {
            if (type != LicenseOrderType.BUY && type != LicenseOrderType.TEST || order.getType() != type) continue;
            order.setStatus(status);
            this.tryCall(() -> ((LicenseService)this.licenseService.get()).orderUpdate(order));
        }
    }

    private void addActionForTransferButton() {
        this.transferButton.addActionListener(e -> {
            final BGDialog dialog = new BGDialog((ClientContext)this.getContext());
            JPanel panelDialog = new JPanel(new GridBagLayout());
            panelDialog.setMinimumSize(new Dimension(600, 800));
            final BGUComboBox comboBoxCopy = new BGUComboBox();
            final BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect(true, true, true, ((ClientContext)this.getContext()).getContractId());
            JCheckBox radioDelete = new JCheckBox("\u0421 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c \u0432\u0441\u0435\u0445 \u043d\u043e\u0432\u044b\u0445");
            JCheckBox radioCheckUnlimPermOrders = new JCheckBox("\u0411\u0435\u0437 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u044b\u0445 \u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u044b\u0445");
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            radioCheckUnlimPermOrders.setSelected(true);
            comboBoxCopy.setVisible(false);
            panelDialog.add((Component)contractSelect, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
            panelDialog.add((Component)comboBoxCopy, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 13, 15, 7), 0, 0));
            panelDialog.add((Component)radioDelete, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 15, 0), 0, 0));
            panelDialog.add((Component)radioCheckUnlimPermOrders, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
            panelDialog.add((Component)okCancel, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 15, 5), 0, 0));
            okCancel.addActionListener(e1 -> {
                try {
                    if (e1.getActionCommand().equals(BGButtonPanelOkCancel.OK.command)) {
                        int oldCopyId;
                        int oldCid = Utils.parseInt((String)contractSelect.getContracts(), (int)-1);
                        int n = oldCopyId = comboBoxCopy.getSelectedItem() != null ? ((LicenseCopy)comboBoxCopy.getSelectedItem()).getId() : -1;
                        if (oldCid > 0 && oldCopyId > 0) {
                            List orderOldList = OrderUtils.getTotalOrderList((List)((LicenseService)this.licenseService.get()).permanentOrders(oldCopyId, true), (boolean)true);
                            if (orderOldList == null) {
                                return;
                            }
                            AdditionalAgreement document = new AdditionalAgreement(0, this.copyId, 0, new Date(), 0, BigDecimal.ZERO, OrderUtils.getSpecificationList((List)orderOldList, (boolean)true));
                            if (radioDelete.isSelected()) {
                                for (LicenseOrder order : ((LicenseService)this.licenseService.get()).getOrders(this.copyId, null, "0", -1)) {
                                    ((LicenseService)this.licenseService.get()).orderDelete(order.getId());
                                }
                            }
                            HashSet<String> orderPermSet = null;
                            if (radioCheckUnlimPermOrders.isSelected()) {
                                orderPermSet = new HashSet<String>();
                                List orderList = ((LicenseService)this.licenseService.get()).getOrders(this.copyId, null, "0,2", -1);
                                for (LicenseOrder order : orderList) {
                                    if (order.getCount() != 0) continue;
                                    orderPermSet.add(order.getComponentName());
                                }
                            }
                            for (LicenseComponent component : ((LicenseService)this.licenseService.get()).getComponentItems(this.copyId, true, false)) {
                                if (!document.getSpecification().contains(component)) continue;
                                SpecificationTitle title = (SpecificationTitle)document.getSpecification().get(document.getSpecification().indexOf(component));
                                if (orderPermSet != null && title.getCount() == 0 && orderPermSet.contains(title.getName())) continue;
                                LicenseOrder order = new LicenseOrder().setCopyId(this.copyId).setComponentId(component.getId()).setCount(title.getCount()).setStatus(0).setType(LicenseOrderType.BUY);
                                ((LicenseService)this.licenseService.get()).orderUpdate(order);
                            }
                            this.performAction("refresh");
                        }
                    }
                    dialog.dispose();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            });
            contractSelect.addWindowListenerForDialog((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    int oldCid = Utils.parseInt((String)contractSelect.getContracts(), (int)-1);
                    comboBoxCopy.setVisible(oldCid > 0);
                    if (oldCid > 0) {
                        OrdersPanel.this.tryCall(() -> {
                            comboBoxCopy.setData(((LicenseService)((ClientContext)OrdersPanel.this.getContext()).getPort(LicenseService.class)).copyList(oldCid));
                            dialog.pack();
                        });
                    }
                }
            });
            dialog.add((Component)panelDialog);
            dialog.setModal(true);
            dialog.pack();
            dialog.moveWindowToCenterScreen();
            dialog.showDialog();
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.componentList = ((LicenseService)this.licenseService.get()).getComponentItems(this.copyId, false, false);
            this.filter.setComponentCombo();
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (this.newOrderPanel != null && this.newOrderPanel.isVisible()) {
                return;
            }
            if (this.newOrderPanel == null) {
                this.newOrderPanel = this.getNewOrderPanel();
                this.add(this.newOrderPanel, PANEL_NEW);
            }
            this.componentPanel.checkBox.setSelected(false);
            this.cardLayout.show((Container)((Object)this), PANEL_NEW);
            if (this.componentActionListener == null) {
                this.componentActionListener = ev -> {
                    try {
                        this.updateOrder(ev.getActionCommand());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                };
            }
            this.permanentModel.setData(((LicenseService)this.licenseService.get()).getNewPermanentOrders(this.copyId));
            this.testModel.setData(((LicenseService)this.licenseService.get()).getNewTestOrders(this.copyId));
            this.componentPanel.setData(this.componentActionListener, false);
            this.setSuperTotalCost();
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            List orderList = this.ordersTableModel.getSelectedRows();
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437\u044b \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 \u0440\u0430\u0432\u043d\u044b\u043c :  " + orderList.size(), "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) != 0) {
                return;
            }
            for (LicenseOrder order : orderList) {
                ((LicenseService)this.licenseService.get()).orderDelete(order.getId());
            }
            this.setDataOrder.perform();
        });
        this.deletePermanentOrder = new AbstractBGUPanel.DefaultAction("deletePermanentOrder", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0435"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0435 \u0437\u0430\u043a\u0430\u0437\u044b ? ", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    for (LicenseOrderPermanentNew order : OrdersPanel.this.permanentModel.getSelectedRows()) {
                        if (order.getId() > 0) {
                            ((LicenseService)OrdersPanel.this.licenseService.get()).orderDelete(order.getId());
                        }
                        OrdersPanel.this.permanentModel.deleteRow((Object)order);
                    }
                    int number = 1;
                    for (LicenseOrderPermanentNew order : OrdersPanel.this.permanentModel.getRows()) {
                        order.setNumber(number++);
                    }
                    OrdersPanel.this.setSuperTotalCost();
                }
            }
        };
        this.deleteTestOrder = new AbstractBGUPanel.DefaultAction("deleteTestOrder", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                for (LicenseOrderTestNew order : OrdersPanel.this.testModel.getSelectedRows()) {
                    if (order.getId() > 0) {
                        ((LicenseService)OrdersPanel.this.licenseService.get()).orderDelete(order.getId());
                    }
                    OrdersPanel.this.testModel.deleteRow((Object)order);
                }
                int number = 1;
                for (LicenseOrderTestNew order : OrdersPanel.this.testModel.getRows()) {
                    order.setNumber(number++);
                }
            }
        };
        this.setDataOrder = new AbstractBGUPanel.DefaultAction("setDataOrder", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List list = ((LicenseService)OrdersPanel.this.licenseService.get()).getOrders(OrdersPanel.this.copyId, OrdersPanel.this.filter.getTestFilter(), OrdersPanel.this.filter.getPermanentFilter(), OrdersPanel.this.filter.getSelectComponentFilter());
                OrdersPanel.this.ordersTableModel.setData(list);
            }
        };
    }

    private void setSuperTotalCost() {
        this.superTotalCost.setText(new DecimalFormat("###,###,###,##0.00").format(this.getOrdersCost().setScale(2, RoundingMode.CEILING)));
    }

    class FilterPanel
    extends JPanel {
        JCheckBox permanentNewJCheckBox = new JCheckBox("\u041d\u043e\u0432\u044b\u0435");
        JCheckBox permanentCompletedJCheckBox = new JCheckBox("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u0435");
        JCheckBox permanentRefusedJCheckBox = new JCheckBox("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435");
        JCheckBox testNewJCheckBox = new JCheckBox("\u041d\u043e\u0432\u044b\u0435");
        JCheckBox testConfirmedJCheckBox = new JCheckBox("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0435");
        JCheckBox testRefusedJCheckBox = new JCheckBox("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435");
        JButton resetJButton = new JButton("\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c");
        JButton selectAllJButton = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435");
        BGComboBox<ComboBoxItem> componentComboBox = new BGComboBox();

        FilterPanel() {
            JPanel permanentJPanel = new JPanel(new GridBagLayout());
            permanentJPanel.add((Component)this.permanentNewJCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            permanentJPanel.add((Component)this.permanentCompletedJCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            permanentJPanel.add((Component)this.permanentRefusedJCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel testJPanel = new JPanel(new GridBagLayout());
            testJPanel.add((Component)this.testNewJCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            testJPanel.add((Component)this.testConfirmedJCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            testJPanel.add((Component)this.testRefusedJCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)BGSwingUtilites.wrapBorder((JPanel)permanentJPanel, (String)"\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder((JPanel)testJPanel, (String)"\u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0435"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder(this.componentComboBox, (String)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b"), new GridBagConstraints(2, 0, 1, 1, 0.2, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            JPanel buttonJPanel = new JPanel(new GridBagLayout());
            buttonJPanel.add((Component)this.resetJButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            buttonJPanel.add((Component)this.selectAllJButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)buttonJPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 2, 0), 0, 0));
            List permanent = Utils.toList((String)ClientSetup.getInstance().getUserConfig().get("ru.bitel.bgbilling.modules.license.client.OrdersPanel.FilterPanel.permanent", "1,1,0"));
            List test = Utils.toList((String)ClientSetup.getInstance().getUserConfig().get("ru.bitel.bgbilling.modules.license.client.OrdersPanel.FilterPanel.test", "1,1,0"));
            this.permanentNewJCheckBox.setSelected(Utils.parseBoolean((String)((String)permanent.get(0)), (boolean)true));
            this.permanentCompletedJCheckBox.setSelected(Utils.parseBoolean((String)((String)permanent.get(1)), (boolean)true));
            this.permanentRefusedJCheckBox.setSelected(Utils.parseBoolean((String)((String)permanent.get(2)), (boolean)false));
            this.testNewJCheckBox.setSelected(Utils.parseBoolean((String)((String)test.get(0)), (boolean)true));
            this.testConfirmedJCheckBox.setSelected(Utils.parseBoolean((String)((String)test.get(1)), (boolean)true));
            this.testRefusedJCheckBox.setSelected(Utils.parseBoolean((String)((String)test.get(2)), (boolean)false));
            this.resetJButton.addActionListener(e -> {
                this.permanentNewJCheckBox.setSelected(false);
                this.permanentCompletedJCheckBox.setSelected(false);
                this.permanentRefusedJCheckBox.setSelected(false);
                this.testNewJCheckBox.setSelected(false);
                this.testConfirmedJCheckBox.setSelected(false);
                this.testRefusedJCheckBox.setSelected(false);
            });
            this.selectAllJButton.addActionListener(e -> {
                this.permanentNewJCheckBox.setSelected(true);
                this.permanentCompletedJCheckBox.setSelected(true);
                this.permanentRefusedJCheckBox.setSelected(true);
                this.testNewJCheckBox.setSelected(true);
                this.testConfirmedJCheckBox.setSelected(true);
                this.testRefusedJCheckBox.setSelected(true);
            });
            ChangeListener checkBoxChangeListener = e -> this.setDataFilter();
            this.permanentNewJCheckBox.addChangeListener(checkBoxChangeListener);
            this.permanentCompletedJCheckBox.addChangeListener(checkBoxChangeListener);
            this.permanentRefusedJCheckBox.addChangeListener(checkBoxChangeListener);
            this.testNewJCheckBox.addChangeListener(checkBoxChangeListener);
            this.testConfirmedJCheckBox.addChangeListener(checkBoxChangeListener);
            this.testRefusedJCheckBox.addChangeListener(checkBoxChangeListener);
            this.componentComboBox.addActionListener(e -> this.setDataFilter());
        }

        private void setDataFilter() {
            String permanent = new String((this.permanentNewJCheckBox.isSelected() ? "1," : "0,") + (this.permanentCompletedJCheckBox.isSelected() ? "1," : "0,") + (this.permanentRefusedJCheckBox.isSelected() ? "1" : "0"));
            String test = new String((this.testNewJCheckBox.isSelected() ? "1," : "0,") + (this.testConfirmedJCheckBox.isSelected() ? "1," : "0,") + (this.testRefusedJCheckBox.isSelected() ? "1" : "0"));
            ClientSetup.getInstance().getUserConfig().set("ru.bitel.bgbilling.modules.license.client.OrdersPanel.FilterPanel.permanent", permanent);
            ClientSetup.getInstance().getUserConfig().set("ru.bitel.bgbilling.modules.license.client.OrdersPanel.FilterPanel.test", test);
            OrdersPanel.this.setDataOrder.perform();
        }

        public String getPermanentFilter() {
            StringBuilder result = new StringBuilder();
            boolean flag = false;
            if (this.permanentNewJCheckBox.isSelected()) {
                result.append("0,");
                flag = true;
            }
            if (this.permanentRefusedJCheckBox.isSelected()) {
                result.append("1,");
                flag = true;
            }
            if (this.permanentCompletedJCheckBox.isSelected()) {
                result.append("2");
                flag = true;
            }
            if (flag && result.charAt(result.length() - 1) == ',') {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }

        public String getTestFilter() {
            StringBuilder result = new StringBuilder();
            boolean flag = false;
            if (this.testNewJCheckBox.isSelected()) {
                result.append("0,");
                flag = true;
            }
            if (this.testRefusedJCheckBox.isSelected()) {
                result.append("1,");
                flag = true;
            }
            if (this.testConfirmedJCheckBox.isSelected()) {
                result.append("3");
                flag = true;
            }
            if (flag && result.charAt(result.length() - 1) == ',') {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }

        public int getSelectComponentFilter() {
            int id = Utils.parseInt((String)this.componentComboBox.getSelectedId(), (int)-1);
            return id;
        }

        private void setComponentCombo() {
            this.componentComboBox.removeAllItems();
            for (LicenseComponent component : OrdersPanel.this.componentList) {
                this.componentComboBox.addItem((Object)new ComboBoxItem(component.getId(), component.getTitle()));
            }
            this.componentComboBox.addItem((Object)new ComboBoxItem(-1, "\u0412\u0441\u0435"));
            this.componentComboBox.setSelectedId("-1");
        }
    }

    class ComponentPanel
    extends JPanel {
        private JPanel panel = new JPanel(new GridBagLayout());
        JCheckBox checkBox = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u043a\u0440\u044b\u0442\u044b\u0435", false);
        MouseListener mouseListener;

        ComponentPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder((Border)new BGTitleBorder("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b:"));
            Dimension dimension = this.getPreferredSize();
            dimension.width = 350;
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.add((Component)new JScrollPane(this.panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.checkBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.mouseListener = new MouseAdapter(this){
                String text;

                @Override
                public void mouseExited(MouseEvent e) {
                    JButton button = (JButton)e.getComponent();
                    button.setText(this.text);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    JButton button = (JButton)e.getComponent();
                    this.text = button.getText();
                    button.setText("<html><font color=\"#0000FF\"><b>" + this.text + "</b></font>");
                }
            };
            this.checkBox.addActionListener(e -> this.setData(OrdersPanel.this.componentActionListener, this.checkBox.isSelected()));
        }

        public void setData(ActionListener actionListener, boolean isShowHidden) {
            this.panel.removeAll();
            this.panel.setBackground(Color.WHITE);
            int index = 0;
            OrdersPanel.this.tryCall(() -> {
                OrdersPanel.this.componentList = ((LicenseService)OrdersPanel.this.licenseService.get()).getComponentItems(OrdersPanel.this.copyId, isShowHidden, false);
            });
            for (LicenseComponent component : OrdersPanel.this.componentList) {
                BGButton buttonP = new BGButton("+ \u041f");
                buttonP.addMouseListener(this.mouseListener);
                buttonP.setMargin(new Insets(0, 0, 0, 0));
                buttonP.setBackground(Color.WHITE);
                buttonP.setFocusPainted(false);
                buttonP.setContentAreaFilled(false);
                buttonP.setBorderPainted(false);
                buttonP.setCursor(Cursor.getPredefinedCursor(12));
                buttonP.addActionListener(actionListener);
                buttonP.setActionCommand("p" + component.getId());
                BGButton buttonT = new BGButton("+ \u0422");
                buttonT.addMouseListener(this.mouseListener);
                buttonT.setMargin(new Insets(0, 0, 0, 0));
                buttonT.setBackground(Color.WHITE);
                buttonT.setBorderPainted(false);
                buttonT.setFocusPainted(false);
                buttonT.setContentAreaFilled(false);
                buttonT.setCursor(Cursor.getPredefinedCursor(12));
                buttonT.addActionListener(actionListener);
                buttonT.setActionCommand("t" + component.getId());
                this.panel.add((Component)new JLabel(component.getTitle()), new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
                this.panel.add((Component)buttonP, new GridBagConstraints(1, index, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
                this.panel.add((Component)buttonT, new GridBagConstraints(2, index, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
                ++index;
            }
            this.panel.add(Box.createGlue(), new GridBagConstraints(0, index, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.updateUI();
        }
    }
}

