/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.common.Utils;

public class LongInfo
extends RadiusAttributeInfo<Long> {
    public LongInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 3, attr, children);
    }

    protected LongInfo(int vendor, int code, String name, int valueType, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, valueType, attr, children);
    }

    @Override
    public Long unwrapValue(ByteBuffer data) {
        byte[] bytes = new byte[8];
        data.get(bytes);
        data.position(0);
        if (this.tag == 1) {
            return Utils.bytesToLong((byte[])bytes, (int)1, (int)7);
        }
        return Utils.bytesToLong((byte[])bytes, (int)0, (int)8);
    }

    @Override
    public ByteBuffer wrapValue(Long _value) {
        byte[] bytes = Utils.convertLongToBytes((long)_value);
        if (this.tag == 1) {
            ByteBuffer bb = ByteBuffer.allocate(7);
            bb.put(bytes, 1, 7);
            bb.rewind();
            return bb;
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(bytes, 0, 8);
        bb.rewind();
        return bb;
    }
}

