/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ReserveTypesEditor
extends BGPanel {
    protected ReserveTypeTableModel model = new ReserveTypeTableModel();

    public ReserveTypesEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.model);
        table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(table, e -> this.editItem());
    }

    protected void refresh() throws Exception {
        this.model.setData(this.getContext().getPort(ReserveService.class).reserveTypeList(false));
    }

    @Override
    public void setData() {
        try {
            this.model.setData(this.getContext().getDirectory(ReserveType.class).list());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void newItem() {
        new Editor("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u043e\u0432 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432", new ReserveType()).open();
    }

    @Override
    public void editItem() {
        this.model.optSelectedRow().ifPresentOrElse(reserveType -> new Editor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u043e\u0432 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432", (ReserveType)reserveType).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
    }

    @Override
    public void deleteItem() {
        if (this.model.getSelectedRow() != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0440\u0435\u0437\u0435\u0440\u0432\u0430 ?", "", 0, 3) == 0) {
            try {
                this.getContext().getDirectory(ReserveType.class).delete(((ReserveType)this.model.getSelectedRow()).getId());
                this.refresh();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    class ReserveTypeTableModel
    extends BGTableModel<ReserveType> {
        public ReserveTypeTableModel() {
            super(ReserveTypeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", 100, 100, 100, "used", true);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class Editor
    extends BGEditorDialog<ReserveType> {
        protected BGTextField textFieldName;
        protected JCheckBox checkBoxUsed;

        public Editor(String title, ReserveType data) {
            super(title, data);
            this.textFieldName = new BGTextField(30);
            this.checkBoxUsed = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.textFieldName, new GridBagConstraints(0, -1, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.checkBoxUsed, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.textFieldName.setText(((ReserveType)this.data).getTitle());
            this.checkBoxUsed.setSelected(((ReserveType)this.data).isUsed());
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.textFieldName.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            ((ReserveType)this.data).setTitle(this.textFieldName.getText());
            ((ReserveType)this.data).setUsed(this.checkBoxUsed.isSelected());
            ReserveTypesEditor.this.getContext().getDirectory(ReserveType.class).update((ReserveType)this.data);
            ReserveTypesEditor.this.setData();
            return true;
        }
    }
}

