/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.common.inet.IpNet;

public class Ipv6PrefixInfo
extends RadiusAttributeInfo<IpNet> {
    public Ipv6PrefixInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 21, attr, children);
    }

    public Ipv6PrefixInfo(int vendor, int code, String name, int tag, int paramTypeSize, int paramLengthSize, boolean continuation, boolean addAvpName, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 21, tag, paramTypeSize, paramLengthSize, continuation, addAvpName, children);
    }

    @Override
    public IpNet unwrapValue(ByteBuffer bb) {
        bb.get();
        int mask = bb.get() & 0xFF;
        byte[] subnet = new byte[16];
        bb.get(subnet, 0, mask / 8);
        bb.rewind();
        return new IpNet(subnet, mask);
    }

    @Override
    public ByteBuffer wrapValue(IpNet value) {
        int mask = value.getMask();
        int lenght = mask / 8;
        byte[] result = new byte[lenght + 2];
        result[1] = (byte)(value.getMask() & 0xFF);
        System.arraycopy(value.getSubnet(), 0, result, 2, lenght);
        return ByteBuffer.wrap(result);
    }

    @Override
    public String valueToString(Tlv<?, IpNet> attribute) {
        return String.valueOf(attribute.getValue());
    }
}

