<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'WM'">Список платежей WebMoney</xsl:when>
	<xsl:when test="data/@action = 'WMPay'">Пополнение счета через WebMoney</xsl:when>
	<xsl:when test="data/@action = 'WMResult'">
		<xsl:choose>
			<xsl:when test="data/pay/@result > 0">Платеж WebMoney успешно проведен</xsl:when>
			<xsl:otherwise>Ошибка проведения платежа WebMoney</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@action = 'WM'">
		<xsl:call-template name="WM"/>
	</xsl:when>
	<xsl:when test="@action = 'WMPay'">
		<xsl:choose>
		<xsl:when test="pay/@cid > 0">
		<xsl:call-template name="WMPayConfirm"/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:call-template name="WMPay"/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
	<xsl:when test="@action = 'WMResult'">
		<xsl:choose>
		<xsl:when test="pay/@result > 0">
		<xsl:call-template name="WMResultOK"/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:call-template name="WMResultFail"/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template name="WM">

	<table class="table800">
		<thead>
		  <tr>
			<td>Номер</td>
			<td>Дата/время оплаты</td>
			<td>Кошелек</td>
			<td>WM-ID</td>
			<td>Сумма</td>
		  </tr>
		</thead>
		<tbody>
		  <xsl:for-each select="wm/payment">
			<tr>
				<td nowrap="nowrap"><xsl:value-of select="@number"/></td>
				<td><xsl:value-of select="@trans_time"/></td>
				<td><xsl:value-of select="@payer_purse"/></td>
				<td><xsl:value-of select="@payer_wm"/></td>
				<td nowrap="nowrap"><xsl:value-of select="@summ"/></td>
			</tr>		
		  </xsl:for-each>
		  <xsl:if test="count(wm/payment) = 0">
		  	<tr><td colspan="5"><i>Платежи не найдены</i></td></tr>
		  </xsl:if>
		</tbody>
	</table>

	<div style="margin: 5px 0px">	
	<!-- 
	<xsl:call-template name="formButton">
		<xsl:with-param name="data">
			<xsl:call-template name="module"/>
			<input type="hidden" name="action" value="WMPay" />
		</xsl:with-param>
		<xsl:with-param name="title">Пополнить счет</xsl:with-param>
	</xsl:call-template>
	 -->
	</div>

</xsl:template>


<xsl:template name="WMPay">
<form method="post" action="{$WEBEXECUTER}">
	<xsl:call-template name="action"/>
	
<div class="report">
<table cellspacing="1" style="width: 400px;"><!-- TODO проверить -->
<col style="width: 100%;"/><!-- TODO проверить -->
<col align="center"/>
<thead>
	<tr>
		<td colspan="2">Новый платеж</td>
	</tr>
</thead>
<tbody>
	<tr>
		<td nowrap="nowrap">Текущий баланс</td>
		<td><xsl:value-of select="balance/@balance"/></td>
	</tr>	
	<tr>
		<td nowrap="nowrap">Введите сумму для оплаты</td>
		<td><input type="text" name="summ" size="13"></input></td>
	</tr>
</tbody>
<tfoot>
	<tr>
		<td colspan="2">
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Далее'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=WM&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
			</xsl:call-template>
		</td>
	</tr>
</tfoot>
</table>
</div>
</form>
</xsl:template>

<xsl:template name="WMPayConfirm">
<form method="post" action="https://merchant.webmoney.ru/lmi/payment.asp">
<xsl:call-template name="module"/>
<input type="hidden" name="action" value="WMResult" />
<input type="hidden" name="cid"><xsl:attribute name="value"><xsl:value-of select="pay/@cid"/></xsl:attribute></input>
<input type="hidden" name="LMI_PAYEE_PURSE"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_PAYEE_PURSE"/></xsl:attribute></input>
<input type="hidden" name="LMI_PAYMENT_AMOUNT"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_PAYMENT_AMOUNT"/></xsl:attribute></input>
<input type="hidden" name="LMI_PAYMENT_NO"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_PAYMENT_NO"/></xsl:attribute></input>
<input type="hidden" name="LMI_PAYMENT_DESC"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_PAYMENT_DESC"/></xsl:attribute></input>
<input type="hidden" name="LMI_RESULT_URL"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_RESULT_URL"/></xsl:attribute></input>
<input type="hidden" name="LMI_SUCCESS_URL"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_SUCCESS_URL"/></xsl:attribute></input>
<input type="hidden" name="LMI_SUCCESS_METHOD"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_SUCCESS_METHOD"/></xsl:attribute></input>
<input type="hidden" name="LMI_FAIL_URL"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_FAIL_URL"/></xsl:attribute></input>
<input type="hidden" name="LMI_FAIL_METHOD"><xsl:attribute name="value"><xsl:value-of select="pay/@LMI_FAIL_URL"/></xsl:attribute></input>


<div class="report">
<table cellspacing="1" style="width: 400px;"><!-- TODO проверить -->
<thead>
	<tr>
		<td>Новый платеж</td>
	</tr>
</thead>
<tbody>
	<tr>
		<td>Нажмите "Далее" для перехода к системе WebMoney Transfer и продолжения проведения оплаты.</td>
	</tr>
</tbody>
<tfoot>
	<tr>
		<td>
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Далее'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=WM&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
			</xsl:call-template>
		</td>
	</tr>
</tfoot>
</table>
</div>
</form>
</xsl:template>

<xsl:template name="WMResultOK">
<form method="post" action="{$WEBEXECUTER}">
<xsl:call-template name="module"/>
<input type="hidden" name="action" value="WM" />

<div class="report">
<table cellspacing="1" id="idTableWMResultOK">
<col class="col1" />
<col class="col2" align="right" />
<thead>
	<tr>
		<td colspan="2">Платеж № <xsl:value-of select="pay/@LMI_PAYMENT_NO"/> успешно проведен</td>
	</tr>
</thead>
<tbody>
	<tr>
		<td align="left" width="300">Поступившая сумма:</td><td align="right"><xsl:value-of select="pay/@LMI_PAYMENT_AMOUNT"/></td>
	</tr>
	<tr>
		<td align="left">Время транзакции:</td><td align="right"><xsl:value-of select="pay/@TRANS_DATE"/></td>
	</tr>
	<tr>
		<td align="left">Ваш текущий баланс:</td><td align="right"><xsl:value-of select="balance/@balance"/></td>
	</tr>
</tbody>
<tfoot>
	<tr>
		<td colspan="2">
			<div>
			<xsl:call-template name="submit">
				<xsl:with-param name="title" select="'Назад'"/>
			</xsl:call-template>
			</div>
		</td>
	</tr>
</tfoot>
</table>
</div>
</form>
</xsl:template>

<xsl:template name="WMResultFail">
<form method="post" action="{$WEBEXECUTER}">
<xsl:call-template name="module"/>
<input type="hidden" name="action" value="WM" />

<div class="report">
<table cellspacing="1" id="idTableWMResultFail">
<thead>
  <tr>
	<td align="left">Платеж № <xsl:value-of select="pay/@LMI_PAYMENT_NO"/> не проведен</td>
  </tr>
</thead>
<tfoot>
	<tr>
		<td>
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Назад'"/>
				<xsl:with-param name="title2" select="'Новый платеж'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=WMPay&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
			</xsl:call-template>
		</td>
	</tr>
</tfoot>	
</table>
</div>
</form>
</xsl:template>

</xsl:stylesheet>