/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.traffic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public class Traffic {
    public static final int FROM_RADIUS_IN = 1;
    public static final int FROM_RADIUS_OUT = 2;
    public static final int FROM_COLLECTOR = 3;
    public static final int FROM_MAX_FUNCTION = 5;
    public static final int FROM_SUM_FUNCTION = 6;
    public static final int FROM_RADIUS = 7;
    private int serviceId = -1;
    private int trafficSource = -1;
    private int paramSID_1 = -1;
    private int paramSID_2 = -1;
    private int paramSID_3 = -1;
    private int paramSID_4 = -1;
    private int radiusVendorCode = 0;
    private int radiusAttrCode = 0;
    private String radiusAttrPrefix = "";
    private static final Pattern maxPattern = Pattern.compile("MAX\\s*\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)");
    private static final Pattern sumPattern = Pattern.compile("SUM\\s*\\(\\s*([\\d,]+)\\s*\\)\\s*");
    private static final Pattern radPattern = Pattern.compile("RAD\\s*\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,*\\s*([\\w]*)\\)\\s*");

    public int getServiceId() {
        return this.serviceId;
    }

    @Deprecated
    public int getServiceID() {
        return this.serviceId;
    }

    public int getTrafficSource() {
        return this.trafficSource;
    }

    public int getParamSID_2() {
        return this.paramSID_2;
    }

    public int getParamSID_1() {
        return this.paramSID_1;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    @Deprecated
    public void setServiceID(int serviceId) {
        this.serviceId = serviceId;
    }

    public void setTrafficSource(int trafficSource) {
        this.trafficSource = trafficSource;
    }

    public int getParamSID_3() {
        return this.paramSID_3;
    }

    public int getParamSID_4() {
        return this.paramSID_4;
    }

    public int getRadiusVendorCode() {
        return this.radiusVendorCode;
    }

    public int getRadiusAttrCode() {
        return this.radiusAttrCode;
    }

    public String getRadiusAttrPrefix() {
        return this.radiusAttrPrefix;
    }

    public void setTrafficSourceFromString(String value) {
        Matcher m;
        if (value.equals("RADIN")) {
            this.trafficSource = 1;
        } else if (value.equals("RADOUT")) {
            this.trafficSource = 2;
        } else if (value.equals("COLLECTOR")) {
            this.trafficSource = 3;
        } else if (value.startsWith("MAX")) {
            Matcher m2 = maxPattern.matcher(value);
            if (m2.find()) {
                this.trafficSource = 5;
                this.paramSID_1 = Utils.parseInt((String)m2.group(1), (int)-1);
                this.paramSID_2 = Utils.parseInt((String)m2.group(2), (int)-1);
            }
        } else if (value.startsWith("SUM")) {
            Matcher m3 = sumPattern.matcher(value);
            if (m3.find()) {
                this.trafficSource = 6;
                String[] sids = m3.group(1).split("\\s*,\\s*");
                if (sids.length > 0) {
                    this.paramSID_1 = Utils.parseInt((String)sids[0]);
                }
                if (sids.length > 1) {
                    this.paramSID_2 = Utils.parseInt((String)sids[1]);
                }
                if (sids.length > 2) {
                    this.paramSID_3 = Utils.parseInt((String)sids[2]);
                }
                if (sids.length > 3) {
                    this.paramSID_4 = Utils.parseInt((String)sids[3]);
                }
            }
        } else if (value.startsWith("RAD") && (m = radPattern.matcher(value)).find()) {
            this.radiusVendorCode = Utils.parseInt((String)m.group(1).trim());
            this.radiusAttrCode = Utils.parseInt((String)m.group(2).trim());
            this.radiusAttrPrefix = m.group(3).trim();
            if (this.radiusVendorCode > 0 && this.radiusAttrCode > 0) {
                this.trafficSource = 7;
            }
        }
    }
}

