/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.accounting.ProductPeriodRuntimeQueue;
import ru.bitel.bgbilling.apps.tv.accounting.ProductPeriodWorker;
import ru.bitel.bgbilling.apps.tv.accounting.worker.AccountingWorkerSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.ProlongationType;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvAccountDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.accounting.TvAccountNeedProlongateEvent;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountStateAndOptionsDatabaseWorker;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvApplication;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.WorkerTask;

public class TvAccounting
extends TvApplication
implements Lifecycle,
EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final ProductPeriodRuntimeQueue productPeriodQueue;
    int c = 1;
    private final AccountingWorkerSet accountingWorkerSet;
    private ProductPeriodWorker productPeriodWorker;

    @ConstructorProperties(value={"setup"})
    public TvAccounting(Setup setup) throws Exception {
        super(true, setup, SetupParam.getApplicationId((ParameterMap)setup), SetupParam.getModuleId((ParameterMap)setup), false);
        this.productPeriodQueue = new ProductPeriodRuntimeQueue(setup, this.moduleId, this.scheduledExecutorService);
        EventProcessor.getInstance().addListener((EventListener)this, TvAccountNeedProlongateEvent.class, this.moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)this, TvAccountDeviceStateAndOptionsModifiedEvent.class, this.moduleId, null);
        this.accountingWorkerSet = new AccountingWorkerSet(this);
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.accountingWorkerSet.start();
        this.productPeriodWorker = new ProductPeriodWorker(this, this.productPeriodQueue);
        new TvAccountStateAndOptionsDatabaseWorker(this);
    }

    @Override
    public void stop() throws Exception {
        if (this.productPeriodWorker != null) {
            this.productPeriodWorker.shutdown();
        }
        this.accountingWorkerSet.stop();
        super.stop();
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof TvAccountDeviceStateAndOptionsModifiedEvent) {
            TvAccountDeviceStateAndOptionsModifiedEvent event = (TvAccountDeviceStateAndOptionsModifiedEvent)e;
            if (event.getDeviceState() != 1) {
                return;
            }
            this.prolongate(event.getTvAccountId(), 3L);
        } else if (e instanceof TvAccountNeedProlongateEvent) {
            TvAccountNeedProlongateEvent event = (TvAccountNeedProlongateEvent)e;
            this.prolongate(event.getTvAccountId(), 1L);
        }
    }

    private void prolongate(final int tvAccountId, long pause) {
        this.scheduledExecutorService.schedule((Runnable)new WorkerTask<ServerContext>(){

            protected void runImpl() {
                try {
                    TvAccountService tvAccountService = (TvAccountService)((ServerContext)this.context).getService(TvAccountService.class, TvAccounting.this.moduleId);
                    TvAccount tvAccount = tvAccountService.tvAccountGet(0, tvAccountId);
                    if (tvAccount != null && tvAccount.getParentId() <= 0) {
                        int contractId = tvAccount.getContractId();
                        ContractRuntime contractRuntime = TvAccounting.this.contractRuntimeMap.getContractRuntime(((ServerContext)this.context).getConnectionSet(), Integer.valueOf(contractId));
                        ConvergenceBalance convergenceBalance = TvAccounting.this.convergenceBalanceManager.getBalance(((ServerContext)this.context).getConnectionSet(), Integer.valueOf(contractId), System.currentTimeMillis());
                        ProductManager productManager = new ProductManager((ServerContext)this.context, TvAccounting.this.moduleId);
                        Date time = new Date();
                        productManager.productsProlongate(((ServerContext)this.context).getConnectionSet(), contractRuntime, contractRuntime.contractId, convergenceBalance.getBalance(), convergenceBalance.getLimit(), time, ProlongationType.payment);
                        productManager.close();
                    }
                }
                catch (Throwable ex) {
                    logger.error(ex.getMessage(), ex);
                }
            }
        }, pause, TimeUnit.SECONDS);
    }
}

