/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.generator.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.bgbilling.kernel.generator.common.bean.enums.BGGeneratorType;

public class BGGeneratorDao
extends AbstractIdDao<BGGenerator> {
    public BGGeneratorDao(Connection con) {
        super(con, 0, "counter_generator");
    }

    public List<BGGenerator> list(BGGeneratorType generatorType) throws SQLException {
        return this.list("generator_type=?", "title", generatorType.name());
    }

    @Override
    protected BGGenerator getFromRS(ResultSet rs) throws SQLException {
        return new BGGenerator(rs.getInt("id"), rs.getString("title")).setPattern(rs.getString("pattern")).setSequenceId(rs.getInt("sequence_id")).setGeneratorType(BGGeneratorType.valueOf(rs.getString("generator_type")));
    }

    @Override
    protected void updateImpl(BGGenerator generator) throws SQLException {
        String querySet = "title=?, pattern=?, sequence_id=?, generator_type=?";
        try (PreparedStatement ps = this.prepareStatement(generator, querySet);){
            int index = 1;
            ps.setString(index++, generator.getTitle());
            ps.setString(index++, generator.getPattern());
            ps.setInt(index++, generator.getSequenceId());
            ps.setString(index++, generator.getGeneratorType().name());
            this.executeUpdate(generator, index, ps);
        }
    }
}

