/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelMonth;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.voiceip.client.directory.DestinationsDirectory;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class VoipServiceConfigRecalculate
extends ServiceConfigTabbedPanel {
    private boolean _filterInit = false;
    private BGControlPanelMonthAndDays period_P = new BGControlPanelMonthAndDays();
    private JComboBox<ComboBoxItem> callType_CB = new JComboBox();
    private BGComboBox<IdTitle> dest_CB = new BGComboBox();
    private BGTextField protoEmail_TF = new BGTextField();
    private BGControlPanelListSelect groups = new BGControlPanelListSelect();
    private BGTextField setBalanceMail = new BGTextField();
    private BGUComboBox<IdTitle> onlyOperatorCost = new BGUComboBox();
    private static final String RECALCULATE_SESSIONS_EMAIL_KEY = "voip.recalculate.sessions";
    private static final String SET_BALANCE_EMAIL_KEY = "voip.set.balance";

    public VoipServiceConfigRecalculate() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel periodAndFilterPanel = new JPanel(new GridBagLayout());
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        JPanel runRecalcPanel = new JPanel(new GridBagLayout());
        runRecalcPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0443\u0441\u043a "));
        JButton runRecalcButton = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
        runRecalcButton.addActionListener(e -> {
            this.saveUserEmail(RECALCULATE_SESSIONS_EMAIL_KEY, this.protoEmail_TF.getText().trim());
            this.sendRecalculateRequest();
        });
        this.period_P.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.groups.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        this.dest_CB.setActionCommand("comboBoxChanged");
        periodAndFilterPanel.add((Component)this.period_P, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        periodAndFilterPanel.add((Component)filterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ArrayList<IdTitle> data = new ArrayList<IdTitle>();
        data.add(new IdTitle(0, "\u0432\u0441\u0451"));
        data.add(new IdTitle(1, "\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430"));
        this.onlyOperatorCost.setData(data);
        filterPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        filterPanel.add(this.callType_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        filterPanel.add((Component)this.dest_CB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0438\u0442\u0430\u0442\u044c:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.onlyOperatorCost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        runRecalcPanel.add((Component)new JLabel("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        runRecalcPanel.add((Component)this.protoEmail_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        runRecalcPanel.add((Component)runRecalcButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel recalcPanel = new JPanel(new GridBagLayout());
        recalcPanel.add((Component)periodAndFilterPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        recalcPanel.add(Box.createGlue(), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        recalcPanel.add((Component)this.groups, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        recalcPanel.add((Component)runRecalcPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel setBalancePanel = new JPanel(new GridBagLayout());
        BGControlPanelMonth month = new BGControlPanelMonth();
        setBalancePanel.add((Component)month, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        setBalancePanel.add((Component)new JLabel("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        setBalancePanel.add((Component)this.setBalanceMail, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        JButton setButton = new JButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441");
        setBalancePanel.add((Component)setButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 5, 5), 0, 0));
        setButton.addActionListener(e -> {
            this.saveUserEmail(SET_BALANCE_EMAIL_KEY, this.setBalanceMail.getText().trim());
            this.setBalance(month, this.setBalanceMail);
        });
        setBalancePanel.setBorder((Border)new BGTitleBorder(" \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 "));
        recalcPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442 \u0437\u0432\u043e\u043d\u043a\u043e\u0432 "));
        this.add(recalcPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(setBalancePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setBalance(BGControlPanelMonth month, BGTextField mailField) {
        String email = mailField.getText();
        if (email.length() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a!");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("SetBalance");
        request.setModuleId(this.getModuleId());
        request.setAttribute("date", month.getDateString());
        request.setAttribute("mail", email);
        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430, \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \n\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 EMail", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430", 1);
        }
    }

    public void setData() {
        this.initFilterPanel();
        this.protoEmail_TF.setText(this.getUserEmail(RECALCULATE_SESSIONS_EMAIL_KEY));
        this.setBalanceMail.setText(this.getUserEmail(SET_BALANCE_EMAIL_KEY));
    }

    private void initFilterPanel() {
        if (!this._filterInit) {
            this._filterInit = true;
            this.callType_CB.addItem(new ComboBoxItem((Object)"0", "-----"));
            this.callType_CB.addItem(new ComboBoxItem((Object)"1", "\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435"));
            this.callType_CB.addItem(new ComboBoxItem((Object)"2", "\u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435"));
            this.dest_CB.addItem((Object)IdTitle.NO_SELECT);
            this.dest_CB.addItem((Object)new IdTitle(1, "- \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e -"));
            try {
                DestinationsDirectory destDir = new DestinationsDirectory();
                destDir.init(this.getModuleId());
                for (IdTitle di : destDir.getItems()) {
                    this.dest_CB.addItem((Object)di);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ListGroups");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildList((JList)this.groups.getList(), (DefaultListModel)this.groups.getListModel(), (Node)XMLUtils.getElement((Document)doc, (String)"groups"));
            }
        }
    }

    private void sendRecalculateRequest() {
        Request request = new Request();
        request.setModule("voiceip");
        request.setModuleId(this.getModuleId());
        request.setAction("RecalculateSessions");
        request.setAttribute("onlyOperatorCost", ((IdTitle)this.onlyOperatorCost.getSelectedItem()).getId());
        int callType = this.callType_CB.getSelectedIndex();
        request.setAttribute("callType", String.valueOf(callType));
        int destCode = -1;
        int pos = this.dest_CB.getSelectedIndex();
        if (pos > 0) {
            destCode = pos == 1 ? 0 : ((IdTitle)this.dest_CB.getItemAt(pos)).getId();
        }
        request.setAttribute("destCode", String.valueOf(destCode));
        request.setAttribute("date1", this.period_P.getDateString1());
        request.setAttribute("date2", this.period_P.getDateString2());
        request.setAttribute("groups", this.groups.getValue());
        String email = this.protoEmail_TF.getText();
        request.setAttribute("mail", email);
        if (email.length() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a!");
        } else {
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d, \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \n\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 EMail", "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d", 1);
            }
        }
    }
}

