/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.ChannelMapping;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ChannelMappingManager {
    private Connection con;
    private int mid;

    public ChannelMappingManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void updateMapping(ChannelMapping mapping) throws BGException {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (mapping.getId() <= 0) {
                query = "INSERT INTO channel_mapping_" + this.mid + " (chid, date1, date2, chcode, comment, scode) VALUES (?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE channel_mapping_" + this.mid + " SET chid=?, date1=?, date2=?, chcode=?, comment=?, scode=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(7, mapping.getId());
            }
            ps.setInt(1, mapping.getChannelId());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)mapping.getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)mapping.getDateTo()));
            ps.setString(4, mapping.getChannelCode());
            ps.setString(5, mapping.getComment());
            ps.setInt(6, mapping.getServerCode());
            ps.executeUpdate();
            if (mapping.getId() <= 0) {
                mapping.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public ChannelMapping getMappingById(int id) throws BGException {
        ChannelMapping result = null;
        try {
            String query = "SELECT * FROM channel_mapping_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = new ChannelMapping();
                this.loadFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<ChannelMapping> getChannelMappingList(int channelId) throws BGException {
        ArrayList<ChannelMapping> result = new ArrayList<ChannelMapping>();
        try {
            String query = "SELECT * FROM channel_mapping_" + this.mid + " WHERE chid=? ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, channelId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ChannelMapping props = new ChannelMapping();
                this.loadFromRS(rs, props);
                result.add(props);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<ChannelMapping> getChannelMappingList(Date date) throws BGException {
        ArrayList<ChannelMapping> result = new ArrayList<ChannelMapping>();
        try {
            String query = "SELECT * FROM channel_mapping_" + this.mid + " WHERE (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ChannelMapping props = new ChannelMapping();
                this.loadFromRS(rs, props);
                result.add(props);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void deleteMapping(int id) throws BGException {
        try {
            String query = "DELETE FROM channel_mapping_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteChannelMappings(int channelId) throws BGException {
        try {
            String query = "DELETE FROM channel_mapping_" + this.mid + " WHERE chid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, channelId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public ChannelMapping findConflictMapping(ChannelMapping mapping) throws BGException {
        ChannelMapping result = null;
        try {
            String query = "SELECT * FROM channel_mapping_" + this.mid + " WHERE id!=? AND chcode=? AND scode=? AND (date1 IS NULL OR ? IS NULL OR date1<=?) AND (date2 IS NULL OR ? IS NULL OR date2>=?) LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mapping.getId());
            ps.setString(2, mapping.getChannelCode());
            ps.setInt(3, mapping.getServerCode());
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)mapping.getDateTo()));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)mapping.getDateTo()));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)mapping.getDateFrom()));
            ps.setDate(7, TimeUtils.convertDateToSqlDate((Date)mapping.getDateFrom()));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ChannelMapping();
                this.loadFromRS(rs, result);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private void loadFromRS(ResultSet rs, ChannelMapping mapping) throws SQLException {
        mapping.setId(rs.getInt("id"));
        mapping.setChannelId(rs.getInt("chid"));
        mapping.setDateFrom((Date)rs.getDate("date1"));
        mapping.setDateTo((Date)rs.getDate("date2"));
        mapping.setChannelCode(rs.getString("chcode"));
        mapping.setServerCode(rs.getInt("scode"));
        mapping.setComment(rs.getString("comment"));
    }
}

