/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.common;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class JSONSerializationUtils {
    public static <T> List<T> convertJsonToList(String json, Class<T> classType) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, classType);
        try {
            JSONArray jsonArray = new JSONArray(json);
            StringReader stringReader = new StringReader(jsonArray.toString());
            return (List)mapper.readValue((Reader)stringReader, (JavaType)javaType);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static String serializateListToString(List<?> list) {
        if (Utils.isEmptyCollection(list)) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            new ObjectMapper().writeValue((Writer)stringWriter, list);
        }
        catch (IOException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return stringWriter.toString();
    }
}

