/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.pattern.editors;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigBaseEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigTitle;

public class ConfigNumberEditor
extends ConfigBaseEditor {
    private BGTextField textField = new BGTextField();
    private String limit = new String();

    public ConfigNumberEditor() {
        this.addComp(this.textField);
    }

    public String showDialog(ConfigTitle selectTitle) {
        this.textField.setText(selectTitle.getValue());
        this.textField.setColumns(50);
        if (!selectTitle.isBold()) {
            this.textField.setEnabled(false);
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
            this.textField.setEnabled(true);
        }
        this.limit = new String(selectTitle.getValidText());
        this.pack();
        this.setResizable(false);
        this.moveWindowToCenterScreen();
        this.originalValue = selectTitle.getValue();
        this.result = "cancel";
        this.defaultValue = selectTitle.getDefaultValue();
        return super.showDialog();
    }

    private static boolean checkLimit(String limit) {
        Pattern pattern = Pattern.compile("(-?\\d+(?:\\.\\d+)?)(--?\\d+(?:\\.\\d+)?)?(;(-?\\d+(?:\\.\\d+)?)(--?\\d+(?:\\.\\d+)?))*");
        Matcher m = pattern.matcher(limit);
        return m.matches();
    }

    @Override
    public boolean checkValue(String valueStr) {
        return ConfigNumberEditor.checkValue(valueStr, this.limit);
    }

    public static boolean checkValue(String valueStr, String limit) {
        try {
            BigDecimal value = new BigDecimal(valueStr);
            boolean result = true;
            if (ConfigNumberEditor.checkLimit(limit)) {
                result = false;
                String[] masLim = limit.indexOf(";") != -1 ? limit.split(";") : new String[]{limit};
                for (String lim : masLim) {
                    int ind = lim.indexOf("-", 1);
                    if (ind != -1) {
                        BigDecimal dounLimit = new BigDecimal(lim.substring(0, ind));
                        BigDecimal upLimit = new BigDecimal(lim.substring(++ind));
                        if (value.compareTo(dounLimit) == -1 || value.compareTo(upLimit) == 1) continue;
                        result = true;
                        break;
                    }
                    BigDecimal upLimit = new BigDecimal(lim);
                    if (value.compareTo(upLimit) == 1) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

