/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.task;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.TimeUtils;

public class ClearStatisticTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        this.getLogger().info("\u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0447\u0438\u0441\u0442\u043a\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043e\u043a \u0421\u041e\u0420\u041c");
        ServerContext serverContext = (ServerContext)ServerContext.get();
        try {
            SormService sormService = (SormService)serverContext.getService(SormService.class, this.getModuleId());
            List<SormProject> projects = this.defineSormProjectsForClearingStatistic(sormService);
            for (SormProject sormProject : projects) {
                this.getLogger().info("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430: " + sormProject.getTitle());
                int doNotDeleteLastDays = this.taskSetup.getInt("doNotDeleteLastDays", 0);
                if (doNotDeleteLastDays <= 0) {
                    sormService.clearStatisticOfProject(sormProject.getId(), null);
                    continue;
                }
                this.getLogger().info("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0437\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 " + doNotDeleteLastDays + " \u0434\u043d\u0435\u0439");
                Date date = TimeUtils.convertLocalDateToDate((LocalDate)LocalDate.now().minus(doNotDeleteLastDays, ChronoUnit.DAYS));
                sormService.clearStatisticOfProject(sormProject.getId(), date);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0447\u0438\u0441\u0442\u0438\u043a\u0435 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438: " + String.valueOf(ex));
        }
    }

    private List<SormProject> defineSormProjectsForClearingStatistic(SormService sormService) throws Exception {
        ArrayList<SormProject> projects = new ArrayList<SormProject>(3);
        int sormProjectId = this.taskSetup.getInt("sormProjectId", 0);
        if (sormProjectId > 0) {
            SormProject sormProject = sormService.getSormProject(sormProjectId);
            if (sormProject != null) {
                projects.add(sormProject);
            }
        } else {
            projects.addAll(sormService.getSormProjects());
        }
        return projects;
    }

    public String getDescription() {
        return "\u0421\u041e\u0420\u041c. \u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438";
    }

    public List<TaskParameter> taskParameters() {
        return List.of(new TaskParameter().setKey("sormProjectId").setTitle("sormProjectId").setDefaultValue("0"), new TaskParameter().setKey("doNotDeleteLastDays").setTitle("sormProjectId").setDefaultValue("0"));
    }
}

