/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.mobile.reports;

import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileParamType;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReport;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReportType;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.Slice;
import ru.bitel.common.TimeUtils;

public class Test1
extends MobileReport {
    @Override
    public MobileReportType getReportType(Connection con) {
        ArrayList<MobileParamType> list = new ArrayList<MobileParamType>();
        list.add(new MobileParamType("flag1", 5, "\u041f\u043e \u0434\u043d\u044f\u043c", "false"));
        list.add(new MobileParamType("Date1", 1, "\u041e\u0442 \u0434\u0430\u0442\u044b", "01.09.2014"));
        list.add(new MobileParamType("Date2", 1, "\u0414\u043e \u0434\u0430\u0442\u044b", "07.09.2014"));
        return new MobileReportType("\u041f\u0440\u0438\u0445\u043e\u0434\u044b( \u0433\u0438\u0441\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0430 )", list);
    }

    @Override
    public List<Object> getData() throws BGIllegalArgumentException {
        this.grafType = 3;
        try {
            boolean flag1 = this.getBooleanParameter("flag1", false);
            Date date1 = this.getDateParameter("Date1", new Date());
            Date date2 = this.getDateParameter("Date2", new Date());
            if (date1 == null || date2 == null && TimeUtils.dateBefore((Date)date1, (Date)date2)) {
                throw new BGIllegalArgumentException();
            }
            StringBuilder query = new StringBuilder("SELECT SUM(summa), DATE_FORMAT(dt, '");
            String periodParam = this.getParameter("period", "w");
            if (periodParam != null) {
                String format = "";
                Calendar time = Calendar.getInstance();
                flag1 = true;
                switch (periodParam) {
                    case "w": {
                        time.add(6, -7);
                        format = "%d.%m";
                        break;
                    }
                    case "m": {
                        time.add(2, -1);
                        format = "%d.%m.%y";
                        break;
                    }
                    case "q": {
                        time.add(2, -3);
                        format = "%d.%m.%y";
                        break;
                    }
                    case "y": {
                        flag1 = false;
                        time.add(1, -1);
                        format = "%m.%Y";
                    }
                }
                query.append(format);
                date1 = time.getTime();
                date2 = new Date();
            } else {
                query.append(flag1 ? "%d.%m" : "%m %Y");
            }
            query.append("'), COUNT(id) FROM contract_payment WHERE dt>=? AND dt<? GROUP BY YEAR(dt),MONTH(dt)");
            query.append(flag1 ? ",DAY(dt)" : "");
            query.append(" ORDER BY dt ASC");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date2));
            ArrayList<Object> dataList = new ArrayList<Object>();
            ResultSet rs = ps.executeQuery();
            int count = 1;
            while (rs.next()) {
                Color col = periodParam.equals("q") ? (count++ % 2 == 1 ? this.getColor(0) : this.getColor(5)) : this.getColor();
                dataList.add(new Slice(rs.getString(2), col, rs.getDouble(1)));
            }
            return dataList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, Object> getOptions() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("id", "period");
        dateMap.put("values", "w,m,q,y");
        dateMap.put("titles", "\u041d\u0435\u0434\u0435\u043b\u044f,\u041c\u0435\u0441\u044f\u0446,\u041a\u0432\u0430\u0440\u0442\u0430\u043b,\u0413\u043e\u0434");
        map.put("dataToolbar", dateMap);
        return map;
    }
}

