/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.Setup;

public class SequentialIdManager {
    private Setup setup;
    private String moduleId;

    public SequentialIdManager(Setup setup, String moduleId) {
        this.moduleId = moduleId;
        this.setup = setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateSequentialId() throws BGException {
        long id = 0L;
        Class<SequentialIdManager> clazz = SequentialIdManager.class;
        synchronized (SequentialIdManager.class) {
            try (Connection con = this.setup.getDBConnectionFromPool();){
                PreparedStatement ps = con.prepareStatement("SELECT value FROM sequential_ids WHERE mid=?");
                ps.setString(1, this.moduleId);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    id = rs.getLong(1);
                }
                rs.close();
                ps.close();
                ps = con.prepareStatement(++id > 1L ? "UPDATE sequential_ids SET value=value+1 WHERE mid=?" : "INSERT INTO sequential_ids SET value=1, mid=?");
                ps.setString(1, this.moduleId);
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException("sql error", (Throwable)e);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return id;
        }
    }
}

