/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class TruncableDebugOutputStream
extends OutputStream {
    private int maxLenStr = 1500;
    private int currentTotalLen = 0;
    private byte[] buffer;

    public TruncableDebugOutputStream(int maxLenStr) {
        this.maxLenStr = maxLenStr;
        this.buffer = new byte[maxLenStr];
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        int bytesRemainToCopy = Math.min(this.maxLenStr - this.currentTotalLen, len);
        if (bytesRemainToCopy > 0) {
            System.arraycopy(b, off, this.buffer, this.currentTotalLen, bytesRemainToCopy);
        }
        this.currentTotalLen += len;
    }

    public int getTotalLength() {
        return this.currentTotalLen;
    }

    public String getString() {
        int bufferRealLen = Math.min(this.maxLenStr, this.currentTotalLen);
        return new String(this.buffer, 0, bufferRealLen, StandardCharsets.UTF_8);
    }
}

