/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.traffic;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.common.TimeUtils;

public class AddressUseCache {
    private Map<Long, Map<Long, List<CacheEntry>>> dataMap = new HashMap<Long, Map<Long, List<CacheEntry>>>();
    private Map<Long, List<CacheEntry>> currentHourMap;

    public void clearData() {
        this.dataMap.clear();
    }

    public void addCacheEntry(long address, long fromTimeStamp, long toTimeStamp, int sessionId, String realm, String port, int contractId) {
        GregorianCalendar hour = new GregorianCalendar();
        hour.setTimeInMillis(fromTimeStamp);
        TimeUtils.clear_MIN_MIL_SEC((Calendar)hour);
        GregorianCalendar endTime = new GregorianCalendar();
        endTime.setTimeInMillis(toTimeStamp);
        TimeUtils.clear_MIN_MIL_SEC((Calendar)endTime);
        while (!hour.after(endTime)) {
            List<CacheEntry> addressUseList;
            Map<Long, List<CacheEntry>> hourMap = this.dataMap.get(hour.getTimeInMillis());
            if (hourMap == null) {
                hourMap = new HashMap<Long, List<CacheEntry>>(1000, 100.0f);
                this.dataMap.put(hour.getTimeInMillis(), hourMap);
            }
            if ((addressUseList = hourMap.get(address)) == null) {
                addressUseList = new ArrayList<CacheEntry>();
                hourMap.put(address, addressUseList);
            }
            CacheEntry entry = new CacheEntry();
            entry.fromTime = fromTimeStamp;
            entry.toTime = toTimeStamp;
            entry.sessionId = sessionId;
            entry.realm = realm;
            entry.port = port;
            entry.contractId = contractId;
            addressUseList.add(entry);
            ((Calendar)hour).add(11, 1);
        }
    }

    public void setHour(long hour) {
        this.currentHourMap = this.dataMap.get(hour);
    }

    public CacheEntry getAddessSession(long time, long address) {
        List<CacheEntry> entryList;
        CacheEntry result = null;
        if (this.currentHourMap != null && (entryList = this.currentHourMap.get(address)) != null) {
            for (CacheEntry entry : entryList) {
                if (entry.fromTime > time || time > entry.toTime) continue;
                result = entry;
                break;
            }
        }
        return result;
    }

    public static class CacheEntry {
        public long fromTime;
        public long toTime;
        public int sessionId;
        public int contractId;
        public String realm;
        public String port;
    }
}

