/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.domain.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.jws.WebService;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.event.DomainModifiedEvent;
import ru.bitel.oss.kernel.directories.domain.common.service.DomainService;
import ru.bitel.oss.kernel.directories.domain.server.bean.DomainDao;

@WebService(endpointInterface="ru.bitel.oss.kernel.directories.domain.common.service.DomainService")
public class DomainServiceImpl
extends AbstractService
implements DomainService {
    private DomainDao domainDao;
    private Directory<Domain> domainDir;

    @PostConstruct
    void init() {
        this.domainDao = new DomainDao(this.getConnection());
        try {
            this.domainDir = this.context.getDirectory(Domain.class, 0);
        }
        catch (BGException ex) {
            BGLogger.error(ex);
        }
    }

    @PreDestroy
    void destroy() {
        try {
            this.domainDao.close();
        }
        catch (BGException ex) {
            BGLogger.error(ex);
        }
    }

    public int domainUpdate(Domain domain) throws BGException {
        try {
            this.domainDir.update(domain);
            return domain.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public Domain domainGet(int id) throws BGException {
        return this.domainDir.get(id);
    }

    public List<Domain> domainList() throws Exception {
        return this.domainDir.list();
    }

    public void domainDelete(int id) throws BGException {
        try {
            this.domainDir.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public Domain domainTree() throws Exception {
        return this.domainDao.tree();
    }

    public void domainMove(int newParentId, Set<Integer> children) throws Exception {
        this.domainDao.move(newParentId, children);
        this.context.publishAfterCommit((Event)new DomainModifiedEvent(0, this.userId, null, null));
    }
}

