/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectTypeParameter;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ObjectTypeParamDirectory
extends BGPanel
implements ActionListener {
    private BGUList<BGUListItem> typeList = new BGUList();
    private BGUComboBox<IdTitle> paramSelectComboBox = new BGUComboBox();
    private JPanel editor = new JPanel(new GridBagLayout());
    private ObjectTypeParamTableModel tableModel = new ObjectTypeParamTableModel(ObjectTypeParamTableModel.class.getName());
    private ContractObjectService contractObjectService;

    public ObjectTypeParamDirectory() {
        this.jbInit();
        this.editor.setVisible(false);
    }

    private void jbInit() {
        BGUTable paramTable = new BGUTable((TableModel)((Object)this.tableModel));
        paramTable.setSelectionMode(0);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons((ActionListener)this);
        toolBar.setToolBar(new String[]{"newItem", "deleteItem", "separator", "upItem", "downItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        JPanel paramViewer = new JPanel(new GridBagLayout());
        paramViewer.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        paramViewer.add((Component)new JScrollPane((Component)paramTable), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramViewer.add((Component)this.editor, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGSplitPaneNoBorder mainSplit = new BGSplitPaneNoBorder(0, (Component)new JScrollPane((Component)this.typeList), (Component)paramViewer, 500L);
        this.editor.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)this.paramSelectComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 10), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopParamAdd(e.getActionCommand().equals("ok")));
        this.editor.add((Component)okCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.typeList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.showParams();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() throws Exception {
        this.typeList.setData(this.getContractObjectService().objectTypeList(false).stream().map(a -> new BGUListItem((IdTitle)a)).toList());
    }

    private void showParams() {
        this.typeList.optSelectedValue().ifPresent(item -> {
            try {
                this.tableModel.setData(this.getContractObjectService().objectTypeParameterList(item.getId()));
                this.editor.setVisible(false);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }

    private void startParamAdd() {
        this.typeList.optSelectedValue().ifPresent(item -> {
            try {
                ArrayList<IdTitle> avaliableTypes = new ArrayList<IdTitle>();
                avaliableTypes.add(new IdTitle(-1, "---"));
                avaliableTypes.addAll(this.getContractObjectService().getAvailableTypeForObjectType(item.getId()));
                this.paramSelectComboBox.setData(avaliableTypes);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.editor.setVisible(true);
        });
    }

    private void stopParamAdd(boolean add) {
        if (add) {
            int selectedParameterId = ((IdTitle)this.paramSelectComboBox.getSelectedItem()).getId();
            if (selectedParameterId <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
                return;
            }
            this.typeList.optSelectedValue().ifPresent(item -> {
                try {
                    this.getContractObjectService().updateLinkParameterWithObjectType(item.getId(), selectedParameterId, true);
                    this.editor.setVisible(false);
                    this.showParams();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            });
        } else {
            this.editor.setVisible(false);
        }
    }

    private void deleteParam() {
        this.tableModel.optSelectedRow().ifPresent(objectTypeParameter -> {
            if (!ClientUtils.confirmDelete((Object)"\u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u043a \u0442\u0438\u043f\u0443")) {
                return;
            }
            this.typeList.optSelectedValue().ifPresent(type -> {
                try {
                    this.getContractObjectService().updateLinkParameterWithObjectType(type.getId(), objectTypeParameter.getParameterId(), false);
                    this.showParams();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            });
        });
    }

    private void move(boolean up) {
        int typeId = this.typeList.optSelectedValue().map(a -> a.getId()).orElse(-1);
        int objectTypeParameterId = this.tableModel.optSelectedRow().map(a -> a.getParameterId()).orElse(-1);
        if (typeId > 0 && objectTypeParameterId > 0) {
            try {
                this.getContractObjectService().parameterMoving(typeId, objectTypeParameterId, up);
                this.showParams();
                List rows = this.tableModel.getRows();
                for (int i = rows.size() - 1; i >= 0; --i) {
                    if (objectTypeParameterId != ((ObjectTypeParameter)rows.get(i)).getParameterId()) continue;
                    this.tableModel.setSelectedRow((ObjectTypeParameter)rows.get(i));
                    break;
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command != null) {
            if (command.equals("newItem")) {
                this.startParamAdd();
            } else if (command.equals("deleteItem")) {
                this.deleteParam();
            } else if (command.equals("upItem")) {
                this.move(true);
            } else if (command.equals("downItem")) {
                this.move(false);
            }
        }
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = (ContractObjectService)this.getContext().getWebService(ContractObjectService.class, 0);
        }
        return this.contractObjectService;
    }

    class ObjectTypeParamTableModel
    extends BGTableModel<ObjectTypeParameter> {
        public ObjectTypeParamTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("ID", 80, 80, 80, "parameterId", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0422\u0438\u043f", 150, 150, 150, "parameterTypeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", -1, -1, -1, "parameterTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

