/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.client.BotManagerPanel;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;

public class BotListPanel
extends BGUPanel {
    private BGUList<Bot> botList = new BGUList();
    private JScrollPane botListScrollPane = new JScrollPane();
    private BotEditor botEditor;
    private BotManagerPanel parentPanel;

    public BotListPanel(BotManagerPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.botList.setCellRenderer((ListCellRenderer)new BotListCellRenderer());
        this.botListScrollPane.getViewport().add((Component)this.botList);
        this.botList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BotListPanel.this.botList.isEnabled() && e.getClickCount() == 2 && e.getButton() == 1) {
                    BotListPanel.this.botEditor.editBot((Bot)BotListPanel.this.botList.getSelectedValue());
                    BotListPanel.this.showListBotPanel(false);
                }
            }
        });
        this.botEditor = new BotEditor();
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0421\u043f\u0438\u0441\u043e\u043a \u0431\u043e\u0442\u043e\u0432");
        this.add(this.botListScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.botEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void showListBotPanel(boolean showListBotPanel) {
        this.botEditor.setVisible(!showListBotPanel);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "refresh"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                BotListPanel.this.botList.setData(BotListPanel.this.parentPanel.getService().getBots());
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "new"){

            public void actionPerformedImpl(ActionEvent e) {
                BotListPanel.this.botEditor.editBot(null);
                BotListPanel.this.showListBotPanel(false);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "edit"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Bot bot = (Bot)BotListPanel.this.botList.getSelectedValue();
                if (bot == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0431\u043e\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                } else {
                    BotListPanel.this.botEditor.editBot(bot);
                    BotListPanel.this.showListBotPanel(false);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "delete"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Bot bot = (Bot)BotListPanel.this.botList.getSelectedValue();
                if (bot != null && BGSwingUtilites.confirmDelete((String)("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + bot.getTitle() + "?"))) {
                    if (bot.getState() == 1 && BGSwingUtilites.confirmDelete((String)"\u0411\u043e\u0442 \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438. \u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0438 \u0443\u0434\u0430\u043b\u0438\u0442\u044c?")) {
                        BotListPanel.this.parentPanel.getService().deleteBot(bot.getId());
                    } else {
                        BotListPanel.this.parentPanel.getService().deleteBot(bot.getId());
                    }
                }
                BotListPanel.this.performAction("refresh");
            }
        };
    }

    private static class BotListCellRenderer
    implements ListCellRenderer<Bot> {
        private BotListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Bot> list, Bot bot, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel title = new JLabel(bot.getTitle());
            title.setFont(new Font("Monospaced", 0, 20));
            JLabel botId = new JLabel("ID: " + bot.getId());
            botId.setFont(new Font("SansSerif", 0, 11));
            JLabel state = new JLabel(bot.getState() == 1 ? "\u0412\u043a\u043b\u044e\u0447\u0435\u043d" : "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
            state.setFont(new Font("Dialog", 0, 15));
            state.setForeground(bot.getState() == 1 ? Color.GREEN : Color.RED);
            JLabel typeBot = new JLabel(bot.getBotType().getGuiTitle());
            typeBot.setFont(new Font("Dialog", 0, 10));
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0);
            JPanel renderedPanel = new JPanel(new GridBagLayout());
            renderedPanel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            renderedPanel.add((Component)title, constraints);
            renderedPanel.add((Component)botId, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            renderedPanel.add((Component)typeBot, constraints);
            constraints.anchor = 13;
            --constraints.gridy;
            renderedPanel.add((Component)state, constraints);
            return renderedPanel;
        }
    }

    private class BotEditor
    extends JPanel {
        JTextField title = new JTextField("\u0418\u043c\u044f");
        JTextField token = new JTextField("\u0422\u043e\u043a\u0435\u043d");
        BGUComboBox<BotType> botType = new BGUComboBox();
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        JCheckBox enable = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
        Bot currentBot;

        BotEditor() {
            this.setVisible(false);
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u043e\u0442\u0430");
            this.botType.setData(Arrays.asList(BotType.values()));
            this.okCancelPanel.addActionListener(e -> {
                if (e.getActionCommand().equals("ok")) {
                    String title = this.title.getText();
                    if (Utils.isBlankString((String)title)) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0431\u043e\u0442\u0430");
                        return;
                    }
                    String token = this.token.getText();
                    if (Utils.isBlankString((String)token)) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u043e\u043a\u0435\u043d");
                        return;
                    }
                    if (this.currentBot == null) {
                        this.currentBot = new Bot();
                    }
                    this.currentBot.setTitle(title);
                    this.currentBot.setToken(token);
                    this.currentBot.setBotType((BotType)this.botType.getSelectedItem());
                    this.currentBot.setState(this.enable.isSelected() ? 1 : 0);
                    try {
                        BotListPanel.this.parentPanel.getService().updateBot(this.currentBot);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                BotListPanel.this.showListBotPanel(true);
                BotListPanel.this.performAction("refresh");
            });
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0);
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), constraints);
            this.add((Component)this.title, constraints);
            this.add((Component)new JLabel("\u0422\u043e\u043a\u0435\u043d"), constraints);
            this.add((Component)this.token, constraints);
            this.add((Component)new JLabel("\u0422\u0438\u043f \u0431\u043e\u0442\u0430"), constraints);
            this.add((Component)this.botType, constraints);
            this.add((Component)this.enable, constraints);
            constraints.anchor = 14;
            this.add((Component)this.okCancelPanel, constraints);
        }

        private void editBot(Bot bot) {
            if (bot != null) {
                this.currentBot = bot;
                this.title.setText(bot.getTitle());
                this.token.setText(bot.getToken());
                this.botType.setSelectedItem((Object)bot.getBotType());
                this.enable.setSelected(bot.getState() == 1);
            } else {
                this.currentBot = null;
                this.title.setText("");
                this.token.setText("");
                this.botType.setSelectedIndex(0);
                this.enable.setSelected(false);
            }
            this.setVisible(true);
        }
    }
}

