/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.AWTViewer;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;

public class AWTViewerWithControls
extends JPanel {
    private AWTViewer viewer = new AWTViewer();
    private JComboBox<ComboBoxItem> scale = new JComboBox();
    private JButton printButton = new JButton();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();

    public AWTViewerWithControls() {
        this.pagePanel.setKey(this.getClass().getName());
        this.printButton.setText("\u041f\u0435\u0447\u0430\u0442\u044c");
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.add((Component)new JLabel(" \u0420\u0430\u0437\u043c\u0435\u0440: "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add(this.scale, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)this.printButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel1.add((Component)this.pagePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel1.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.scale.removeAllItems();
        this.scale.addItem(new ComboBoxItem(25, "25"));
        this.scale.addItem(new ComboBoxItem(50, "50"));
        this.scale.addItem(new ComboBoxItem(75, "75"));
        this.scale.addItem(new ComboBoxItem(100, "100"));
        this.scale.addItem(new ComboBoxItem(125, "125"));
        this.scale.addItem(new ComboBoxItem(150, "150"));
        this.scale.addItem(new ComboBoxItem(175, "175"));
        this.scale.addItem(new ComboBoxItem(200, "200"));
        this.scale.setSelectedItem("100");
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.viewer, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.printButton.addActionListener(e -> this.print_actionPerformed(e));
        this.scale.addItemListener(e -> this.scale_itemStateChanged(e));
        this.pagePanel.addPropertyChangeListener(e -> this.pages_propertyChange(e));
        try {
            this.viewer.setScaleFactor(1.0);
        }
        catch (BGException bGException) {
            // empty catch block
        }
    }

    private void scale_itemStateChanged(ItemEvent e) {
        ComboBoxItem selectedScaleValue;
        if (e.getStateChange() != 2 && (selectedScaleValue = (ComboBoxItem)this.scale.getSelectedItem()) != null) {
            try {
                String scaleString = (String)selectedScaleValue.getObject();
                this.viewer.setScaleFactor((double)Integer.valueOf(scaleString).intValue() / 100.0);
            }
            catch (Exception ex) {
                ClientUtils.showMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043c\u0430\u0441\u0448\u0442\u0430\u0431\u0430 (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
            }
        }
    }

    private void pages_propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName != null && e.getPropertyName().startsWith("to")) {
            try {
                this.viewer.showPage(this.pagePanel.getPageIndex() - 1);
            }
            catch (BGException ex) {
                ClientUtils.showMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b " + this.pagePanel.getPageIndex() + " (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
            }
        }
    }

    private void print_actionPerformed(ActionEvent e) {
        this.viewer.print();
    }

    public void show(Document doc) {
        try {
            this.viewer.setData(doc);
            this.pagePanel.setPageIndex(1);
            this.pagePanel.setPageCount(this.viewer.getNumberOfPages() > 0 ? this.viewer.getNumberOfPages() : 1);
        }
        catch (Exception ex) {
            ClientUtils.showMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043a\u0430\u0437\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
        }
    }
}

