/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.nas;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasDialup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class NasManager {
    private Connection con;
    private int moduleId;
    private static Logger log = LogManager.getLogger();

    public NasManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    public NasDialup getNasById(int id) {
        NasDialup result = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM nas_" + this.moduleId + " WHERE id=?");){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getNasFromRs(rs);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<NasDialup> getNasList(Calendar date) {
        ArrayList<NasDialup> result = new ArrayList<NasDialup>();
        StringBuffer query = new StringBuffer("SELECT * FROM nas_");
        query.append(this.moduleId);
        if (date != null) {
            query.append(" WHERE (( date1 IS NULL) OR ( ? IS NULL ) OR (date1 <= ? ) )");
            query.append(" AND ( (date2 IS NULL) OR ( ? IS NULL ) OR (date2 >= ? ) ) ");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (date != null) {
                Date dt = TimeUtils.convertCalendarToSqlDate((Calendar)date);
                ps.setDate(1, dt);
                ps.setDate(2, dt);
                ps.setDate(3, dt);
                ps.setDate(4, dt);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getNasFromRs(rs));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private NasDialup getNasFromRs(ResultSet rs) throws SQLException {
        NasDialup nas = new NasDialup();
        nas.setId(rs.getInt("id"));
        nas.setIpAddr(rs.getLong("ipaddr"));
        nas.setIdentifier(rs.getString("identifier"));
        nas.setVendor(rs.getInt("vendor"));
        nas.setSecret(rs.getString("secret"));
        nas.setConfigId(rs.getInt("config_id"));
        nas.setCommonConfigIds(rs.getString("common_config_id"));
        nas.setScript(rs.getString("script"));
        return nas;
    }

    public void setNasConfig(NasDialup nas) {
        if (this.moduleId < 0 || nas.getConfigId() < 0) {
            log.error("Error in NAS.loadConfig() mid < 0 or configId < 0");
            return;
        }
        try {
            StringBuilder setupString = new StringBuilder(150);
            String query = "SELECT config FROM nas_config_" + this.moduleId + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            for (Integer id : Utils.toIntegerList((String)nas.getCommonConfigIds())) {
                ps.setInt(1, id);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && rs.getString(1) != null) {
                    setupString.append("\r\n");
                    setupString.append(rs.getString(1));
                }
                rs.close();
            }
            ps.setInt(1, nas.getConfigId());
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getString(1) != null) {
                setupString.append("\r\n");
                setupString.append(rs.getString(1));
            }
            rs.close();
            ps.close();
            Preferences result = new Preferences(setupString.toString(), "\r\n");
            nas.setConfig(result);
            nas.setConfigString(setupString.toString());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

