/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.common;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionPeriodType;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftlineProductDao;
import ru.bitel.common.TimeUtils;

public class SoftLineUtils {
    public static boolean checkActivation(Connection con, SoftLineSubscription subscription, SoftLineProduct product) throws BGException {
        BalanceUtils balanceUtils = new BalanceUtils(con);
        BigDecimal balance = balanceUtils.getBalance(LocalDate.now(), subscription.getContractId());
        balanceUtils.close();
        ContractManager contractManager = new ContractManager(con);
        Contract contract = contractManager.getContractById(subscription.getContractId());
        BigDecimal balanceLimit = contract.getBalanceLimit();
        BigDecimal priceOfPeriod = product.getPrice();
        if (balance.subtract(balanceLimit).compareTo(priceOfPeriod) > 0) {
            if (product.getPeriodType() == SoftLineSubscriptionPeriodType.DAY && balance.compareTo(priceOfPeriod = priceOfPeriod.multiply(new BigDecimal(product.getAmountOfDays()))) > 0) {
                return true;
            }
            return true;
        }
        return false;
    }

    public static void addContractAccount(Connection con, int moduleId, SoftLineSubscription subscription, Date date) throws Exception {
        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
            SoftLineProduct product = (SoftLineProduct)new SoftlineProductDao(con, moduleId).get(subscription.getProductId());
            balanceUtils.addContractAccount(subscription.getContractId(), TimeUtils.convertDateToLocalDate((Date)date), product.getServiceId(), product.getPrice());
            balanceUtils.updateBalance(date, subscription.getContractId());
        }
    }

    public static boolean checkTodayDate(Date date) {
        Calendar now = Calendar.getInstance();
        Calendar endDate = TimeUtils.convertDateToCalendar((Date)date);
        return now.get(1) == endDate.get(1) && now.get(2) == endDate.get(2) && now.get(5) == endDate.get(5);
    }

    public static void prolongationDateEndSubscription(SoftLineSubscription subscription, SoftLineProduct product) {
        Calendar endDate = SoftLineUtils.checkTodayDate(subscription.getEndDate()) ? TimeUtils.convertDateToCalendar((Date)subscription.getEndDate()) : Calendar.getInstance();
        switch (product.getPeriodType()) {
            case DAY: {
                endDate.add(5, subscription.getPeriodCount());
                break;
            }
            case MONTH: {
                endDate.add(2, 1);
                break;
            }
            case YEAR: {
                endDate.add(1, 1);
            }
        }
        subscription.setEndDate(TimeUtils.convertCalendarToDate((Calendar)endDate));
    }

    public static void setEndDate(SoftLineSubscription subscription, SoftLineProduct product) {
        Calendar dateTo = TimeUtils.convertDateToCalendar((Date)subscription.getStartDate());
        switch (product.getPeriodType()) {
            case DAY: {
                dateTo.add(5, subscription.getPeriodCount());
                break;
            }
            case MONTH: {
                dateTo.add(2, 1);
                break;
            }
            case YEAR: {
                dateTo.add(1, 1);
            }
        }
        subscription.setEndDate(TimeUtils.convertCalendarToDate((Calendar)dateTo));
    }
}

