/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DataExtractor
extends BGLogger {
    protected int getIntParam(List<String> paramList, int pos) {
        return Utils.parseInt((String)paramList.get(pos));
    }

    protected Calendar getMonthParam(Calendar month, List<String> paramList, int pos) {
        return BillUtil.moveDate(month, paramList.get(pos));
    }

    protected String getIdsFromEnd(int posFrom, List<String> paramList) {
        StringBuilder sids = new StringBuilder();
        for (int i = posFrom; i < paramList.size(); ++i) {
            if (sids.length() > 0) {
                sids.append(",");
            }
            sids.append(paramList.get(i));
        }
        return sids.toString();
    }

    protected BigDecimal getSumFromTable(Connection con, String tableName, String col, String cids, String sids, String filter, String cidFieldName, String sidFieldName) throws SQLException {
        BigDecimal result = BigDecimal.ZERO;
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            StringBuilder query = new StringBuilder(300).append("SELECT SUM(").append(col).append(") FROM ").append(tableName).append(" WHERE " + cidFieldName + " IN ( ").append(cids).append(" ) ");
            if (sids.length() > 0) {
                query.append(" AND " + sidFieldName + " IN ( ").append(sids).append(" )");
            }
            if (Utils.notBlankString((String)filter)) {
                query.append(" AND ").append(filter);
            }
            try (PreparedStatement ps = con.prepareStatement(query.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getBigDecimal(1);
                }
            }
        }
        return result;
    }

    protected long getCountFromTable(Connection con, String tableName, String cids, Calendar month, String filter) throws SQLException {
        return this.getCountFromTable(con, tableName, cids, month, filter, "cid", "date1", "date2");
    }

    protected long getCountFromTable(Connection con, String tableName, String cids, Calendar month, String filter, String cidFieldName, String date1Field, String date2Field) throws SQLException {
        long result = 0L;
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(*) FROM ");
            query.append(tableName);
            query.append(" WHERE " + cidFieldName + " IN ( ");
            query.append(cids);
            query.append(" ) ");
            if (month != null) {
                query.append("AND ( " + date1Field + " IS NULL OR " + date1Field + " <= ? )");
                query.append(" AND (" + date2Field + " IS NULL OR " + date2Field + ">= ?)");
            }
            if (Utils.notBlankString((String)filter)) {
                query.append(filter);
            }
            PreparedStatement ps = con.prepareStatement(query.toString());
            if (month != null) {
                ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)month));
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)month));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getLong(1);
            }
            rs.close();
            ps.close();
        }
        return result;
    }

    protected BigDecimal getAmount(Connection con, String table, String col, List<String> paramList, Calendar month, String cids) {
        return this.getAmount(con, table, col, paramList, month, cids, null);
    }

    protected BigDecimal getAmount(Connection con, String table, String col, List<String> paramList, Calendar month, String cids, String filter) {
        return this.getAmount(con, table, col, paramList, month, cids, filter, "cid", "sid");
    }

    protected BigDecimal getAmount(Connection con, String table, String col, List<String> paramList, Calendar month, String cids, String filter, String cidFieldName, String sidFieldName) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            if (paramList.size() >= 3) {
                int moduleId = this.getIntParam(paramList, 0);
                month = this.getMonthParam(month, paramList, 1);
                String sids = this.getIdsFromEnd(3, paramList);
                String tableName = ServerUtils.getModuleMonthTableName((String)table, (Date)month.getTime(), (int)moduleId);
                BigDecimal subresult = this.getSumFromTable(con, tableName, col, cids, sids, filter, cidFieldName, sidFieldName);
                if (subresult != null) {
                    String param = paramList.get(2);
                    BigDecimal divisor = Utils.parseBigDecimal((String)param.replaceFirst(":\\d*", ""), (BigDecimal)BigDecimal.ONE);
                    int scale = Utils.parseInt((String)param.replaceFirst("\\d+:?", ""), (int)0);
                    result = divisor.compareTo(BigDecimal.ZERO) > 0 ? subresult.divide(divisor, scale, RoundingMode.HALF_UP) : subresult;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected BigDecimal getCountSession(Connection con, String table, List<String> paramList, Calendar month, String cids, String filter) {
        return this.getCountSession(con, table, paramList, month, cids, filter, "cid", "sid");
    }

    protected BigDecimal getCountSession(Connection con, String table, List<String> paramList, Calendar month, String cids, String filter, String cidFieldName, String sidFieldName) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            if (paramList.size() >= 2) {
                int mid = this.getIntParam(paramList, 0);
                month = this.getMonthParam(month, paramList, 1);
                String sids = this.getIdsFromEnd(2, paramList);
                String tableName = ServerUtils.getModuleMonthTableName((String)table, (Date)month.getTime(), (int)mid);
                if (sids.length() > 0) {
                    filter = "AND " + sidFieldName + " IN ( " + sids + " )" + (String)(Utils.notBlankString((String)filter) ? " AND " + (String)filter : "");
                }
                result = BigDecimal.valueOf(this.getCountFromTable(con, tableName, cids, null, (String)filter, cidFieldName, "dateFrom", "dateTo"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

