/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.paymaster.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.paymaster.server.service.PayMasterServiceImpl;
import ru.bitel.bgbilling.modules.paymaster.server.worker.PaymasterAutopaymentEventWorker;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.paymaster.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), PayMasterServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        new PaymasterAutopaymentEventWorker(module.getId());
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "paymaster", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent) {
                ContractDeleteEvent contractDeleteEvent = (ContractDeleteEvent)event;
                if (!contractDeleteEvent.isCheck()) {
                    this.removeAutopayment(moduleId, contractId, con);
                }
            } else if (event instanceof ContractCloseEvent) {
                AutopaymentManager.unregisterAutopayment((Connection)con, (int)moduleId, (AbstractAutopaymentManager)new AutopaymentManager(con, moduleId), (int)contractId);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        methods.add(PaymentMethod.CARD);
        return methods;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

