/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import bitel.billing.server.contract.bean.ContractServiceManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.modules.hd.server.bean.HdPackage;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class HdPackageManager {
    private Connection con;
    private String tableName;

    public HdPackageManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_package_" + mid;
    }

    public HdPackage getPackage(int id) {
        HdPackage result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getPackageFromRs(rs);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deletePackage(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePackage(HdPackage service) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            if (service.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title, sid, domain, domain_zone, ns, ns_domain, ns_primary_server, ns_secondary_server, host, host_domain, host_col, host_addr, hosting, hosting_host, hosting_type,act_type, prol_type, period_act, period_prol ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, sid=?, domain=?, domain_zone=?, ns=?, ns_domain=?, ns_primary_server=?, ns_secondary_server=?,host=?, host_domain=?, host_col=?, host_addr=?, hosting=?, hosting_host=?, hosting_type=?,act_type=?, prol_type=?, period_act=?, period_prol=? WHERE id=?";
                ps = this.con.prepareStatement(query);
            }
            ps.setString(index++, service.getTitle());
            ps.setInt(index++, service.getServiceId());
            ps.setBoolean(index++, service.isDomainEnable());
            ps.setString(index++, Utils.toString(service.getDomainZoneList()));
            ps.setBoolean(index++, service.isNsEnable());
            ps.setInt(index++, service.getNsDomain());
            ps.setString(index++, Utils.toString(service.getNsServerPrimaryList()));
            ps.setString(index++, Utils.toString(service.getNsServerSecondaryList()));
            ps.setBoolean(index++, service.isHostEnable());
            ps.setInt(index++, service.getHostDomain());
            ps.setInt(index++, service.getHostCol());
            ps.setString(index++, service.getHostAddr());
            ps.setBoolean(index++, service.isHostingEnable());
            ps.setInt(index++, service.getHostingHost());
            ps.setInt(index++, service.getHostingType());
            ps.setInt(index++, service.getActivateType());
            ps.setInt(index++, service.getProlongationType());
            ps.setString(index++, Utils.toString(service.getPeriodsActivation()));
            ps.setString(index++, Utils.toString(service.getPeriodsProlongation()));
            if (service.getId() > 0) {
                ps.setInt(index++, service.getId());
            }
            ps.executeUpdate();
            if (service.getId() <= 0) {
                service.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<HdPackage> getPackageList() {
        ArrayList<HdPackage> result = new ArrayList<HdPackage>();
        try {
            String query = "SELECT *  FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getPackageFromRs(rs));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<HdPackage> getAllowedServiceList(int cid, Calendar date) {
        ArrayList<HdPackage> result = new ArrayList<HdPackage>();
        try {
            StringBuilder sids = new StringBuilder("-1");
            List serviceList = new ContractServiceManager(this.con).getContractServiceList(cid, date);
            for (ContractService contractService : serviceList) {
                sids.append(",");
                sids.append(contractService.getServiceId());
            }
            String query = "SELECT * FROM " + this.tableName + " WHERE sid IN ( " + String.valueOf(sids) + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getPackageFromRs(rs));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getTypesWithDomainsInZone(int zoneId) {
        StringBuilder sb = new StringBuilder();
        try {
            String query = "SELECT id FROM " + this.tableName + " WHERE domain AND domain_zone=?";
            this.extractCodes(zoneId, sb, query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String getTypesWithHostsInZone(int zoneId) {
        StringBuilder sb = new StringBuilder();
        try {
            String query = "SELECT id FROM " + this.tableName + " WHERE host AND host_domain=?";
            this.extractCodes(zoneId, sb, query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private void extractCodes(int zoneId, StringBuilder sb, String query) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, zoneId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(rs.getString(1));
        }
        ps.close();
    }

    private HdPackage getPackageFromRs(ResultSet rs) throws SQLException {
        HdPackage result = new HdPackage();
        result.setId(rs.getInt("id"));
        result.setServiceId(rs.getInt("sid"));
        result.setTitle(rs.getString("title"));
        result.setDomainEnable(rs.getBoolean("domain"));
        result.setDomainZoneList(Utils.toIntegerList((String)rs.getString("domain_zone")));
        result.setNsEnable(rs.getBoolean("ns"));
        result.setNsDomain(rs.getInt("ns_domain"));
        result.setNsServerPrimaryList(Utils.toIntegerList((String)rs.getString("ns_primary_server")));
        result.setNsServerSecondaryList(Utils.toIntegerList((String)rs.getString("ns_secondary_server")));
        result.setHostEnable(rs.getBoolean("host"));
        result.setHostDomain(rs.getInt("host_domain"));
        result.setHostCol(rs.getInt("host_col"));
        result.setHostAddr(rs.getString("host_addr"));
        result.setHostingEnable(rs.getBoolean("hosting"));
        result.setHostingHost(rs.getInt("hosting_host"));
        result.setHostingType(rs.getInt("hosting_type"));
        result.setActivateType(rs.getInt("act_type"));
        result.setProlongationType(rs.getInt("prol_type"));
        result.setPeriodsActivation(Utils.toIntegerList((String)rs.getString("period_act")));
        result.setPeriodsProlongation(Utils.toIntegerList((String)rs.getString("period_prol")));
        return result;
    }
}

